/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rdsdata.model.Field;
import software.amazon.awssdk.services.rdsdata.model.FieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateResult> {
    private static final SdkField<List<Field>> GENERATED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("generatedFields").getter(UpdateResult.getter(UpdateResult::generatedFields)).setter(UpdateResult.setter(Builder::generatedFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Field::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATED_FIELDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Field> generatedFields;

    private UpdateResult(BuilderImpl builder) {
        this.generatedFields = builder.generatedFields;
    }

    public boolean hasGeneratedFields() {
        return this.generatedFields != null && !(this.generatedFields instanceof SdkAutoConstructList);
    }

    public List<Field> generatedFields() {
        return this.generatedFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGeneratedFields() ? this.generatedFields() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResult)) {
            return false;
        }
        UpdateResult other = (UpdateResult)obj;
        return this.hasGeneratedFields() == other.hasGeneratedFields() && Objects.equals(this.generatedFields(), other.generatedFields());
    }

    public String toString() {
        return ToString.builder((String)"UpdateResult").add("GeneratedFields", this.hasGeneratedFields() ? this.generatedFields() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "generatedFields": {
                return Optional.ofNullable(clazz.cast(this.generatedFields()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResult, T> g) {
        return obj -> g.apply((UpdateResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Field> generatedFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResult model) {
            this.generatedFields(model.generatedFields);
        }

        public final Collection<Field.Builder> getGeneratedFields() {
            if (this.generatedFields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.generatedFields != null ? (Collection)this.generatedFields.stream().map(Field::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder generatedFields(Collection<Field> generatedFields) {
            this.generatedFields = FieldListCopier.copy(generatedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedFields(Field ... generatedFields) {
            this.generatedFields(Arrays.asList(generatedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedFields(Consumer<Field.Builder> ... generatedFields) {
            this.generatedFields(Stream.of(generatedFields).map(c -> (Field)((Field.Builder)Field.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGeneratedFields(Collection<Field.BuilderImpl> generatedFields) {
            this.generatedFields = FieldListCopier.copyFromBuilder(generatedFields);
        }

        public UpdateResult build() {
            return new UpdateResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateResult> {
        public Builder generatedFields(Collection<Field> var1);

        public Builder generatedFields(Field ... var1);

        public Builder generatedFields(Consumer<Field.Builder> ... var1);
    }
}

