/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An instance of a label returned by Amazon Rekognition Image (<a>DetectLabels</a>) or by Amazon Rekognition Video
 * (<a>GetLabelDetection</a>).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Instance implements SdkPojo, Serializable, ToCopyableBuilder<Instance.Builder, Instance> {
    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.<BoundingBox> builder(MarshallingType.SDK_POJO)
            .memberName("BoundingBox").getter(getter(Instance::boundingBox)).setter(setter(Builder::boundingBox))
            .constructor(BoundingBox::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(Instance::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<List<DominantColor>> DOMINANT_COLORS_FIELD = SdkField
            .<List<DominantColor>> builder(MarshallingType.LIST)
            .memberName("DominantColors")
            .getter(getter(Instance::dominantColors))
            .setter(setter(Builder::dominantColors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DominantColors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DominantColor> builder(MarshallingType.SDK_POJO)
                                            .constructor(DominantColor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDING_BOX_FIELD,
            CONFIDENCE_FIELD, DOMINANT_COLORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final BoundingBox boundingBox;

    private final Float confidence;

    private final List<DominantColor> dominantColors;

    private Instance(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.confidence = builder.confidence;
        this.dominantColors = builder.dominantColors;
    }

    /**
     * <p>
     * The position of the label instance on the image.
     * </p>
     * 
     * @return The position of the label instance on the image.
     */
    public final BoundingBox boundingBox() {
        return boundingBox;
    }

    /**
     * <p>
     * The confidence that Amazon Rekognition has in the accuracy of the bounding box.
     * </p>
     * 
     * @return The confidence that Amazon Rekognition has in the accuracy of the bounding box.
     */
    public final Float confidence() {
        return confidence;
    }

    /**
     * For responses, this returns true if the service returned a value for the DominantColors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDominantColors() {
        return dominantColors != null && !(dominantColors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dominant colors found in an individual instance of a label.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDominantColors} method.
     * </p>
     * 
     * @return The dominant colors found in an individual instance of a label.
     */
    public final List<DominantColor> dominantColors() {
        return dominantColors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(hasDominantColors() ? dominantColors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance) obj;
        return Objects.equals(boundingBox(), other.boundingBox()) && Objects.equals(confidence(), other.confidence())
                && hasDominantColors() == other.hasDominantColors() && Objects.equals(dominantColors(), other.dominantColors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Instance").add("BoundingBox", boundingBox()).add("Confidence", confidence())
                .add("DominantColors", hasDominantColors() ? dominantColors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BoundingBox":
            return Optional.ofNullable(clazz.cast(boundingBox()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "DominantColors":
            return Optional.ofNullable(clazz.cast(dominantColors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Instance> {
        /**
         * <p>
         * The position of the label instance on the image.
         * </p>
         * 
         * @param boundingBox
         *        The position of the label instance on the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(BoundingBox boundingBox);

        /**
         * <p>
         * The position of the label instance on the image.
         * </p>
         * This is a convenience method that creates an instance of the {@link BoundingBox.Builder} avoiding the need to
         * create one manually via {@link BoundingBox#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BoundingBox.Builder#build()} is called immediately and its result
         * is passed to {@link #boundingBox(BoundingBox)}.
         * 
         * @param boundingBox
         *        a consumer that will call methods on {@link BoundingBox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #boundingBox(BoundingBox)
         */
        default Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return boundingBox(BoundingBox.builder().applyMutation(boundingBox).build());
        }

        /**
         * <p>
         * The confidence that Amazon Rekognition has in the accuracy of the bounding box.
         * </p>
         * 
         * @param confidence
         *        The confidence that Amazon Rekognition has in the accuracy of the bounding box.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);

        /**
         * <p>
         * The dominant colors found in an individual instance of a label.
         * </p>
         * 
         * @param dominantColors
         *        The dominant colors found in an individual instance of a label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dominantColors(Collection<DominantColor> dominantColors);

        /**
         * <p>
         * The dominant colors found in an individual instance of a label.
         * </p>
         * 
         * @param dominantColors
         *        The dominant colors found in an individual instance of a label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dominantColors(DominantColor... dominantColors);

        /**
         * <p>
         * The dominant colors found in an individual instance of a label.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.DominantColor.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.rekognition.model.DominantColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.DominantColor.Builder#build()} is called immediately
         * and its result is passed to {@link #dominantColors(List<DominantColor>)}.
         * 
         * @param dominantColors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.DominantColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dominantColors(java.util.Collection<DominantColor>)
         */
        Builder dominantColors(Consumer<DominantColor.Builder>... dominantColors);
    }

    static final class BuilderImpl implements Builder {
        private BoundingBox boundingBox;

        private Float confidence;

        private List<DominantColor> dominantColors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            boundingBox(model.boundingBox);
            confidence(model.confidence);
            dominantColors(model.dominantColors);
        }

        public final BoundingBox.Builder getBoundingBox() {
            return boundingBox != null ? boundingBox.toBuilder() : null;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final List<DominantColor.Builder> getDominantColors() {
            List<DominantColor.Builder> result = DominantColorsCopier.copyToBuilder(this.dominantColors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDominantColors(Collection<DominantColor.BuilderImpl> dominantColors) {
            this.dominantColors = DominantColorsCopier.copyFromBuilder(dominantColors);
        }

        @Override
        public final Builder dominantColors(Collection<DominantColor> dominantColors) {
            this.dominantColors = DominantColorsCopier.copy(dominantColors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dominantColors(DominantColor... dominantColors) {
            dominantColors(Arrays.asList(dominantColors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dominantColors(Consumer<DominantColor.Builder>... dominantColors) {
            dominantColors(Stream.of(dominantColors).map(c -> DominantColor.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
