/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.Face;
import software.amazon.awssdk.services.rekognition.model.FaceDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FaceRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FaceRecord> {
    private static final SdkField<Face> FACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Face").getter(FaceRecord.getter(FaceRecord::face)).setter(FaceRecord.setter(Builder::face)).constructor(Face::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Face").build()}).build();
    private static final SdkField<FaceDetail> FACE_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FaceDetail").getter(FaceRecord.getter(FaceRecord::faceDetail)).setter(FaceRecord.setter(Builder::faceDetail)).constructor(FaceDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACE_FIELD, FACE_DETAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FaceRecord.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Face face;
    private final FaceDetail faceDetail;

    private FaceRecord(BuilderImpl builder) {
        this.face = builder.face;
        this.faceDetail = builder.faceDetail;
    }

    public final Face face() {
        return this.face;
    }

    public final FaceDetail faceDetail() {
        return this.faceDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.face());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceDetail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceRecord)) {
            return false;
        }
        FaceRecord other = (FaceRecord)obj;
        return Objects.equals(this.face(), other.face()) && Objects.equals(this.faceDetail(), other.faceDetail());
    }

    public final String toString() {
        return ToString.builder((String)"FaceRecord").add("Face", (Object)this.face()).add("FaceDetail", (Object)this.faceDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Face": {
                return Optional.ofNullable(clazz.cast(this.face()));
            }
            case "FaceDetail": {
                return Optional.ofNullable(clazz.cast(this.faceDetail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Face", FACE_FIELD);
        map.put("FaceDetail", FACE_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FaceRecord, T> g) {
        return obj -> g.apply((FaceRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Face face;
        private FaceDetail faceDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceRecord model) {
            this.face(model.face);
            this.faceDetail(model.faceDetail);
        }

        public final Face.Builder getFace() {
            return this.face != null ? this.face.toBuilder() : null;
        }

        public final void setFace(Face.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        @Override
        public final Builder face(Face face) {
            this.face = face;
            return this;
        }

        public final FaceDetail.Builder getFaceDetail() {
            return this.faceDetail != null ? this.faceDetail.toBuilder() : null;
        }

        public final void setFaceDetail(FaceDetail.BuilderImpl faceDetail) {
            this.faceDetail = faceDetail != null ? faceDetail.build() : null;
        }

        @Override
        public final Builder faceDetail(FaceDetail faceDetail) {
            this.faceDetail = faceDetail;
            return this;
        }

        public FaceRecord build() {
            return new FaceRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FaceRecord> {
        public Builder face(Face var1);

        default public Builder face(Consumer<Face.Builder> face) {
            return this.face((Face)((Face.Builder)Face.builder().applyMutation(face)).build());
        }

        public Builder faceDetail(FaceDetail var1);

        default public Builder faceDetail(Consumer<FaceDetail.Builder> faceDetail) {
            return this.faceDetail((FaceDetail)((FaceDetail.Builder)FaceDetail.builder().applyMutation(faceDetail)).build());
        }
    }
}

