/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociationReason;
import software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociationReasonsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnsuccessfulFaceDisassociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UnsuccessfulFaceDisassociation> {
    private static final SdkField<String> FACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FaceId").getter(UnsuccessfulFaceDisassociation.getter(UnsuccessfulFaceDisassociation::faceId)).setter(UnsuccessfulFaceDisassociation.setter(Builder::faceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(UnsuccessfulFaceDisassociation.getter(UnsuccessfulFaceDisassociation::userId)).setter(UnsuccessfulFaceDisassociation.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<List<String>> REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Reasons").getter(UnsuccessfulFaceDisassociation.getter(UnsuccessfulFaceDisassociation::reasonsAsStrings)).setter(UnsuccessfulFaceDisassociation.setter(Builder::reasonsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACE_ID_FIELD, USER_ID_FIELD, REASONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UnsuccessfulFaceDisassociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String faceId;
    private final String userId;
    private final List<String> reasons;

    private UnsuccessfulFaceDisassociation(BuilderImpl builder) {
        this.faceId = builder.faceId;
        this.userId = builder.userId;
        this.reasons = builder.reasons;
    }

    public final String faceId() {
        return this.faceId;
    }

    public final String userId() {
        return this.userId;
    }

    public final List<UnsuccessfulFaceDisassociationReason> reasons() {
        return UnsuccessfulFaceDisassociationReasonsCopier.copyStringToEnum(this.reasons);
    }

    public final boolean hasReasons() {
        return this.reasons != null && !(this.reasons instanceof SdkAutoConstructList);
    }

    public final List<String> reasonsAsStrings() {
        return this.reasons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.faceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReasons() ? this.reasonsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsuccessfulFaceDisassociation)) {
            return false;
        }
        UnsuccessfulFaceDisassociation other = (UnsuccessfulFaceDisassociation)obj;
        return Objects.equals(this.faceId(), other.faceId()) && Objects.equals(this.userId(), other.userId()) && this.hasReasons() == other.hasReasons() && Objects.equals(this.reasonsAsStrings(), other.reasonsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"UnsuccessfulFaceDisassociation").add("FaceId", (Object)this.faceId()).add("UserId", (Object)this.userId()).add("Reasons", this.hasReasons() ? this.reasonsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FaceId": {
                return Optional.ofNullable(clazz.cast(this.faceId()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "Reasons": {
                return Optional.ofNullable(clazz.cast(this.reasonsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FaceId", FACE_ID_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("Reasons", REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnsuccessfulFaceDisassociation, T> g) {
        return obj -> g.apply((UnsuccessfulFaceDisassociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String faceId;
        private String userId;
        private List<String> reasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UnsuccessfulFaceDisassociation model) {
            this.faceId(model.faceId);
            this.userId(model.userId);
            this.reasonsWithStrings(model.reasons);
        }

        public final String getFaceId() {
            return this.faceId;
        }

        public final void setFaceId(String faceId) {
            this.faceId = faceId;
        }

        @Override
        public final Builder faceId(String faceId) {
            this.faceId = faceId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Collection<String> getReasons() {
            if (this.reasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reasons;
        }

        public final void setReasons(Collection<String> reasons) {
            this.reasons = UnsuccessfulFaceDisassociationReasonsCopier.copy(reasons);
        }

        @Override
        public final Builder reasonsWithStrings(Collection<String> reasons) {
            this.reasons = UnsuccessfulFaceDisassociationReasonsCopier.copy(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonsWithStrings(String ... reasons) {
            this.reasonsWithStrings(Arrays.asList(reasons));
            return this;
        }

        @Override
        public final Builder reasons(Collection<UnsuccessfulFaceDisassociationReason> reasons) {
            this.reasons = UnsuccessfulFaceDisassociationReasonsCopier.copyEnumToString(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(UnsuccessfulFaceDisassociationReason ... reasons) {
            this.reasons(Arrays.asList(reasons));
            return this;
        }

        public UnsuccessfulFaceDisassociation build() {
            return new UnsuccessfulFaceDisassociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UnsuccessfulFaceDisassociation> {
        public Builder faceId(String var1);

        public Builder userId(String var1);

        public Builder reasonsWithStrings(Collection<String> var1);

        public Builder reasonsWithStrings(String ... var1);

        public Builder reasons(Collection<UnsuccessfulFaceDisassociationReason> var1);

        public Builder reasons(UnsuccessfulFaceDisassociationReason ... var1);
    }
}

