/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CancelDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.CancelDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.CancelSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.CancelSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateFleetRequest;
import software.amazon.awssdk.services.robomaker.model.CreateFleetResponse;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationVersionRequest;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationVersionResponse;
import software.amazon.awssdk.services.robomaker.model.CreateRobotRequest;
import software.amazon.awssdk.services.robomaker.model.CreateRobotResponse;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationVersionRequest;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationVersionResponse;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteFleetRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteFleetResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DeregisterRobotRequest;
import software.amazon.awssdk.services.robomaker.model.DeregisterRobotResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeFleetRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeFleetResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse;
import software.amazon.awssdk.services.robomaker.model.ListFleetsRequest;
import software.amazon.awssdk.services.robomaker.model.ListFleetsResponse;
import software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest;
import software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse;
import software.amazon.awssdk.services.robomaker.model.ListRobotsRequest;
import software.amazon.awssdk.services.robomaker.model.ListRobotsResponse;
import software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse;
import software.amazon.awssdk.services.robomaker.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.robomaker.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.robomaker.model.RegisterRobotRequest;
import software.amazon.awssdk.services.robomaker.model.RegisterRobotResponse;
import software.amazon.awssdk.services.robomaker.model.RestartSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.RestartSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.SyncDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.SyncDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.TagResourceRequest;
import software.amazon.awssdk.services.robomaker.model.TagResourceResponse;
import software.amazon.awssdk.services.robomaker.model.UntagResourceRequest;
import software.amazon.awssdk.services.robomaker.model.UntagResourceResponse;
import software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsPublisher;
import software.amazon.awssdk.services.robomaker.paginators.ListFleetsPublisher;
import software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsPublisher;
import software.amazon.awssdk.services.robomaker.paginators.ListRobotsPublisher;
import software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsPublisher;
import software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsPublisher;

/**
 * Service client for accessing RoboMaker asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * This section provides documentation for the AWS RoboMaker API operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface RoboMakerAsyncClient extends SdkClient {
    String SERVICE_NAME = "robomaker";

    /**
     * Create a {@link RoboMakerAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RoboMakerAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RoboMakerAsyncClient}.
     */
    static RoboMakerAsyncClientBuilder builder() {
        return new DefaultRoboMakerAsyncClientBuilder();
    }

    /**
     * <p>
     * Describes one or more simulation jobs.
     * </p>
     *
     * @param batchDescribeSimulationJobRequest
     * @return A Java Future containing the result of the BatchDescribeSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.BatchDescribeSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/BatchDescribeSimulationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDescribeSimulationJobResponse> batchDescribeSimulationJob(
            BatchDescribeSimulationJobRequest batchDescribeSimulationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more simulation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDescribeSimulationJobRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDescribeSimulationJobRequest#builder()}
     * </p>
     *
     * @param batchDescribeSimulationJobRequest
     *        A {@link Consumer} that will call methods on {@link BatchDescribeSimulationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDescribeSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.BatchDescribeSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/BatchDescribeSimulationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDescribeSimulationJobResponse> batchDescribeSimulationJob(
            Consumer<BatchDescribeSimulationJobRequest.Builder> batchDescribeSimulationJobRequest) {
        return batchDescribeSimulationJob(BatchDescribeSimulationJobRequest.builder()
                .applyMutation(batchDescribeSimulationJobRequest).build());
    }

    /**
     * <p>
     * Cancels the specified deployment job.
     * </p>
     *
     * @param cancelDeploymentJobRequest
     * @return A Java Future containing the result of the CancelDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelDeploymentJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelDeploymentJobResponse> cancelDeploymentJob(
            CancelDeploymentJobRequest cancelDeploymentJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified deployment job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelDeploymentJobRequest.Builder} avoiding the
     * need to create one manually via {@link CancelDeploymentJobRequest#builder()}
     * </p>
     *
     * @param cancelDeploymentJobRequest
     *        A {@link Consumer} that will call methods on {@link CancelDeploymentJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelDeploymentJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelDeploymentJobResponse> cancelDeploymentJob(
            Consumer<CancelDeploymentJobRequest.Builder> cancelDeploymentJobRequest) {
        return cancelDeploymentJob(CancelDeploymentJobRequest.builder().applyMutation(cancelDeploymentJobRequest).build());
    }

    /**
     * <p>
     * Cancels the specified simulation job.
     * </p>
     *
     * @param cancelSimulationJobRequest
     * @return A Java Future containing the result of the CancelSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelSimulationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelSimulationJobResponse> cancelSimulationJob(
            CancelSimulationJobRequest cancelSimulationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified simulation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSimulationJobRequest.Builder} avoiding the
     * need to create one manually via {@link CancelSimulationJobRequest#builder()}
     * </p>
     *
     * @param cancelSimulationJobRequest
     *        A {@link Consumer} that will call methods on {@link CancelSimulationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelSimulationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelSimulationJobResponse> cancelSimulationJob(
            Consumer<CancelSimulationJobRequest.Builder> cancelSimulationJobRequest) {
        return cancelSimulationJob(CancelSimulationJobRequest.builder().applyMutation(cancelSimulationJobRequest).build());
    }

    /**
     * <p>
     * Deploys a specific version of a robot application to robots in a fleet.
     * </p>
     * <p>
     * The robot application must have a numbered <code>applicationVersion</code> for consistency reasons. To create a
     * new version, use <code>CreateRobotApplicationVersion</code> or see <a
     * href="https://docs.aws.amazon.com/robomaker/latest/dg/create-robot-application-version.html">Creating a Robot
     * Application Version</a>.
     * </p>
     * <note>
     * <p>
     * After 90 days, deployment jobs expire and will be deleted. They will no longer be accessible.
     * </p>
     * </note>
     *
     * @param createDeploymentJobRequest
     * @return A Java Future containing the result of the CreateDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ConcurrentDeploymentException The failure percentage threshold percentage was met.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateDeploymentJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDeploymentJobResponse> createDeploymentJob(
            CreateDeploymentJobRequest createDeploymentJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deploys a specific version of a robot application to robots in a fleet.
     * </p>
     * <p>
     * The robot application must have a numbered <code>applicationVersion</code> for consistency reasons. To create a
     * new version, use <code>CreateRobotApplicationVersion</code> or see <a
     * href="https://docs.aws.amazon.com/robomaker/latest/dg/create-robot-application-version.html">Creating a Robot
     * Application Version</a>.
     * </p>
     * <note>
     * <p>
     * After 90 days, deployment jobs expire and will be deleted. They will no longer be accessible.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDeploymentJobRequest#builder()}
     * </p>
     *
     * @param createDeploymentJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeploymentJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ConcurrentDeploymentException The failure percentage threshold percentage was met.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateDeploymentJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDeploymentJobResponse> createDeploymentJob(
            Consumer<CreateDeploymentJobRequest.Builder> createDeploymentJobRequest) {
        return createDeploymentJob(CreateDeploymentJobRequest.builder().applyMutation(createDeploymentJobRequest).build());
    }

    /**
     * <p>
     * Creates a fleet, a logical group of robots running the same robot application.
     * </p>
     *
     * @param createFleetRequest
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFleetResponse> createFleet(CreateFleetRequest createFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a fleet, a logical group of robots running the same robot application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFleetRequest#builder()}
     * </p>
     *
     * @param createFleetRequest
     *        A {@link Consumer} that will call methods on {@link CreateFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFleetResponse> createFleet(Consumer<CreateFleetRequest.Builder> createFleetRequest) {
        return createFleet(CreateFleetRequest.builder().applyMutation(createFleetRequest).build());
    }

    /**
     * <p>
     * Creates a robot.
     * </p>
     *
     * @param createRobotRequest
     * @return A Java Future containing the result of the CreateRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRobotResponse> createRobot(CreateRobotRequest createRobotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a robot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRobotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRobotRequest#builder()}
     * </p>
     *
     * @param createRobotRequest
     *        A {@link Consumer} that will call methods on {@link CreateRobotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRobotResponse> createRobot(Consumer<CreateRobotRequest.Builder> createRobotRequest) {
        return createRobot(CreateRobotRequest.builder().applyMutation(createRobotRequest).build());
    }

    /**
     * <p>
     * Creates a robot application.
     * </p>
     *
     * @param createRobotApplicationRequest
     * @return A Java Future containing the result of the CreateRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateRobotApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRobotApplicationResponse> createRobotApplication(
            CreateRobotApplicationRequest createRobotApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a robot application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRobotApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRobotApplicationRequest#builder()}
     * </p>
     *
     * @param createRobotApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateRobotApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateRobotApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRobotApplicationResponse> createRobotApplication(
            Consumer<CreateRobotApplicationRequest.Builder> createRobotApplicationRequest) {
        return createRobotApplication(CreateRobotApplicationRequest.builder().applyMutation(createRobotApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Creates a version of a robot application.
     * </p>
     *
     * @param createRobotApplicationVersionRequest
     * @return A Java Future containing the result of the CreateRobotApplicationVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateRobotApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobotApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRobotApplicationVersionResponse> createRobotApplicationVersion(
            CreateRobotApplicationVersionRequest createRobotApplicationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a version of a robot application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRobotApplicationVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateRobotApplicationVersionRequest#builder()}
     * </p>
     *
     * @param createRobotApplicationVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateRobotApplicationVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateRobotApplicationVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateRobotApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobotApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRobotApplicationVersionResponse> createRobotApplicationVersion(
            Consumer<CreateRobotApplicationVersionRequest.Builder> createRobotApplicationVersionRequest) {
        return createRobotApplicationVersion(CreateRobotApplicationVersionRequest.builder()
                .applyMutation(createRobotApplicationVersionRequest).build());
    }

    /**
     * <p>
     * Creates a simulation application.
     * </p>
     *
     * @param createSimulationApplicationRequest
     * @return A Java Future containing the result of the CreateSimulationApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateSimulationApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSimulationApplicationResponse> createSimulationApplication(
            CreateSimulationApplicationRequest createSimulationApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a simulation application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSimulationApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSimulationApplicationRequest#builder()}
     * </p>
     *
     * @param createSimulationApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateSimulationApplicationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateSimulationApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateSimulationApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSimulationApplicationResponse> createSimulationApplication(
            Consumer<CreateSimulationApplicationRequest.Builder> createSimulationApplicationRequest) {
        return createSimulationApplication(CreateSimulationApplicationRequest.builder()
                .applyMutation(createSimulationApplicationRequest).build());
    }

    /**
     * <p>
     * Creates a simulation application with a specific revision id.
     * </p>
     *
     * @param createSimulationApplicationVersionRequest
     * @return A Java Future containing the result of the CreateSimulationApplicationVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateSimulationApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSimulationApplicationVersionResponse> createSimulationApplicationVersion(
            CreateSimulationApplicationVersionRequest createSimulationApplicationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a simulation application with a specific revision id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSimulationApplicationVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSimulationApplicationVersionRequest#builder()}
     * </p>
     *
     * @param createSimulationApplicationVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateSimulationApplicationVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateSimulationApplicationVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateSimulationApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSimulationApplicationVersionResponse> createSimulationApplicationVersion(
            Consumer<CreateSimulationApplicationVersionRequest.Builder> createSimulationApplicationVersionRequest) {
        return createSimulationApplicationVersion(CreateSimulationApplicationVersionRequest.builder()
                .applyMutation(createSimulationApplicationVersionRequest).build());
    }

    /**
     * <p>
     * Creates a simulation job.
     * </p>
     * <note>
     * <p>
     * After 90 days, simulation jobs expire and will be deleted. They will no longer be accessible.
     * </p>
     * </note>
     *
     * @param createSimulationJobRequest
     * @return A Java Future containing the result of the CreateSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSimulationJobResponse> createSimulationJob(
            CreateSimulationJobRequest createSimulationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a simulation job.
     * </p>
     * <note>
     * <p>
     * After 90 days, simulation jobs expire and will be deleted. They will no longer be accessible.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSimulationJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSimulationJobRequest#builder()}
     * </p>
     *
     * @param createSimulationJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateSimulationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSimulationJobResponse> createSimulationJob(
            Consumer<CreateSimulationJobRequest.Builder> createSimulationJobRequest) {
        return createSimulationJob(CreateSimulationJobRequest.builder().applyMutation(createSimulationJobRequest).build());
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     *
     * @param deleteFleetRequest
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFleetResponse> deleteFleet(DeleteFleetRequest deleteFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFleetRequest#builder()}
     * </p>
     *
     * @param deleteFleetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFleetResponse> deleteFleet(Consumer<DeleteFleetRequest.Builder> deleteFleetRequest) {
        return deleteFleet(DeleteFleetRequest.builder().applyMutation(deleteFleetRequest).build());
    }

    /**
     * <p>
     * Deletes a robot.
     * </p>
     *
     * @param deleteRobotRequest
     * @return A Java Future containing the result of the DeleteRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRobotResponse> deleteRobot(DeleteRobotRequest deleteRobotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a robot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRobotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRobotRequest#builder()}
     * </p>
     *
     * @param deleteRobotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRobotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRobotResponse> deleteRobot(Consumer<DeleteRobotRequest.Builder> deleteRobotRequest) {
        return deleteRobot(DeleteRobotRequest.builder().applyMutation(deleteRobotRequest).build());
    }

    /**
     * <p>
     * Deletes a robot application.
     * </p>
     *
     * @param deleteRobotApplicationRequest
     * @return A Java Future containing the result of the DeleteRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteRobotApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRobotApplicationResponse> deleteRobotApplication(
            DeleteRobotApplicationRequest deleteRobotApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a robot application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRobotApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRobotApplicationRequest#builder()}
     * </p>
     *
     * @param deleteRobotApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRobotApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteRobotApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRobotApplicationResponse> deleteRobotApplication(
            Consumer<DeleteRobotApplicationRequest.Builder> deleteRobotApplicationRequest) {
        return deleteRobotApplication(DeleteRobotApplicationRequest.builder().applyMutation(deleteRobotApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a simulation application.
     * </p>
     *
     * @param deleteSimulationApplicationRequest
     * @return A Java Future containing the result of the DeleteSimulationApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteSimulationApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSimulationApplicationResponse> deleteSimulationApplication(
            DeleteSimulationApplicationRequest deleteSimulationApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a simulation application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSimulationApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSimulationApplicationRequest#builder()}
     * </p>
     *
     * @param deleteSimulationApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSimulationApplicationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteSimulationApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteSimulationApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSimulationApplicationResponse> deleteSimulationApplication(
            Consumer<DeleteSimulationApplicationRequest.Builder> deleteSimulationApplicationRequest) {
        return deleteSimulationApplication(DeleteSimulationApplicationRequest.builder()
                .applyMutation(deleteSimulationApplicationRequest).build());
    }

    /**
     * <p>
     * Deregisters a robot.
     * </p>
     *
     * @param deregisterRobotRequest
     * @return A Java Future containing the result of the DeregisterRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeregisterRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeregisterRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeregisterRobotResponse> deregisterRobot(DeregisterRobotRequest deregisterRobotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters a robot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterRobotRequest.Builder} avoiding the need
     * to create one manually via {@link DeregisterRobotRequest#builder()}
     * </p>
     *
     * @param deregisterRobotRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterRobotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeregisterRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeregisterRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeregisterRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeregisterRobotResponse> deregisterRobot(
            Consumer<DeregisterRobotRequest.Builder> deregisterRobotRequest) {
        return deregisterRobot(DeregisterRobotRequest.builder().applyMutation(deregisterRobotRequest).build());
    }

    /**
     * <p>
     * Describes a deployment job.
     * </p>
     *
     * @param describeDeploymentJobRequest
     * @return A Java Future containing the result of the DescribeDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeDeploymentJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeDeploymentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeploymentJobResponse> describeDeploymentJob(
            DescribeDeploymentJobRequest describeDeploymentJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a deployment job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeploymentJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDeploymentJobRequest#builder()}
     * </p>
     *
     * @param describeDeploymentJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDeploymentJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeDeploymentJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeDeploymentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeploymentJobResponse> describeDeploymentJob(
            Consumer<DescribeDeploymentJobRequest.Builder> describeDeploymentJobRequest) {
        return describeDeploymentJob(DescribeDeploymentJobRequest.builder().applyMutation(describeDeploymentJobRequest).build());
    }

    /**
     * <p>
     * Describes a fleet.
     * </p>
     *
     * @param describeFleetRequest
     * @return A Java Future containing the result of the DescribeFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeFleetResponse> describeFleet(DescribeFleetRequest describeFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeFleetRequest#builder()}
     * </p>
     *
     * @param describeFleetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeFleetResponse> describeFleet(Consumer<DescribeFleetRequest.Builder> describeFleetRequest) {
        return describeFleet(DescribeFleetRequest.builder().applyMutation(describeFleetRequest).build());
    }

    /**
     * <p>
     * Describes a robot.
     * </p>
     *
     * @param describeRobotRequest
     * @return A Java Future containing the result of the DescribeRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRobotResponse> describeRobot(DescribeRobotRequest describeRobotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a robot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRobotRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeRobotRequest#builder()}
     * </p>
     *
     * @param describeRobotRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRobotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRobotResponse> describeRobot(Consumer<DescribeRobotRequest.Builder> describeRobotRequest) {
        return describeRobot(DescribeRobotRequest.builder().applyMutation(describeRobotRequest).build());
    }

    /**
     * <p>
     * Describes a robot application.
     * </p>
     *
     * @param describeRobotApplicationRequest
     * @return A Java Future containing the result of the DescribeRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeRobotApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRobotApplicationResponse> describeRobotApplication(
            DescribeRobotApplicationRequest describeRobotApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a robot application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRobotApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRobotApplicationRequest#builder()}
     * </p>
     *
     * @param describeRobotApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRobotApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeRobotApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRobotApplicationResponse> describeRobotApplication(
            Consumer<DescribeRobotApplicationRequest.Builder> describeRobotApplicationRequest) {
        return describeRobotApplication(DescribeRobotApplicationRequest.builder().applyMutation(describeRobotApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Describes a simulation application.
     * </p>
     *
     * @param describeSimulationApplicationRequest
     * @return A Java Future containing the result of the DescribeSimulationApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeSimulationApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSimulationApplicationResponse> describeSimulationApplication(
            DescribeSimulationApplicationRequest describeSimulationApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a simulation application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSimulationApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSimulationApplicationRequest#builder()}
     * </p>
     *
     * @param describeSimulationApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSimulationApplicationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeSimulationApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeSimulationApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSimulationApplicationResponse> describeSimulationApplication(
            Consumer<DescribeSimulationApplicationRequest.Builder> describeSimulationApplicationRequest) {
        return describeSimulationApplication(DescribeSimulationApplicationRequest.builder()
                .applyMutation(describeSimulationApplicationRequest).build());
    }

    /**
     * <p>
     * Describes a simulation job.
     * </p>
     *
     * @param describeSimulationJobRequest
     * @return A Java Future containing the result of the DescribeSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSimulationJobResponse> describeSimulationJob(
            DescribeSimulationJobRequest describeSimulationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a simulation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSimulationJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSimulationJobRequest#builder()}
     * </p>
     *
     * @param describeSimulationJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSimulationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSimulationJobResponse> describeSimulationJob(
            Consumer<DescribeSimulationJobRequest.Builder> describeSimulationJobRequest) {
        return describeSimulationJob(DescribeSimulationJobRequest.builder().applyMutation(describeSimulationJobRequest).build());
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     * <note>
     * <p>
     * </p>
     * </note>
     *
     * @param listDeploymentJobsRequest
     * @return A Java Future containing the result of the ListDeploymentJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListDeploymentJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDeploymentJobsResponse> listDeploymentJobs(ListDeploymentJobsRequest listDeploymentJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     * <note>
     * <p>
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeploymentJobsRequest#builder()}
     * </p>
     *
     * @param listDeploymentJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDeploymentJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListDeploymentJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDeploymentJobsResponse> listDeploymentJobs(
            Consumer<ListDeploymentJobsRequest.Builder> listDeploymentJobsRequest) {
        return listDeploymentJobs(ListDeploymentJobsRequest.builder().applyMutation(listDeploymentJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     * <note>
     * <p>
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the ListDeploymentJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListDeploymentJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDeploymentJobsResponse> listDeploymentJobs() {
        return listDeploymentJobs(ListDeploymentJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     * <note>
     * <p>
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentJobs(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsPublisher publisher = client.listDeploymentJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsPublisher publisher = client.listDeploymentJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentJobs(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListDeploymentJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentJobsPublisher listDeploymentJobsPaginator() {
        return listDeploymentJobsPaginator(ListDeploymentJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     * <note>
     * <p>
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentJobs(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsPublisher publisher = client.listDeploymentJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsPublisher publisher = client.listDeploymentJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentJobs(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeploymentJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListDeploymentJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentJobsPublisher listDeploymentJobsPaginator(ListDeploymentJobsRequest listDeploymentJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     * <note>
     * <p>
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentJobs(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsPublisher publisher = client.listDeploymentJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsPublisher publisher = client.listDeploymentJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentJobs(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeploymentJobsRequest#builder()}
     * </p>
     *
     * @param listDeploymentJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListDeploymentJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentJobsPublisher listDeploymentJobsPaginator(
            Consumer<ListDeploymentJobsRequest.Builder> listDeploymentJobsRequest) {
        return listDeploymentJobsPaginator(ListDeploymentJobsRequest.builder().applyMutation(listDeploymentJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     *
     * @param listFleetsRequest
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFleetsResponse> listFleets(ListFleetsRequest listFleetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on {@link ListFleetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFleetsResponse> listFleets(Consumer<ListFleetsRequest.Builder> listFleetsRequest) {
        return listFleets(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     *
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFleetsResponse> listFleets() {
        return listFleets(ListFleetsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.robomaker.model.ListFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.robomaker.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsPublisher listFleetsPaginator() {
        return listFleetsPaginator(ListFleetsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.robomaker.model.ListFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.robomaker.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @param listFleetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsPublisher listFleetsPaginator(ListFleetsRequest listFleetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.robomaker.model.ListFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.robomaker.model.ListFleetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on {@link ListFleetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsPublisher listFleetsPaginator(Consumer<ListFleetsRequest.Builder> listFleetsRequest) {
        return listFleetsPaginator(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     *
     * @param listRobotApplicationsRequest
     * @return A Java Future containing the result of the ListRobotApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobotApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRobotApplicationsResponse> listRobotApplications(
            ListRobotApplicationsRequest listRobotApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRobotApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRobotApplicationsRequest#builder()}
     * </p>
     *
     * @param listRobotApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListRobotApplicationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRobotApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobotApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRobotApplicationsResponse> listRobotApplications(
            Consumer<ListRobotApplicationsRequest.Builder> listRobotApplicationsRequest) {
        return listRobotApplications(ListRobotApplicationsRequest.builder().applyMutation(listRobotApplicationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     *
     * @return A Java Future containing the result of the ListRobotApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobotApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRobotApplicationsResponse> listRobotApplications() {
        return listRobotApplications(ListRobotApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRobotApplications(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsPublisher publisher = client.listRobotApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsPublisher publisher = client.listRobotApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRobotApplications(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobotApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRobotApplicationsPublisher listRobotApplicationsPaginator() {
        return listRobotApplicationsPaginator(ListRobotApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRobotApplications(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsPublisher publisher = client.listRobotApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsPublisher publisher = client.listRobotApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRobotApplications(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRobotApplicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobotApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRobotApplicationsPublisher listRobotApplicationsPaginator(
            ListRobotApplicationsRequest listRobotApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRobotApplications(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsPublisher publisher = client.listRobotApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsPublisher publisher = client.listRobotApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRobotApplications(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRobotApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRobotApplicationsRequest#builder()}
     * </p>
     *
     * @param listRobotApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListRobotApplicationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobotApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRobotApplicationsPublisher listRobotApplicationsPaginator(
            Consumer<ListRobotApplicationsRequest.Builder> listRobotApplicationsRequest) {
        return listRobotApplicationsPaginator(ListRobotApplicationsRequest.builder().applyMutation(listRobotApplicationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     *
     * @param listRobotsRequest
     * @return A Java Future containing the result of the ListRobots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRobotsResponse> listRobots(ListRobotsRequest listRobotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRobotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRobotsRequest#builder()}
     * </p>
     *
     * @param listRobotsRequest
     *        A {@link Consumer} that will call methods on {@link ListRobotsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRobots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRobotsResponse> listRobots(Consumer<ListRobotsRequest.Builder> listRobotsRequest) {
        return listRobots(ListRobotsRequest.builder().applyMutation(listRobotsRequest).build());
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     *
     * @return A Java Future containing the result of the ListRobots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRobotsResponse> listRobots() {
        return listRobots(ListRobotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRobots(software.amazon.awssdk.services.robomaker.model.ListRobotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotsPublisher publisher = client.listRobotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotsPublisher publisher = client.listRobotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListRobotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListRobotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRobots(software.amazon.awssdk.services.robomaker.model.ListRobotsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRobotsPublisher listRobotsPaginator() {
        return listRobotsPaginator(ListRobotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRobots(software.amazon.awssdk.services.robomaker.model.ListRobotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotsPublisher publisher = client.listRobotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotsPublisher publisher = client.listRobotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListRobotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListRobotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRobots(software.amazon.awssdk.services.robomaker.model.ListRobotsRequest)} operation.</b>
     * </p>
     *
     * @param listRobotsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRobotsPublisher listRobotsPaginator(ListRobotsRequest listRobotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRobots(software.amazon.awssdk.services.robomaker.model.ListRobotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotsPublisher publisher = client.listRobotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotsPublisher publisher = client.listRobotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListRobotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListRobotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRobots(software.amazon.awssdk.services.robomaker.model.ListRobotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRobotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRobotsRequest#builder()}
     * </p>
     *
     * @param listRobotsRequest
     *        A {@link Consumer} that will call methods on {@link ListRobotsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRobotsPublisher listRobotsPaginator(Consumer<ListRobotsRequest.Builder> listRobotsRequest) {
        return listRobotsPaginator(ListRobotsRequest.builder().applyMutation(listRobotsRequest).build());
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     *
     * @param listSimulationApplicationsRequest
     * @return A Java Future containing the result of the ListSimulationApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSimulationApplicationsResponse> listSimulationApplications(
            ListSimulationApplicationsRequest listSimulationApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSimulationApplicationsRequest#builder()}
     * </p>
     *
     * @param listSimulationApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationApplicationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSimulationApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSimulationApplicationsResponse> listSimulationApplications(
            Consumer<ListSimulationApplicationsRequest.Builder> listSimulationApplicationsRequest) {
        return listSimulationApplications(ListSimulationApplicationsRequest.builder()
                .applyMutation(listSimulationApplicationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     *
     * @return A Java Future containing the result of the ListSimulationApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSimulationApplicationsResponse> listSimulationApplications() {
        return listSimulationApplications(ListSimulationApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationApplications(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsPublisher publisher = client.listSimulationApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsPublisher publisher = client.listSimulationApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationApplications(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationApplicationsPublisher listSimulationApplicationsPaginator() {
        return listSimulationApplicationsPaginator(ListSimulationApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationApplications(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsPublisher publisher = client.listSimulationApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsPublisher publisher = client.listSimulationApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationApplications(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSimulationApplicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationApplicationsPublisher listSimulationApplicationsPaginator(
            ListSimulationApplicationsRequest listSimulationApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationApplications(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsPublisher publisher = client.listSimulationApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsPublisher publisher = client.listSimulationApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationApplications(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSimulationApplicationsRequest#builder()}
     * </p>
     *
     * @param listSimulationApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationApplicationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationApplicationsPublisher listSimulationApplicationsPaginator(
            Consumer<ListSimulationApplicationsRequest.Builder> listSimulationApplicationsRequest) {
        return listSimulationApplicationsPaginator(ListSimulationApplicationsRequest.builder()
                .applyMutation(listSimulationApplicationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     *
     * @param listSimulationJobsRequest
     * @return A Java Future containing the result of the ListSimulationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSimulationJobsResponse> listSimulationJobs(ListSimulationJobsRequest listSimulationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSimulationJobsRequest#builder()}
     * </p>
     *
     * @param listSimulationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSimulationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSimulationJobsResponse> listSimulationJobs(
            Consumer<ListSimulationJobsRequest.Builder> listSimulationJobsRequest) {
        return listSimulationJobs(ListSimulationJobsRequest.builder().applyMutation(listSimulationJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     *
     * @return A Java Future containing the result of the ListSimulationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSimulationJobsResponse> listSimulationJobs() {
        return listSimulationJobs(ListSimulationJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationJobs(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsPublisher publisher = client.listSimulationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsPublisher publisher = client.listSimulationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationJobs(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSimulationJobsPublisher listSimulationJobsPaginator() {
        return listSimulationJobsPaginator(ListSimulationJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationJobs(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsPublisher publisher = client.listSimulationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsPublisher publisher = client.listSimulationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationJobs(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSimulationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSimulationJobsPublisher listSimulationJobsPaginator(ListSimulationJobsRequest listSimulationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationJobs(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsPublisher publisher = client.listSimulationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsPublisher publisher = client.listSimulationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationJobs(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSimulationJobsRequest#builder()}
     * </p>
     *
     * @param listSimulationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSimulationJobsPublisher listSimulationJobsPaginator(
            Consumer<ListSimulationJobsRequest.Builder> listSimulationJobsRequest) {
        return listSimulationJobsPaginator(ListSimulationJobsRequest.builder().applyMutation(listSimulationJobsRequest).build());
    }

    /**
     * <p>
     * Lists all tags on a AWS RoboMaker resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags on a AWS RoboMaker resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Registers a robot with a fleet.
     * </p>
     *
     * @param registerRobotRequest
     * @return A Java Future containing the result of the RegisterRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.RegisterRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RegisterRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RegisterRobotResponse> registerRobot(RegisterRobotRequest registerRobotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a robot with a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterRobotRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterRobotRequest#builder()}
     * </p>
     *
     * @param registerRobotRequest
     *        A {@link Consumer} that will call methods on {@link RegisterRobotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RegisterRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.RegisterRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RegisterRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RegisterRobotResponse> registerRobot(Consumer<RegisterRobotRequest.Builder> registerRobotRequest) {
        return registerRobot(RegisterRobotRequest.builder().applyMutation(registerRobotRequest).build());
    }

    /**
     * <p>
     * Restarts a running simulation job.
     * </p>
     *
     * @param restartSimulationJobRequest
     * @return A Java Future containing the result of the RestartSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.RestartSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RestartSimulationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RestartSimulationJobResponse> restartSimulationJob(
            RestartSimulationJobRequest restartSimulationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restarts a running simulation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestartSimulationJobRequest.Builder} avoiding the
     * need to create one manually via {@link RestartSimulationJobRequest#builder()}
     * </p>
     *
     * @param restartSimulationJobRequest
     *        A {@link Consumer} that will call methods on {@link RestartSimulationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RestartSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.RestartSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RestartSimulationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RestartSimulationJobResponse> restartSimulationJob(
            Consumer<RestartSimulationJobRequest.Builder> restartSimulationJobRequest) {
        return restartSimulationJob(RestartSimulationJobRequest.builder().applyMutation(restartSimulationJobRequest).build());
    }

    /**
     * <p>
     * Syncrhonizes robots in a fleet to the latest deployment. This is helpful if robots were added after a deployment.
     * </p>
     *
     * @param syncDeploymentJobRequest
     * @return A Java Future containing the result of the SyncDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ConcurrentDeploymentException The failure percentage threshold percentage was met.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.SyncDeploymentJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/SyncDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SyncDeploymentJobResponse> syncDeploymentJob(SyncDeploymentJobRequest syncDeploymentJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Syncrhonizes robots in a fleet to the latest deployment. This is helpful if robots were added after a deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SyncDeploymentJobRequest.Builder} avoiding the need
     * to create one manually via {@link SyncDeploymentJobRequest#builder()}
     * </p>
     *
     * @param syncDeploymentJobRequest
     *        A {@link Consumer} that will call methods on {@link SyncDeploymentJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SyncDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ConcurrentDeploymentException The failure percentage threshold percentage was met.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.SyncDeploymentJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/SyncDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SyncDeploymentJobResponse> syncDeploymentJob(
            Consumer<SyncDeploymentJobRequest.Builder> syncDeploymentJobRequest) {
        return syncDeploymentJob(SyncDeploymentJobRequest.builder().applyMutation(syncDeploymentJobRequest).build());
    }

    /**
     * <p>
     * Adds or edits tags for a AWS RoboMaker resource.
     * </p>
     * <p>
     * Each tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be
     * empty strings.
     * </p>
     * <p>
     * For information about the rules that apply to tag keys and tag values, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined
     * Tag Restrictions</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or edits tags for a AWS RoboMaker resource.
     * </p>
     * <p>
     * Each tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be
     * empty strings.
     * </p>
     * <p>
     * For information about the rules that apply to tag keys and tag values, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined
     * Tag Restrictions</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified AWS RoboMaker resource.
     * </p>
     * <p>
     * To remove a tag, specify the tag key. To change the tag value of an existing tag key, use <a
     * href="https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html"> <code>TagResource</code> </a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified AWS RoboMaker resource.
     * </p>
     * <p>
     * To remove a tag, specify the tag key. To change the tag value of an existing tag key, use <a
     * href="https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html"> <code>TagResource</code> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a robot application.
     * </p>
     *
     * @param updateRobotApplicationRequest
     * @return A Java Future containing the result of the UpdateRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.UpdateRobotApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRobotApplicationResponse> updateRobotApplication(
            UpdateRobotApplicationRequest updateRobotApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a robot application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRobotApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRobotApplicationRequest#builder()}
     * </p>
     *
     * @param updateRobotApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRobotApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.UpdateRobotApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRobotApplicationResponse> updateRobotApplication(
            Consumer<UpdateRobotApplicationRequest.Builder> updateRobotApplicationRequest) {
        return updateRobotApplication(UpdateRobotApplicationRequest.builder().applyMutation(updateRobotApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Updates a simulation application.
     * </p>
     *
     * @param updateSimulationApplicationRequest
     * @return A Java Future containing the result of the UpdateSimulationApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.UpdateSimulationApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSimulationApplicationResponse> updateSimulationApplication(
            UpdateSimulationApplicationRequest updateSimulationApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a simulation application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSimulationApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSimulationApplicationRequest#builder()}
     * </p>
     *
     * @param updateSimulationApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSimulationApplicationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateSimulationApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.UpdateSimulationApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSimulationApplicationResponse> updateSimulationApplication(
            Consumer<UpdateSimulationApplicationRequest.Builder> updateSimulationApplicationRequest) {
        return updateSimulationApplication(UpdateSimulationApplicationRequest.builder()
                .applyMutation(updateSimulationApplicationRequest).build());
    }
}
