/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSimulationJobsResponse extends RoboMakerResponse implements
        ToCopyableBuilder<ListSimulationJobsResponse.Builder, ListSimulationJobsResponse> {
    private static final SdkField<List<SimulationJobSummary>> SIMULATION_JOB_SUMMARIES_FIELD = SdkField
            .<List<SimulationJobSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListSimulationJobsResponse::simulationJobSummaries))
            .setter(setter(Builder::simulationJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SimulationJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SimulationJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSimulationJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SIMULATION_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<SimulationJobSummary> simulationJobSummaries;

    private final String nextToken;

    private ListSimulationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.simulationJobSummaries = builder.simulationJobSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the SimulationJobSummaries property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSimulationJobSummaries() {
        return simulationJobSummaries != null && !(simulationJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of simulation job summaries that meet the criteria of the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSimulationJobSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of simulation job summaries that meet the criteria of the request.
     */
    public List<SimulationJobSummary> simulationJobSummaries() {
        return simulationJobSummaries;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListSimulationJobs</code> request. When the results
     * of a <code>ListRobot</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next
     * page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListSimulationJobs</code> request. When the
     *         results of a <code>ListRobot</code> request exceed <code>maxResults</code>, this value can be used to
     *         retrieve the next page of results. This value is <code>null</code> when there are no more results to
     *         return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(simulationJobSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSimulationJobsResponse)) {
            return false;
        }
        ListSimulationJobsResponse other = (ListSimulationJobsResponse) obj;
        return Objects.equals(simulationJobSummaries(), other.simulationJobSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListSimulationJobsResponse").add("SimulationJobSummaries", simulationJobSummaries())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "simulationJobSummaries":
            return Optional.ofNullable(clazz.cast(simulationJobSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSimulationJobsResponse, T> g) {
        return obj -> g.apply((ListSimulationJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSimulationJobsResponse> {
        /**
         * <p>
         * A list of simulation job summaries that meet the criteria of the request.
         * </p>
         * 
         * @param simulationJobSummaries
         *        A list of simulation job summaries that meet the criteria of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulationJobSummaries(Collection<SimulationJobSummary> simulationJobSummaries);

        /**
         * <p>
         * A list of simulation job summaries that meet the criteria of the request.
         * </p>
         * 
         * @param simulationJobSummaries
         *        A list of simulation job summaries that meet the criteria of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulationJobSummaries(SimulationJobSummary... simulationJobSummaries);

        /**
         * <p>
         * A list of simulation job summaries that meet the criteria of the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SimulationJobSummary>.Builder} avoiding the
         * need to create one manually via {@link List<SimulationJobSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SimulationJobSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #simulationJobSummaries(List<SimulationJobSummary>)}.
         * 
         * @param simulationJobSummaries
         *        a consumer that will call methods on {@link List<SimulationJobSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simulationJobSummaries(List<SimulationJobSummary>)
         */
        Builder simulationJobSummaries(Consumer<SimulationJobSummary.Builder>... simulationJobSummaries);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListSimulationJobs</code> request. When the
         * results of a <code>ListRobot</code> request exceed <code>maxResults</code>, this value can be used to
         * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListSimulationJobs</code> request. When
         *        the results of a <code>ListRobot</code> request exceed <code>maxResults</code>, this value can be used
         *        to retrieve the next page of results. This value is <code>null</code> when there are no more results
         *        to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private List<SimulationJobSummary> simulationJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSimulationJobsResponse model) {
            super(model);
            simulationJobSummaries(model.simulationJobSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<SimulationJobSummary.Builder> getSimulationJobSummaries() {
            return simulationJobSummaries != null ? simulationJobSummaries.stream().map(SimulationJobSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder simulationJobSummaries(Collection<SimulationJobSummary> simulationJobSummaries) {
            this.simulationJobSummaries = SimulationJobSummariesCopier.copy(simulationJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationJobSummaries(SimulationJobSummary... simulationJobSummaries) {
            simulationJobSummaries(Arrays.asList(simulationJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationJobSummaries(Consumer<SimulationJobSummary.Builder>... simulationJobSummaries) {
            simulationJobSummaries(Stream.of(simulationJobSummaries)
                    .map(c -> SimulationJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSimulationJobSummaries(Collection<SimulationJobSummary.BuilderImpl> simulationJobSummaries) {
            this.simulationJobSummaries = SimulationJobSummariesCopier.copyFromBuilder(simulationJobSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSimulationJobsResponse build() {
            return new ListSimulationJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
