/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.DelegationSetNameServersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DelegationSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DelegationSet> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DelegationSet.getter(DelegationSet::id)).setter(DelegationSet.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DelegationSet.getter(DelegationSet::callerReference)).setter(DelegationSet.setter(Builder::callerReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference").unmarshallLocationName("CallerReference").build()}).build();
    private static final SdkField<List<String>> NAME_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DelegationSet.getter(DelegationSet::nameServers)).setter(DelegationSet.setter(Builder::nameServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameServers").unmarshallLocationName("NameServers").build(), ListTrait.builder().memberLocationName("NameServer").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameServer").unmarshallLocationName("NameServer").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CALLER_REFERENCE_FIELD, NAME_SERVERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String callerReference;
    private final List<String> nameServers;

    private DelegationSet(BuilderImpl builder) {
        this.id = builder.id;
        this.callerReference = builder.callerReference;
        this.nameServers = builder.nameServers;
    }

    public String id() {
        return this.id;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public boolean hasNameServers() {
        return this.nameServers != null && !(this.nameServers instanceof SdkAutoConstructList);
    }

    public List<String> nameServers() {
        return this.nameServers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameServers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelegationSet)) {
            return false;
        }
        DelegationSet other = (DelegationSet)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.callerReference(), other.callerReference()) && Objects.equals(this.nameServers(), other.nameServers());
    }

    public String toString() {
        return ToString.builder((String)"DelegationSet").add("Id", (Object)this.id()).add("CallerReference", (Object)this.callerReference()).add("NameServers", this.nameServers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "CallerReference": {
                return Optional.ofNullable(clazz.cast(this.callerReference()));
            }
            case "NameServers": {
                return Optional.ofNullable(clazz.cast(this.nameServers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DelegationSet, T> g) {
        return obj -> g.apply((DelegationSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String callerReference;
        private List<String> nameServers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DelegationSet model) {
            this.id(model.id);
            this.callerReference(model.callerReference);
            this.nameServers(model.nameServers);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final Collection<String> getNameServers() {
            return this.nameServers;
        }

        @Override
        public final Builder nameServers(Collection<String> nameServers) {
            this.nameServers = DelegationSetNameServersCopier.copy(nameServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameServers(String ... nameServers) {
            this.nameServers(Arrays.asList(nameServers));
            return this;
        }

        public final void setNameServers(Collection<String> nameServers) {
            this.nameServers = DelegationSetNameServersCopier.copy(nameServers);
        }

        public DelegationSet build() {
            return new DelegationSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DelegationSet> {
        public Builder id(String var1);

        public Builder callerReference(String var1);

        public Builder nameServers(Collection<String> var1);

        public Builder nameServers(String ... var1);
    }
}

