/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the <code>CheckerIpRanges</code> element.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCheckerIpRangesResponse extends Route53Response implements
        ToCopyableBuilder<GetCheckerIpRangesResponse.Builder, GetCheckerIpRangesResponse> {
    private static final SdkField<List<String>> CHECKER_IP_RANGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CheckerIpRanges")
            .getter(getter(GetCheckerIpRangesResponse::checkerIpRanges))
            .setter(setter(Builder::checkerIpRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckerIpRanges")
                    .unmarshallLocationName("CheckerIpRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECKER_IP_RANGES_FIELD));

    private final List<String> checkerIpRanges;

    private GetCheckerIpRangesResponse(BuilderImpl builder) {
        super(builder);
        this.checkerIpRanges = builder.checkerIpRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the CheckerIpRanges property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCheckerIpRanges() {
        return checkerIpRanges != null && !(checkerIpRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains sorted list of IP ranges in CIDR format for Amazon Route 53 health checkers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCheckerIpRanges} method.
     * </p>
     * 
     * @return A complex type that contains sorted list of IP ranges in CIDR format for Amazon Route 53 health checkers.
     */
    public final List<String> checkerIpRanges() {
        return checkerIpRanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCheckerIpRanges() ? checkerIpRanges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCheckerIpRangesResponse)) {
            return false;
        }
        GetCheckerIpRangesResponse other = (GetCheckerIpRangesResponse) obj;
        return hasCheckerIpRanges() == other.hasCheckerIpRanges() && Objects.equals(checkerIpRanges(), other.checkerIpRanges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCheckerIpRangesResponse")
                .add("CheckerIpRanges", hasCheckerIpRanges() ? checkerIpRanges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CheckerIpRanges":
            return Optional.ofNullable(clazz.cast(checkerIpRanges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCheckerIpRangesResponse, T> g) {
        return obj -> g.apply((GetCheckerIpRangesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, GetCheckerIpRangesResponse> {
        /**
         * <p>
         * A complex type that contains sorted list of IP ranges in CIDR format for Amazon Route 53 health checkers.
         * </p>
         * 
         * @param checkerIpRanges
         *        A complex type that contains sorted list of IP ranges in CIDR format for Amazon Route 53 health
         *        checkers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkerIpRanges(Collection<String> checkerIpRanges);

        /**
         * <p>
         * A complex type that contains sorted list of IP ranges in CIDR format for Amazon Route 53 health checkers.
         * </p>
         * 
         * @param checkerIpRanges
         *        A complex type that contains sorted list of IP ranges in CIDR format for Amazon Route 53 health
         *        checkers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkerIpRanges(String... checkerIpRanges);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<String> checkerIpRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCheckerIpRangesResponse model) {
            super(model);
            checkerIpRanges(model.checkerIpRanges);
        }

        public final Collection<String> getCheckerIpRanges() {
            if (checkerIpRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return checkerIpRanges;
        }

        public final void setCheckerIpRanges(Collection<String> checkerIpRanges) {
            this.checkerIpRanges = CheckerIpRangesCopier.copy(checkerIpRanges);
        }

        @Override
        public final Builder checkerIpRanges(Collection<String> checkerIpRanges) {
            this.checkerIpRanges = CheckerIpRangesCopier.copy(checkerIpRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkerIpRanges(String... checkerIpRanges) {
            checkerIpRanges(Arrays.asList(checkerIpRanges));
            return this;
        }

        @Override
        public GetCheckerIpRangesResponse build() {
            return new GetCheckerIpRangesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
