/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the health checks or hosted zones for which you want to list tags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTagsForResourceResponse extends Route53Response implements
        ToCopyableBuilder<ListTagsForResourceResponse.Builder, ListTagsForResourceResponse> {
    private static final SdkField<ResourceTagSet> RESOURCE_TAG_SET_FIELD = SdkField
            .<ResourceTagSet> builder(MarshallingType.SDK_POJO)
            .memberName("ResourceTagSet")
            .getter(getter(ListTagsForResourceResponse::resourceTagSet))
            .setter(setter(Builder::resourceTagSet))
            .constructor(ResourceTagSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTagSet")
                    .unmarshallLocationName("ResourceTagSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TAG_SET_FIELD));

    private final ResourceTagSet resourceTagSet;

    private ListTagsForResourceResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTagSet = builder.resourceTagSet;
    }

    /**
     * <p>
     * A <code>ResourceTagSet</code> containing tags associated with the specified resource.
     * </p>
     * 
     * @return A <code>ResourceTagSet</code> containing tags associated with the specified resource.
     */
    public final ResourceTagSet resourceTagSet() {
        return resourceTagSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceTagSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceResponse)) {
            return false;
        }
        ListTagsForResourceResponse other = (ListTagsForResourceResponse) obj;
        return Objects.equals(resourceTagSet(), other.resourceTagSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTagsForResourceResponse").add("ResourceTagSet", resourceTagSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceTagSet":
            return Optional.ofNullable(clazz.cast(resourceTagSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTagsForResourceResponse, T> g) {
        return obj -> g.apply((ListTagsForResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, ListTagsForResourceResponse> {
        /**
         * <p>
         * A <code>ResourceTagSet</code> containing tags associated with the specified resource.
         * </p>
         * 
         * @param resourceTagSet
         *        A <code>ResourceTagSet</code> containing tags associated with the specified resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTagSet(ResourceTagSet resourceTagSet);

        /**
         * <p>
         * A <code>ResourceTagSet</code> containing tags associated with the specified resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceTagSet.Builder} avoiding the need
         * to create one manually via {@link ResourceTagSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceTagSet.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceTagSet(ResourceTagSet)}.
         * 
         * @param resourceTagSet
         *        a consumer that will call methods on {@link ResourceTagSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTagSet(ResourceTagSet)
         */
        default Builder resourceTagSet(Consumer<ResourceTagSet.Builder> resourceTagSet) {
            return resourceTagSet(ResourceTagSet.builder().applyMutation(resourceTagSet).build());
        }
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private ResourceTagSet resourceTagSet;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourceResponse model) {
            super(model);
            resourceTagSet(model.resourceTagSet);
        }

        public final ResourceTagSet.Builder getResourceTagSet() {
            return resourceTagSet != null ? resourceTagSet.toBuilder() : null;
        }

        public final void setResourceTagSet(ResourceTagSet.BuilderImpl resourceTagSet) {
            this.resourceTagSet = resourceTagSet != null ? resourceTagSet.build() : null;
        }

        @Override
        public final Builder resourceTagSet(ResourceTagSet resourceTagSet) {
            this.resourceTagSet = resourceTagSet;
            return this;
        }

        @Override
        public ListTagsForResourceResponse build() {
            return new ListTagsForResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
