/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.transfer.s3.model.CompletedDirectoryTransfer;
import software.amazon.awssdk.transfer.s3.model.FailedFileDownload;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class CompletedDirectoryDownload
implements CompletedDirectoryTransfer,
ToCopyableBuilder<Builder, CompletedDirectoryDownload> {
    private final List<FailedFileDownload> failedTransfers;

    private CompletedDirectoryDownload(DefaultBuilder builder) {
        this.failedTransfers = Collections.unmodifiableList(new ArrayList((Collection)Validate.paramNotNull((Object)builder.failedTransfers, (String)"failedTransfers")));
    }

    public List<FailedFileDownload> failedTransfers() {
        return this.failedTransfers;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompletedDirectoryDownload that = (CompletedDirectoryDownload)o;
        return Objects.equals(this.failedTransfers, that.failedTransfers);
    }

    public int hashCode() {
        return this.failedTransfers != null ? this.failedTransfers.hashCode() : 0;
    }

    public String toString() {
        return ToString.builder((String)"CompletedDirectoryDownload").add("failedTransfers", this.failedTransfers).build();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return DefaultBuilder.class;
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    private static final class DefaultBuilder
    implements Builder {
        private Collection<FailedFileDownload> failedTransfers = new ArrayList<FailedFileDownload>();

        private DefaultBuilder() {
        }

        private DefaultBuilder(CompletedDirectoryDownload completedDirectoryDownload) {
            this.failedTransfers = new ArrayList<FailedFileDownload>(completedDirectoryDownload.failedTransfers);
        }

        @Override
        public Builder failedTransfers(Collection<FailedFileDownload> failedTransfers) {
            this.failedTransfers = new ArrayList<FailedFileDownload>(failedTransfers);
            return this;
        }

        @Override
        public Builder addFailedTransfer(FailedFileDownload failedTransfer) {
            this.failedTransfers.add(failedTransfer);
            return this;
        }

        public Collection<FailedFileDownload> getFailedTransfers() {
            return Collections.unmodifiableCollection(this.failedTransfers);
        }

        public void setFailedTransfers(Collection<FailedFileDownload> failedTransfers) {
            this.failedTransfers(failedTransfers);
        }

        @Override
        public CompletedDirectoryDownload build() {
            return new CompletedDirectoryDownload(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CompletedDirectoryDownload> {
        public Builder failedTransfers(Collection<FailedFileDownload> var1);

        public Builder addFailedTransfer(FailedFileDownload var1);

        public CompletedDirectoryDownload build();
    }
}

