/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The app's details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppDetails implements SdkPojo, Serializable, ToCopyableBuilder<AppDetails.Builder, AppDetails> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AppDetails::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AppDetails::userProfileName)).setter(setter(Builder::userProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()).build();

    private static final SdkField<String> APP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AppDetails::appTypeAsString)).setter(setter(Builder::appType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppType").build()).build();

    private static final SdkField<String> APP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AppDetails::appName)).setter(setter(Builder::appName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AppDetails::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AppDetails::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            USER_PROFILE_NAME_FIELD, APP_TYPE_FIELD, APP_NAME_FIELD, STATUS_FIELD, CREATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domainId;

    private final String userProfileName;

    private final String appType;

    private final String appName;

    private final String status;

    private final Instant creationTime;

    private AppDetails(BuilderImpl builder) {
        this.domainId = builder.domainId;
        this.userProfileName = builder.userProfileName;
        this.appType = builder.appType;
        this.appName = builder.appName;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The domain ID.
     * </p>
     * 
     * @return The domain ID.
     */
    public String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The user profile name.
     * </p>
     * 
     * @return The user profile name.
     */
    public String userProfileName() {
        return userProfileName;
    }

    /**
     * <p>
     * The type of app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appType} will
     * return {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appTypeAsString}.
     * </p>
     * 
     * @return The type of app.
     * @see AppType
     */
    public AppType appType() {
        return AppType.fromValue(appType);
    }

    /**
     * <p>
     * The type of app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appType} will
     * return {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appTypeAsString}.
     * </p>
     * 
     * @return The type of app.
     * @see AppType
     */
    public String appTypeAsString() {
        return appType;
    }

    /**
     * <p>
     * The name of the app.
     * </p>
     * 
     * @return The name of the app.
     */
    public String appName() {
        return appName;
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see AppStatus
     */
    public AppStatus status() {
        return AppStatus.fromValue(status);
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see AppStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(appTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(appName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppDetails)) {
            return false;
        }
        AppDetails other = (AppDetails) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(userProfileName(), other.userProfileName())
                && Objects.equals(appTypeAsString(), other.appTypeAsString()) && Objects.equals(appName(), other.appName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AppDetails").add("DomainId", domainId()).add("UserProfileName", userProfileName())
                .add("AppType", appTypeAsString()).add("AppName", appName()).add("Status", statusAsString())
                .add("CreationTime", creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "UserProfileName":
            return Optional.ofNullable(clazz.cast(userProfileName()));
        case "AppType":
            return Optional.ofNullable(clazz.cast(appTypeAsString()));
        case "AppName":
            return Optional.ofNullable(clazz.cast(appName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppDetails, T> g) {
        return obj -> g.apply((AppDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppDetails> {
        /**
         * <p>
         * The domain ID.
         * </p>
         * 
         * @param domainId
         *        The domain ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The user profile name.
         * </p>
         * 
         * @param userProfileName
         *        The user profile name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfileName(String userProfileName);

        /**
         * <p>
         * The type of app.
         * </p>
         * 
         * @param appType
         *        The type of app.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder appType(String appType);

        /**
         * <p>
         * The type of app.
         * </p>
         * 
         * @param appType
         *        The type of app.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder appType(AppType appType);

        /**
         * <p>
         * The name of the app.
         * </p>
         * 
         * @param appName
         *        The name of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appName(String appName);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see AppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see AppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppStatus
         */
        Builder status(AppStatus status);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String domainId;

        private String userProfileName;

        private String appType;

        private String appName;

        private String status;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AppDetails model) {
            domainId(model.domainId);
            userProfileName(model.userProfileName);
            appType(model.appType);
            appName(model.appName);
            status(model.status);
            creationTime(model.creationTime);
        }

        public final String getDomainId() {
            return domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public final String getUserProfileName() {
            return userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        public final String getAppTypeAsString() {
            return appType;
        }

        @Override
        public final Builder appType(String appType) {
            this.appType = appType;
            return this;
        }

        @Override
        public final Builder appType(AppType appType) {
            this.appType(appType == null ? null : appType.toString());
            return this;
        }

        public final void setAppType(String appType) {
            this.appType = appType;
        }

        public final String getAppName() {
            return appName;
        }

        @Override
        public final Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public final void setAppName(String appName) {
            this.appName = appName;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AppStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public AppDetails build() {
            return new AppDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
