/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLabelingJobRequest extends SageMakerRequest implements
        ToCopyableBuilder<DescribeLabelingJobRequest.Builder, DescribeLabelingJobRequest> {
    private static final SdkField<String> LABELING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLabelingJobRequest::labelingJobName)).setter(setter(Builder::labelingJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELING_JOB_NAME_FIELD));

    private final String labelingJobName;

    private DescribeLabelingJobRequest(BuilderImpl builder) {
        super(builder);
        this.labelingJobName = builder.labelingJobName;
    }

    /**
     * <p>
     * The name of the labeling job to return information for.
     * </p>
     * 
     * @return The name of the labeling job to return information for.
     */
    public String labelingJobName() {
        return labelingJobName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(labelingJobName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLabelingJobRequest)) {
            return false;
        }
        DescribeLabelingJobRequest other = (DescribeLabelingJobRequest) obj;
        return Objects.equals(labelingJobName(), other.labelingJobName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeLabelingJobRequest").add("LabelingJobName", labelingJobName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelingJobName":
            return Optional.ofNullable(clazz.cast(labelingJobName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLabelingJobRequest, T> g) {
        return obj -> g.apply((DescribeLabelingJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLabelingJobRequest> {
        /**
         * <p>
         * The name of the labeling job to return information for.
         * </p>
         * 
         * @param labelingJobName
         *        The name of the labeling job to return information for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobName(String labelingJobName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String labelingJobName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLabelingJobRequest model) {
            super(model);
            labelingJobName(model.labelingJobName);
        }

        public final String getLabelingJobName() {
            return labelingJobName;
        }

        @Override
        public final Builder labelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
            return this;
        }

        public final void setLabelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLabelingJobRequest build() {
            return new DescribeLabelingJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
