/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines under what conditions SageMaker creates a human loop.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HumanLoopActivationConditionsConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HumanLoopActivationConditionsConfig.Builder, HumanLoopActivationConditionsConfig> {
    private static final SdkField<String> HUMAN_LOOP_ACTIVATION_CONDITIONS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(HumanLoopActivationConditionsConfig::humanLoopActivationConditions))
            .setter(setter(Builder::humanLoopActivationConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopActivationConditions")
                    .build(), JsonValueTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(HUMAN_LOOP_ACTIVATION_CONDITIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String humanLoopActivationConditions;

    private HumanLoopActivationConditionsConfig(BuilderImpl builder) {
        this.humanLoopActivationConditions = builder.humanLoopActivationConditions;
    }

    /**
     * <p>
     * JSON expressing use-case specific conditions declaratively. If any condition is matched, atomic tasks are created
     * against the configured work team. The set of conditions is different for Rekognition and Textract.
     * </p>
     * 
     * @return JSON expressing use-case specific conditions declaratively. If any condition is matched, atomic tasks are
     *         created against the configured work team. The set of conditions is different for Rekognition and
     *         Textract.
     */
    public String humanLoopActivationConditions() {
        return humanLoopActivationConditions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopActivationConditions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanLoopActivationConditionsConfig)) {
            return false;
        }
        HumanLoopActivationConditionsConfig other = (HumanLoopActivationConditionsConfig) obj;
        return Objects.equals(humanLoopActivationConditions(), other.humanLoopActivationConditions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HumanLoopActivationConditionsConfig")
                .add("HumanLoopActivationConditions", humanLoopActivationConditions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanLoopActivationConditions":
            return Optional.ofNullable(clazz.cast(humanLoopActivationConditions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HumanLoopActivationConditionsConfig, T> g) {
        return obj -> g.apply((HumanLoopActivationConditionsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HumanLoopActivationConditionsConfig> {
        /**
         * <p>
         * JSON expressing use-case specific conditions declaratively. If any condition is matched, atomic tasks are
         * created against the configured work team. The set of conditions is different for Rekognition and Textract.
         * </p>
         * 
         * @param humanLoopActivationConditions
         *        JSON expressing use-case specific conditions declaratively. If any condition is matched, atomic tasks
         *        are created against the configured work team. The set of conditions is different for Rekognition and
         *        Textract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopActivationConditions(String humanLoopActivationConditions);
    }

    static final class BuilderImpl implements Builder {
        private String humanLoopActivationConditions;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanLoopActivationConditionsConfig model) {
            humanLoopActivationConditions(model.humanLoopActivationConditions);
        }

        public final String getHumanLoopActivationConditions() {
            return humanLoopActivationConditions;
        }

        @Override
        public final Builder humanLoopActivationConditions(String humanLoopActivationConditions) {
            this.humanLoopActivationConditions = humanLoopActivationConditions;
            return this;
        }

        public final void setHumanLoopActivationConditions(String humanLoopActivationConditions) {
            this.humanLoopActivationConditions = humanLoopActivationConditions;
        }

        @Override
        public HumanLoopActivationConditionsConfig build() {
            return new HumanLoopActivationConditionsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
