/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of conditions for stopping a labeling job. If any of the conditions are met, the job is automatically stopped.
 * You can use these conditions to control the cost of data labeling.
 * </p>
 * <note>
 * <p>
 * Labeling jobs fail after 30 days with an appropriate client error message.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelingJobStoppingConditions implements SdkPojo, Serializable,
        ToCopyableBuilder<LabelingJobStoppingConditions.Builder, LabelingJobStoppingConditions> {
    private static final SdkField<Integer> MAX_HUMAN_LABELED_OBJECT_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(LabelingJobStoppingConditions::maxHumanLabeledObjectCount))
            .setter(setter(Builder::maxHumanLabeledObjectCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxHumanLabeledObjectCount").build())
            .build();

    private static final SdkField<Integer> MAX_PERCENTAGE_OF_INPUT_DATASET_LABELED_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(LabelingJobStoppingConditions::maxPercentageOfInputDatasetLabeled))
            .setter(setter(Builder::maxPercentageOfInputDatasetLabeled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPercentageOfInputDatasetLabeled")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MAX_HUMAN_LABELED_OBJECT_COUNT_FIELD, MAX_PERCENTAGE_OF_INPUT_DATASET_LABELED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxHumanLabeledObjectCount;

    private final Integer maxPercentageOfInputDatasetLabeled;

    private LabelingJobStoppingConditions(BuilderImpl builder) {
        this.maxHumanLabeledObjectCount = builder.maxHumanLabeledObjectCount;
        this.maxPercentageOfInputDatasetLabeled = builder.maxPercentageOfInputDatasetLabeled;
    }

    /**
     * <p>
     * The maximum number of objects that can be labeled by human workers.
     * </p>
     * 
     * @return The maximum number of objects that can be labeled by human workers.
     */
    public Integer maxHumanLabeledObjectCount() {
        return maxHumanLabeledObjectCount;
    }

    /**
     * <p>
     * The maximum number of input data objects that should be labeled.
     * </p>
     * 
     * @return The maximum number of input data objects that should be labeled.
     */
    public Integer maxPercentageOfInputDatasetLabeled() {
        return maxPercentageOfInputDatasetLabeled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxHumanLabeledObjectCount());
        hashCode = 31 * hashCode + Objects.hashCode(maxPercentageOfInputDatasetLabeled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobStoppingConditions)) {
            return false;
        }
        LabelingJobStoppingConditions other = (LabelingJobStoppingConditions) obj;
        return Objects.equals(maxHumanLabeledObjectCount(), other.maxHumanLabeledObjectCount())
                && Objects.equals(maxPercentageOfInputDatasetLabeled(), other.maxPercentageOfInputDatasetLabeled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LabelingJobStoppingConditions").add("MaxHumanLabeledObjectCount", maxHumanLabeledObjectCount())
                .add("MaxPercentageOfInputDatasetLabeled", maxPercentageOfInputDatasetLabeled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxHumanLabeledObjectCount":
            return Optional.ofNullable(clazz.cast(maxHumanLabeledObjectCount()));
        case "MaxPercentageOfInputDatasetLabeled":
            return Optional.ofNullable(clazz.cast(maxPercentageOfInputDatasetLabeled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobStoppingConditions, T> g) {
        return obj -> g.apply((LabelingJobStoppingConditions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelingJobStoppingConditions> {
        /**
         * <p>
         * The maximum number of objects that can be labeled by human workers.
         * </p>
         * 
         * @param maxHumanLabeledObjectCount
         *        The maximum number of objects that can be labeled by human workers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxHumanLabeledObjectCount(Integer maxHumanLabeledObjectCount);

        /**
         * <p>
         * The maximum number of input data objects that should be labeled.
         * </p>
         * 
         * @param maxPercentageOfInputDatasetLabeled
         *        The maximum number of input data objects that should be labeled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPercentageOfInputDatasetLabeled(Integer maxPercentageOfInputDatasetLabeled);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxHumanLabeledObjectCount;

        private Integer maxPercentageOfInputDatasetLabeled;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobStoppingConditions model) {
            maxHumanLabeledObjectCount(model.maxHumanLabeledObjectCount);
            maxPercentageOfInputDatasetLabeled(model.maxPercentageOfInputDatasetLabeled);
        }

        public final Integer getMaxHumanLabeledObjectCount() {
            return maxHumanLabeledObjectCount;
        }

        @Override
        public final Builder maxHumanLabeledObjectCount(Integer maxHumanLabeledObjectCount) {
            this.maxHumanLabeledObjectCount = maxHumanLabeledObjectCount;
            return this;
        }

        public final void setMaxHumanLabeledObjectCount(Integer maxHumanLabeledObjectCount) {
            this.maxHumanLabeledObjectCount = maxHumanLabeledObjectCount;
        }

        public final Integer getMaxPercentageOfInputDatasetLabeled() {
            return maxPercentageOfInputDatasetLabeled;
        }

        @Override
        public final Builder maxPercentageOfInputDatasetLabeled(Integer maxPercentageOfInputDatasetLabeled) {
            this.maxPercentageOfInputDatasetLabeled = maxPercentageOfInputDatasetLabeled;
            return this;
        }

        public final void setMaxPercentageOfInputDatasetLabeled(Integer maxPercentageOfInputDatasetLabeled) {
            this.maxPercentageOfInputDatasetLabeled = maxPercentageOfInputDatasetLabeled;
        }

        @Override
        public LabelingJobStoppingConditions build() {
            return new LabelingJobStoppingConditions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
