/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrainingJobsForHyperParameterTuningJobResponse extends SageMakerResponse
        implements
        ToCopyableBuilder<ListTrainingJobsForHyperParameterTuningJobResponse.Builder, ListTrainingJobsForHyperParameterTuningJobResponse> {
    private static final SdkField<List<HyperParameterTrainingJobSummary>> TRAINING_JOB_SUMMARIES_FIELD = SdkField
            .<List<HyperParameterTrainingJobSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListTrainingJobsForHyperParameterTuningJobResponse::trainingJobSummaries))
            .setter(setter(Builder::trainingJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HyperParameterTrainingJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(HyperParameterTrainingJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTrainingJobsForHyperParameterTuningJobResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<HyperParameterTrainingJobSummary> trainingJobSummaries;

    private final String nextToken;

    private ListTrainingJobsForHyperParameterTuningJobResponse(BuilderImpl builder) {
        super(builder);
        this.trainingJobSummaries = builder.trainingJobSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the TrainingJobSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTrainingJobSummaries() {
        return trainingJobSummaries != null && !(trainingJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a>TrainingJobSummary</a> objects that describe the training jobs that the
     * <code>ListTrainingJobsForHyperParameterTuningJob</code> request returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTrainingJobSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <a>TrainingJobSummary</a> objects that describe the training jobs that the
     *         <code>ListTrainingJobsForHyperParameterTuningJob</code> request returned.
     */
    public List<HyperParameterTrainingJobSummary> trainingJobSummaries() {
        return trainingJobSummaries;
    }

    /**
     * <p>
     * If the result of this <code>ListTrainingJobsForHyperParameterTuningJob</code> request was truncated, the response
     * includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the next request.
     * </p>
     * 
     * @return If the result of this <code>ListTrainingJobsForHyperParameterTuningJob</code> request was truncated, the
     *         response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in
     *         the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrainingJobsForHyperParameterTuningJobResponse)) {
            return false;
        }
        ListTrainingJobsForHyperParameterTuningJobResponse other = (ListTrainingJobsForHyperParameterTuningJobResponse) obj;
        return Objects.equals(trainingJobSummaries(), other.trainingJobSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTrainingJobsForHyperParameterTuningJobResponse")
                .add("TrainingJobSummaries", trainingJobSummaries()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrainingJobSummaries":
            return Optional.ofNullable(clazz.cast(trainingJobSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrainingJobsForHyperParameterTuningJobResponse, T> g) {
        return obj -> g.apply((ListTrainingJobsForHyperParameterTuningJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTrainingJobsForHyperParameterTuningJobResponse> {
        /**
         * <p>
         * A list of <a>TrainingJobSummary</a> objects that describe the training jobs that the
         * <code>ListTrainingJobsForHyperParameterTuningJob</code> request returned.
         * </p>
         * 
         * @param trainingJobSummaries
         *        A list of <a>TrainingJobSummary</a> objects that describe the training jobs that the
         *        <code>ListTrainingJobsForHyperParameterTuningJob</code> request returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobSummaries(Collection<HyperParameterTrainingJobSummary> trainingJobSummaries);

        /**
         * <p>
         * A list of <a>TrainingJobSummary</a> objects that describe the training jobs that the
         * <code>ListTrainingJobsForHyperParameterTuningJob</code> request returned.
         * </p>
         * 
         * @param trainingJobSummaries
         *        A list of <a>TrainingJobSummary</a> objects that describe the training jobs that the
         *        <code>ListTrainingJobsForHyperParameterTuningJob</code> request returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobSummaries(HyperParameterTrainingJobSummary... trainingJobSummaries);

        /**
         * <p>
         * A list of <a>TrainingJobSummary</a> objects that describe the training jobs that the
         * <code>ListTrainingJobsForHyperParameterTuningJob</code> request returned.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HyperParameterTrainingJobSummary>.Builder}
         * avoiding the need to create one manually via {@link List<HyperParameterTrainingJobSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HyperParameterTrainingJobSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #trainingJobSummaries(List<HyperParameterTrainingJobSummary>)}
         * .
         * 
         * @param trainingJobSummaries
         *        a consumer that will call methods on {@link List<HyperParameterTrainingJobSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingJobSummaries(List<HyperParameterTrainingJobSummary>)
         */
        Builder trainingJobSummaries(Consumer<HyperParameterTrainingJobSummary.Builder>... trainingJobSummaries);

        /**
         * <p>
         * If the result of this <code>ListTrainingJobsForHyperParameterTuningJob</code> request was truncated, the
         * response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the
         * next request.
         * </p>
         * 
         * @param nextToken
         *        If the result of this <code>ListTrainingJobsForHyperParameterTuningJob</code> request was truncated,
         *        the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the
         *        token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<HyperParameterTrainingJobSummary> trainingJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrainingJobsForHyperParameterTuningJobResponse model) {
            super(model);
            trainingJobSummaries(model.trainingJobSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<HyperParameterTrainingJobSummary.Builder> getTrainingJobSummaries() {
            return trainingJobSummaries != null ? trainingJobSummaries.stream().map(HyperParameterTrainingJobSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trainingJobSummaries(Collection<HyperParameterTrainingJobSummary> trainingJobSummaries) {
            this.trainingJobSummaries = HyperParameterTrainingJobSummariesCopier.copy(trainingJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingJobSummaries(HyperParameterTrainingJobSummary... trainingJobSummaries) {
            trainingJobSummaries(Arrays.asList(trainingJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingJobSummaries(Consumer<HyperParameterTrainingJobSummary.Builder>... trainingJobSummaries) {
            trainingJobSummaries(Stream.of(trainingJobSummaries)
                    .map(c -> HyperParameterTrainingJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTrainingJobSummaries(Collection<HyperParameterTrainingJobSummary.BuilderImpl> trainingJobSummaries) {
            this.trainingJobSummaries = HyperParameterTrainingJobSummariesCopier.copyFromBuilder(trainingJobSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTrainingJobsForHyperParameterTuningJobResponse build() {
            return new ListTrainingJobsForHyperParameterTuningJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
