/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resolved attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolvedAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ResolvedAttributes.Builder, ResolvedAttributes> {
    private static final SdkField<AutoMLJobObjective> AUTO_ML_JOB_OBJECTIVE_FIELD = SdkField
            .<AutoMLJobObjective> builder(MarshallingType.SDK_POJO).getter(getter(ResolvedAttributes::autoMLJobObjective))
            .setter(setter(Builder::autoMLJobObjective)).constructor(AutoMLJobObjective::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobObjective").build())
            .build();

    private static final SdkField<String> PROBLEM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResolvedAttributes::problemTypeAsString)).setter(setter(Builder::problemType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProblemType").build()).build();

    private static final SdkField<AutoMLJobCompletionCriteria> COMPLETION_CRITERIA_FIELD = SdkField
            .<AutoMLJobCompletionCriteria> builder(MarshallingType.SDK_POJO)
            .getter(getter(ResolvedAttributes::completionCriteria)).setter(setter(Builder::completionCriteria))
            .constructor(AutoMLJobCompletionCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionCriteria").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_JOB_OBJECTIVE_FIELD,
            PROBLEM_TYPE_FIELD, COMPLETION_CRITERIA_FIELD));

    private static final long serialVersionUID = 1L;

    private final AutoMLJobObjective autoMLJobObjective;

    private final String problemType;

    private final AutoMLJobCompletionCriteria completionCriteria;

    private ResolvedAttributes(BuilderImpl builder) {
        this.autoMLJobObjective = builder.autoMLJobObjective;
        this.problemType = builder.problemType;
        this.completionCriteria = builder.completionCriteria;
    }

    /**
     * Returns the value of the AutoMLJobObjective property for this object.
     * 
     * @return The value of the AutoMLJobObjective property for this object.
     */
    public AutoMLJobObjective autoMLJobObjective() {
        return autoMLJobObjective;
    }

    /**
     * <p>
     * The problem type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #problemType} will
     * return {@link ProblemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #problemTypeAsString}.
     * </p>
     * 
     * @return The problem type.
     * @see ProblemType
     */
    public ProblemType problemType() {
        return ProblemType.fromValue(problemType);
    }

    /**
     * <p>
     * The problem type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #problemType} will
     * return {@link ProblemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #problemTypeAsString}.
     * </p>
     * 
     * @return The problem type.
     * @see ProblemType
     */
    public String problemTypeAsString() {
        return problemType;
    }

    /**
     * Returns the value of the CompletionCriteria property for this object.
     * 
     * @return The value of the CompletionCriteria property for this object.
     */
    public AutoMLJobCompletionCriteria completionCriteria() {
        return completionCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobObjective());
        hashCode = 31 * hashCode + Objects.hashCode(problemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(completionCriteria());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolvedAttributes)) {
            return false;
        }
        ResolvedAttributes other = (ResolvedAttributes) obj;
        return Objects.equals(autoMLJobObjective(), other.autoMLJobObjective())
                && Objects.equals(problemTypeAsString(), other.problemTypeAsString())
                && Objects.equals(completionCriteria(), other.completionCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResolvedAttributes").add("AutoMLJobObjective", autoMLJobObjective())
                .add("ProblemType", problemTypeAsString()).add("CompletionCriteria", completionCriteria()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoMLJobObjective":
            return Optional.ofNullable(clazz.cast(autoMLJobObjective()));
        case "ProblemType":
            return Optional.ofNullable(clazz.cast(problemTypeAsString()));
        case "CompletionCriteria":
            return Optional.ofNullable(clazz.cast(completionCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolvedAttributes, T> g) {
        return obj -> g.apply((ResolvedAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResolvedAttributes> {
        /**
         * Sets the value of the AutoMLJobObjective property for this object.
         *
         * @param autoMLJobObjective
         *        The new value for the AutoMLJobObjective property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobObjective(AutoMLJobObjective autoMLJobObjective);

        /**
         * Sets the value of the AutoMLJobObjective property for this object.
         *
         * This is a convenience that creates an instance of the {@link AutoMLJobObjective.Builder} avoiding the need to
         * create one manually via {@link AutoMLJobObjective#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoMLJobObjective.Builder#build()} is called immediately and its
         * result is passed to {@link #autoMLJobObjective(AutoMLJobObjective)}.
         * 
         * @param autoMLJobObjective
         *        a consumer that will call methods on {@link AutoMLJobObjective.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMLJobObjective(AutoMLJobObjective)
         */
        default Builder autoMLJobObjective(Consumer<AutoMLJobObjective.Builder> autoMLJobObjective) {
            return autoMLJobObjective(AutoMLJobObjective.builder().applyMutation(autoMLJobObjective).build());
        }

        /**
         * <p>
         * The problem type.
         * </p>
         * 
         * @param problemType
         *        The problem type.
         * @see ProblemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProblemType
         */
        Builder problemType(String problemType);

        /**
         * <p>
         * The problem type.
         * </p>
         * 
         * @param problemType
         *        The problem type.
         * @see ProblemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProblemType
         */
        Builder problemType(ProblemType problemType);

        /**
         * Sets the value of the CompletionCriteria property for this object.
         *
         * @param completionCriteria
         *        The new value for the CompletionCriteria property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria);

        /**
         * Sets the value of the CompletionCriteria property for this object.
         *
         * This is a convenience that creates an instance of the {@link AutoMLJobCompletionCriteria.Builder} avoiding
         * the need to create one manually via {@link AutoMLJobCompletionCriteria#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoMLJobCompletionCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #completionCriteria(AutoMLJobCompletionCriteria)}.
         * 
         * @param completionCriteria
         *        a consumer that will call methods on {@link AutoMLJobCompletionCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #completionCriteria(AutoMLJobCompletionCriteria)
         */
        default Builder completionCriteria(Consumer<AutoMLJobCompletionCriteria.Builder> completionCriteria) {
            return completionCriteria(AutoMLJobCompletionCriteria.builder().applyMutation(completionCriteria).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutoMLJobObjective autoMLJobObjective;

        private String problemType;

        private AutoMLJobCompletionCriteria completionCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolvedAttributes model) {
            autoMLJobObjective(model.autoMLJobObjective);
            problemType(model.problemType);
            completionCriteria(model.completionCriteria);
        }

        public final AutoMLJobObjective.Builder getAutoMLJobObjective() {
            return autoMLJobObjective != null ? autoMLJobObjective.toBuilder() : null;
        }

        @Override
        public final Builder autoMLJobObjective(AutoMLJobObjective autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective;
            return this;
        }

        public final void setAutoMLJobObjective(AutoMLJobObjective.BuilderImpl autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective != null ? autoMLJobObjective.build() : null;
        }

        public final String getProblemTypeAsString() {
            return problemType;
        }

        @Override
        public final Builder problemType(String problemType) {
            this.problemType = problemType;
            return this;
        }

        @Override
        public final Builder problemType(ProblemType problemType) {
            this.problemType(problemType == null ? null : problemType.toString());
            return this;
        }

        public final void setProblemType(String problemType) {
            this.problemType = problemType;
        }

        public final AutoMLJobCompletionCriteria.Builder getCompletionCriteria() {
            return completionCriteria != null ? completionCriteria.toBuilder() : null;
        }

        @Override
        public final Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria) {
            this.completionCriteria = completionCriteria;
            return this;
        }

        public final void setCompletionCriteria(AutoMLJobCompletionCriteria.BuilderImpl completionCriteria) {
            this.completionCriteria = completionCriteria != null ? completionCriteria.build() : null;
        }

        @Override
        public ResolvedAttributes build() {
            return new ResolvedAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
