/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value of a hyperparameter. Only one of <code>NumberValue</code> or <code>StringValue</code> can be specified.
 * </p>
 * <p>
 * This object is specified in the <a>CreateTrialComponent</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrialComponentParameterValue implements SdkPojo, Serializable,
        ToCopyableBuilder<TrialComponentParameterValue.Builder, TrialComponentParameterValue> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TrialComponentParameterValue::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValue").build()).build();

    private static final SdkField<Double> NUMBER_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(TrialComponentParameterValue::numberValue)).setter(setter(Builder::numberValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD,
            NUMBER_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stringValue;

    private final Double numberValue;

    private TrialComponentParameterValue(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.numberValue = builder.numberValue;
    }

    /**
     * <p>
     * The string value of a categorical hyperparameter. If you specify a value for this parameter, you can't specify
     * the <code>NumberValue</code> parameter.
     * </p>
     * 
     * @return The string value of a categorical hyperparameter. If you specify a value for this parameter, you can't
     *         specify the <code>NumberValue</code> parameter.
     */
    public String stringValue() {
        return stringValue;
    }

    /**
     * <p>
     * The numeric value of a numeric hyperparameter. If you specify a value for this parameter, you can't specify the
     * <code>StringValue</code> parameter.
     * </p>
     * 
     * @return The numeric value of a numeric hyperparameter. If you specify a value for this parameter, you can't
     *         specify the <code>StringValue</code> parameter.
     */
    public Double numberValue() {
        return numberValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(numberValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialComponentParameterValue)) {
            return false;
        }
        TrialComponentParameterValue other = (TrialComponentParameterValue) obj;
        return Objects.equals(stringValue(), other.stringValue()) && Objects.equals(numberValue(), other.numberValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TrialComponentParameterValue").add("StringValue", stringValue())
                .add("NumberValue", numberValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "NumberValue":
            return Optional.ofNullable(clazz.cast(numberValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrialComponentParameterValue, T> g) {
        return obj -> g.apply((TrialComponentParameterValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrialComponentParameterValue> {
        /**
         * <p>
         * The string value of a categorical hyperparameter. If you specify a value for this parameter, you can't
         * specify the <code>NumberValue</code> parameter.
         * </p>
         * 
         * @param stringValue
         *        The string value of a categorical hyperparameter. If you specify a value for this parameter, you can't
         *        specify the <code>NumberValue</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * The numeric value of a numeric hyperparameter. If you specify a value for this parameter, you can't specify
         * the <code>StringValue</code> parameter.
         * </p>
         * 
         * @param numberValue
         *        The numeric value of a numeric hyperparameter. If you specify a value for this parameter, you can't
         *        specify the <code>StringValue</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberValue(Double numberValue);
    }

    static final class BuilderImpl implements Builder {
        private String stringValue;

        private Double numberValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialComponentParameterValue model) {
            stringValue(model.stringValue);
            numberValue(model.numberValue);
        }

        public final String getStringValue() {
            return stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public final Double getNumberValue() {
            return numberValue;
        }

        @Override
        public final Builder numberValue(Double numberValue) {
            this.numberValue = numberValue;
            return this;
        }

        public final void setNumberValue(Double numberValue) {
            this.numberValue = numberValue;
        }

        @Override
        public TrialComponentParameterValue build() {
            return new TrialComponentParameterValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
