/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ScheduleStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringScheduleSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringScheduleSummary> {
    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MonitoringScheduleSummary.getter(MonitoringScheduleSummary::monitoringScheduleName)).setter(MonitoringScheduleSummary.setter(Builder::monitoringScheduleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build()}).build();
    private static final SdkField<String> MONITORING_SCHEDULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MonitoringScheduleSummary.getter(MonitoringScheduleSummary::monitoringScheduleArn)).setter(MonitoringScheduleSummary.setter(Builder::monitoringScheduleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(MonitoringScheduleSummary.getter(MonitoringScheduleSummary::creationTime)).setter(MonitoringScheduleSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(MonitoringScheduleSummary.getter(MonitoringScheduleSummary::lastModifiedTime)).setter(MonitoringScheduleSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> MONITORING_SCHEDULE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MonitoringScheduleSummary.getter(MonitoringScheduleSummary::monitoringScheduleStatusAsString)).setter(MonitoringScheduleSummary.setter(Builder::monitoringScheduleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleStatus").build()}).build();
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MonitoringScheduleSummary.getter(MonitoringScheduleSummary::endpointName)).setter(MonitoringScheduleSummary.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_SCHEDULE_NAME_FIELD, MONITORING_SCHEDULE_ARN_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, MONITORING_SCHEDULE_STATUS_FIELD, ENDPOINT_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String monitoringScheduleName;
    private final String monitoringScheduleArn;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String monitoringScheduleStatus;
    private final String endpointName;

    private MonitoringScheduleSummary(BuilderImpl builder) {
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.monitoringScheduleArn = builder.monitoringScheduleArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.monitoringScheduleStatus = builder.monitoringScheduleStatus;
        this.endpointName = builder.endpointName;
    }

    public String monitoringScheduleName() {
        return this.monitoringScheduleName;
    }

    public String monitoringScheduleArn() {
        return this.monitoringScheduleArn;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public ScheduleStatus monitoringScheduleStatus() {
        return ScheduleStatus.fromValue(this.monitoringScheduleStatus);
    }

    public String monitoringScheduleStatusAsString() {
        return this.monitoringScheduleStatus;
    }

    public String endpointName() {
        return this.endpointName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringScheduleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringScheduleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringScheduleSummary)) {
            return false;
        }
        MonitoringScheduleSummary other = (MonitoringScheduleSummary)obj;
        return Objects.equals(this.monitoringScheduleName(), other.monitoringScheduleName()) && Objects.equals(this.monitoringScheduleArn(), other.monitoringScheduleArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.monitoringScheduleStatusAsString(), other.monitoringScheduleStatusAsString()) && Objects.equals(this.endpointName(), other.endpointName());
    }

    public String toString() {
        return ToString.builder((String)"MonitoringScheduleSummary").add("MonitoringScheduleName", (Object)this.monitoringScheduleName()).add("MonitoringScheduleArn", (Object)this.monitoringScheduleArn()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("MonitoringScheduleStatus", (Object)this.monitoringScheduleStatusAsString()).add("EndpointName", (Object)this.endpointName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitoringScheduleName": {
                return Optional.ofNullable(clazz.cast(this.monitoringScheduleName()));
            }
            case "MonitoringScheduleArn": {
                return Optional.ofNullable(clazz.cast(this.monitoringScheduleArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "MonitoringScheduleStatus": {
                return Optional.ofNullable(clazz.cast(this.monitoringScheduleStatusAsString()));
            }
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringScheduleSummary, T> g) {
        return obj -> g.apply((MonitoringScheduleSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String monitoringScheduleName;
        private String monitoringScheduleArn;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String monitoringScheduleStatus;
        private String endpointName;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringScheduleSummary model) {
            this.monitoringScheduleName(model.monitoringScheduleName);
            this.monitoringScheduleArn(model.monitoringScheduleArn);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.monitoringScheduleStatus(model.monitoringScheduleStatus);
            this.endpointName(model.endpointName);
        }

        public final String getMonitoringScheduleName() {
            return this.monitoringScheduleName;
        }

        @Override
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        public final String getMonitoringScheduleArn() {
            return this.monitoringScheduleArn;
        }

        @Override
        public final Builder monitoringScheduleArn(String monitoringScheduleArn) {
            this.monitoringScheduleArn = monitoringScheduleArn;
            return this;
        }

        public final void setMonitoringScheduleArn(String monitoringScheduleArn) {
            this.monitoringScheduleArn = monitoringScheduleArn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getMonitoringScheduleStatus() {
            return this.monitoringScheduleStatus;
        }

        @Override
        public final Builder monitoringScheduleStatus(String monitoringScheduleStatus) {
            this.monitoringScheduleStatus = monitoringScheduleStatus;
            return this;
        }

        @Override
        public final Builder monitoringScheduleStatus(ScheduleStatus monitoringScheduleStatus) {
            this.monitoringScheduleStatus(monitoringScheduleStatus == null ? null : monitoringScheduleStatus.toString());
            return this;
        }

        public final void setMonitoringScheduleStatus(String monitoringScheduleStatus) {
            this.monitoringScheduleStatus = monitoringScheduleStatus;
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public MonitoringScheduleSummary build() {
            return new MonitoringScheduleSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringScheduleSummary> {
        public Builder monitoringScheduleName(String var1);

        public Builder monitoringScheduleArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder monitoringScheduleStatus(String var1);

        public Builder monitoringScheduleStatus(ScheduleStatus var1);

        public Builder endpointName(String var1);
    }
}

