/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum S3DataType {
    MANIFEST_FILE("ManifestFile"),
    S3_PREFIX("S3Prefix"),
    AUGMENTED_MANIFEST_FILE("AugmentedManifestFile"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private S3DataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3DataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(S3DataType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3DataType> knownValues() {
        return Stream.of(S3DataType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

