/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.Experiment;
import software.amazon.awssdk.services.sagemaker.model.TrainingJob;
import software.amazon.awssdk.services.sagemaker.model.Trial;
import software.amazon.awssdk.services.sagemaker.model.TrialComponent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchRecord> {
    private static final SdkField<TrainingJob> TRAINING_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SearchRecord.getter(SearchRecord::trainingJob)).setter(SearchRecord.setter(Builder::trainingJob)).constructor(TrainingJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJob").build()}).build();
    private static final SdkField<Experiment> EXPERIMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SearchRecord.getter(SearchRecord::experiment)).setter(SearchRecord.setter(Builder::experiment)).constructor(Experiment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Experiment").build()}).build();
    private static final SdkField<Trial> TRIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SearchRecord.getter(SearchRecord::trial)).setter(SearchRecord.setter(Builder::trial)).constructor(Trial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trial").build()}).build();
    private static final SdkField<TrialComponent> TRIAL_COMPONENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SearchRecord.getter(SearchRecord::trialComponent)).setter(SearchRecord.setter(Builder::trialComponent)).constructor(TrialComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_FIELD, EXPERIMENT_FIELD, TRIAL_FIELD, TRIAL_COMPONENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final TrainingJob trainingJob;
    private final Experiment experiment;
    private final Trial trial;
    private final TrialComponent trialComponent;

    private SearchRecord(BuilderImpl builder) {
        this.trainingJob = builder.trainingJob;
        this.experiment = builder.experiment;
        this.trial = builder.trial;
        this.trialComponent = builder.trialComponent;
    }

    public TrainingJob trainingJob() {
        return this.trainingJob;
    }

    public Experiment experiment() {
        return this.experiment;
    }

    public Trial trial() {
        return this.trial;
    }

    public TrialComponent trialComponent() {
        return this.trialComponent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.experiment());
        hashCode = 31 * hashCode + Objects.hashCode(this.trial());
        hashCode = 31 * hashCode + Objects.hashCode(this.trialComponent());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRecord)) {
            return false;
        }
        SearchRecord other = (SearchRecord)obj;
        return Objects.equals(this.trainingJob(), other.trainingJob()) && Objects.equals(this.experiment(), other.experiment()) && Objects.equals(this.trial(), other.trial()) && Objects.equals(this.trialComponent(), other.trialComponent());
    }

    public String toString() {
        return ToString.builder((String)"SearchRecord").add("TrainingJob", (Object)this.trainingJob()).add("Experiment", (Object)this.experiment()).add("Trial", (Object)this.trial()).add("TrialComponent", (Object)this.trialComponent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingJob": {
                return Optional.ofNullable(clazz.cast(this.trainingJob()));
            }
            case "Experiment": {
                return Optional.ofNullable(clazz.cast(this.experiment()));
            }
            case "Trial": {
                return Optional.ofNullable(clazz.cast(this.trial()));
            }
            case "TrialComponent": {
                return Optional.ofNullable(clazz.cast(this.trialComponent()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchRecord, T> g) {
        return obj -> g.apply((SearchRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TrainingJob trainingJob;
        private Experiment experiment;
        private Trial trial;
        private TrialComponent trialComponent;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRecord model) {
            this.trainingJob(model.trainingJob);
            this.experiment(model.experiment);
            this.trial(model.trial);
            this.trialComponent(model.trialComponent);
        }

        public final TrainingJob.Builder getTrainingJob() {
            return this.trainingJob != null ? this.trainingJob.toBuilder() : null;
        }

        @Override
        public final Builder trainingJob(TrainingJob trainingJob) {
            this.trainingJob = trainingJob;
            return this;
        }

        public final void setTrainingJob(TrainingJob.BuilderImpl trainingJob) {
            this.trainingJob = trainingJob != null ? trainingJob.build() : null;
        }

        public final Experiment.Builder getExperiment() {
            return this.experiment != null ? this.experiment.toBuilder() : null;
        }

        @Override
        public final Builder experiment(Experiment experiment) {
            this.experiment = experiment;
            return this;
        }

        public final void setExperiment(Experiment.BuilderImpl experiment) {
            this.experiment = experiment != null ? experiment.build() : null;
        }

        public final Trial.Builder getTrial() {
            return this.trial != null ? this.trial.toBuilder() : null;
        }

        @Override
        public final Builder trial(Trial trial) {
            this.trial = trial;
            return this;
        }

        public final void setTrial(Trial.BuilderImpl trial) {
            this.trial = trial != null ? trial.build() : null;
        }

        public final TrialComponent.Builder getTrialComponent() {
            return this.trialComponent != null ? this.trialComponent.toBuilder() : null;
        }

        @Override
        public final Builder trialComponent(TrialComponent trialComponent) {
            this.trialComponent = trialComponent;
            return this;
        }

        public final void setTrialComponent(TrialComponent.BuilderImpl trialComponent) {
            this.trialComponent = trialComponent != null ? trialComponent.build() : null;
        }

        public SearchRecord build() {
            return new SearchRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchRecord> {
        public Builder trainingJob(TrainingJob var1);

        default public Builder trainingJob(Consumer<TrainingJob.Builder> trainingJob) {
            return this.trainingJob((TrainingJob)((TrainingJob.Builder)TrainingJob.builder().applyMutation(trainingJob)).build());
        }

        public Builder experiment(Experiment var1);

        default public Builder experiment(Consumer<Experiment.Builder> experiment) {
            return this.experiment((Experiment)((Experiment.Builder)Experiment.builder().applyMutation(experiment)).build());
        }

        public Builder trial(Trial var1);

        default public Builder trial(Consumer<Trial.Builder> trial) {
            return this.trial((Trial)((Trial.Builder)Trial.builder().applyMutation(trial)).build());
        }

        public Builder trialComponent(TrialComponent var1);

        default public Builder trialComponent(Consumer<TrialComponent.Builder> trialComponent) {
            return this.trialComponent((TrialComponent)((TrialComponent.Builder)TrialComponent.builder().applyMutation(trialComponent)).build());
        }
    }
}

