/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceAlgorithm
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceAlgorithm> {
    private static final SdkField<String> MODEL_DATA_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SourceAlgorithm.getter(SourceAlgorithm::modelDataUrl)).setter(SourceAlgorithm.setter(Builder::modelDataUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataUrl").build()}).build();
    private static final SdkField<String> ALGORITHM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SourceAlgorithm.getter(SourceAlgorithm::algorithmName)).setter(SourceAlgorithm.setter(Builder::algorithmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_DATA_URL_FIELD, ALGORITHM_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelDataUrl;
    private final String algorithmName;

    private SourceAlgorithm(BuilderImpl builder) {
        this.modelDataUrl = builder.modelDataUrl;
        this.algorithmName = builder.algorithmName;
    }

    public String modelDataUrl() {
        return this.modelDataUrl;
    }

    public String algorithmName() {
        return this.algorithmName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDataUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceAlgorithm)) {
            return false;
        }
        SourceAlgorithm other = (SourceAlgorithm)obj;
        return Objects.equals(this.modelDataUrl(), other.modelDataUrl()) && Objects.equals(this.algorithmName(), other.algorithmName());
    }

    public String toString() {
        return ToString.builder((String)"SourceAlgorithm").add("ModelDataUrl", (Object)this.modelDataUrl()).add("AlgorithmName", (Object)this.algorithmName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelDataUrl": {
                return Optional.ofNullable(clazz.cast(this.modelDataUrl()));
            }
            case "AlgorithmName": {
                return Optional.ofNullable(clazz.cast(this.algorithmName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceAlgorithm, T> g) {
        return obj -> g.apply((SourceAlgorithm)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelDataUrl;
        private String algorithmName;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceAlgorithm model) {
            this.modelDataUrl(model.modelDataUrl);
            this.algorithmName(model.algorithmName);
        }

        public final String getModelDataUrl() {
            return this.modelDataUrl;
        }

        @Override
        public final Builder modelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
            return this;
        }

        public final void setModelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
        }

        public final String getAlgorithmName() {
            return this.algorithmName;
        }

        @Override
        public final Builder algorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        public final void setAlgorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        public SourceAlgorithm build() {
            return new SourceAlgorithm(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceAlgorithm> {
        public Builder modelDataUrl(String var1);

        public Builder algorithmName(String var1);
    }
}

