/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsResponse;
import software.amazon.awssdk.services.sagemaker.model.MonitoringExecutionSummary;

public class ListMonitoringExecutionsIterable
implements SdkIterable<ListMonitoringExecutionsResponse> {
    private final SageMakerClient client;
    private final ListMonitoringExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMonitoringExecutionsIterable(SageMakerClient client, ListMonitoringExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMonitoringExecutionsResponseFetcher();
    }

    public Iterator<ListMonitoringExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MonitoringExecutionSummary> monitoringExecutionSummaries() {
        Function<ListMonitoringExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.monitoringExecutionSummaries() != null) {
                return response.monitoringExecutionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMonitoringExecutionsResponseFetcher
    implements SyncPageFetcher<ListMonitoringExecutionsResponse> {
        private ListMonitoringExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListMonitoringExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMonitoringExecutionsResponse nextPage(ListMonitoringExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListMonitoringExecutionsIterable.this.client.listMonitoringExecutions(ListMonitoringExecutionsIterable.this.firstRequest);
            }
            return ListMonitoringExecutionsIterable.this.client.listMonitoringExecutions((ListMonitoringExecutionsRequest)((Object)ListMonitoringExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

