/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakera2iruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the corresponding flow definition's human loop activation condition evaluation. Null if
 * <code>StartHumanLoop</code> was invoked directly.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HumanLoopActivationResults implements SdkPojo, Serializable,
        ToCopyableBuilder<HumanLoopActivationResults.Builder, HumanLoopActivationResults> {
    private static final SdkField<HumanLoopActivationReason> HUMAN_LOOP_ACTIVATION_REASON_FIELD = SdkField
            .<HumanLoopActivationReason> builder(MarshallingType.SDK_POJO)
            .getter(getter(HumanLoopActivationResults::humanLoopActivationReason))
            .setter(setter(Builder::humanLoopActivationReason)).constructor(HumanLoopActivationReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopActivationReason").build())
            .build();

    private static final SdkField<String> HUMAN_LOOP_ACTIVATION_CONDITIONS_EVALUATION_RESULTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(HumanLoopActivationResults::humanLoopActivationConditionsEvaluationResults))
            .setter(setter(Builder::humanLoopActivationConditionsEvaluationResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("HumanLoopActivationConditionsEvaluationResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HUMAN_LOOP_ACTIVATION_REASON_FIELD, HUMAN_LOOP_ACTIVATION_CONDITIONS_EVALUATION_RESULTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final HumanLoopActivationReason humanLoopActivationReason;

    private final String humanLoopActivationConditionsEvaluationResults;

    private HumanLoopActivationResults(BuilderImpl builder) {
        this.humanLoopActivationReason = builder.humanLoopActivationReason;
        this.humanLoopActivationConditionsEvaluationResults = builder.humanLoopActivationConditionsEvaluationResults;
    }

    /**
     * <p>
     * An object containing information about why a human loop was triggered.
     * </p>
     * 
     * @return An object containing information about why a human loop was triggered.
     */
    public HumanLoopActivationReason humanLoopActivationReason() {
        return humanLoopActivationReason;
    }

    /**
     * <p>
     * A copy of the human loop activation conditions of the flow definition, augmented with the results of evaluating
     * those conditions on the input provided to the <code>StartHumanLoop</code> operation.
     * </p>
     * 
     * @return A copy of the human loop activation conditions of the flow definition, augmented with the results of
     *         evaluating those conditions on the input provided to the <code>StartHumanLoop</code> operation.
     */
    public String humanLoopActivationConditionsEvaluationResults() {
        return humanLoopActivationConditionsEvaluationResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopActivationReason());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopActivationConditionsEvaluationResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanLoopActivationResults)) {
            return false;
        }
        HumanLoopActivationResults other = (HumanLoopActivationResults) obj;
        return Objects.equals(humanLoopActivationReason(), other.humanLoopActivationReason())
                && Objects.equals(humanLoopActivationConditionsEvaluationResults(),
                        other.humanLoopActivationConditionsEvaluationResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HumanLoopActivationResults").add("HumanLoopActivationReason", humanLoopActivationReason())
                .add("HumanLoopActivationConditionsEvaluationResults", humanLoopActivationConditionsEvaluationResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanLoopActivationReason":
            return Optional.ofNullable(clazz.cast(humanLoopActivationReason()));
        case "HumanLoopActivationConditionsEvaluationResults":
            return Optional.ofNullable(clazz.cast(humanLoopActivationConditionsEvaluationResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HumanLoopActivationResults, T> g) {
        return obj -> g.apply((HumanLoopActivationResults) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HumanLoopActivationResults> {
        /**
         * <p>
         * An object containing information about why a human loop was triggered.
         * </p>
         * 
         * @param humanLoopActivationReason
         *        An object containing information about why a human loop was triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopActivationReason(HumanLoopActivationReason humanLoopActivationReason);

        /**
         * <p>
         * An object containing information about why a human loop was triggered.
         * </p>
         * This is a convenience that creates an instance of the {@link HumanLoopActivationReason.Builder} avoiding the
         * need to create one manually via {@link HumanLoopActivationReason#builder()}.
         *
         * When the {@link Consumer} completes, {@link HumanLoopActivationReason.Builder#build()} is called immediately
         * and its result is passed to {@link #humanLoopActivationReason(HumanLoopActivationReason)}.
         * 
         * @param humanLoopActivationReason
         *        a consumer that will call methods on {@link HumanLoopActivationReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanLoopActivationReason(HumanLoopActivationReason)
         */
        default Builder humanLoopActivationReason(Consumer<HumanLoopActivationReason.Builder> humanLoopActivationReason) {
            return humanLoopActivationReason(HumanLoopActivationReason.builder().applyMutation(humanLoopActivationReason).build());
        }

        /**
         * <p>
         * A copy of the human loop activation conditions of the flow definition, augmented with the results of
         * evaluating those conditions on the input provided to the <code>StartHumanLoop</code> operation.
         * </p>
         * 
         * @param humanLoopActivationConditionsEvaluationResults
         *        A copy of the human loop activation conditions of the flow definition, augmented with the results of
         *        evaluating those conditions on the input provided to the <code>StartHumanLoop</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopActivationConditionsEvaluationResults(String humanLoopActivationConditionsEvaluationResults);
    }

    static final class BuilderImpl implements Builder {
        private HumanLoopActivationReason humanLoopActivationReason;

        private String humanLoopActivationConditionsEvaluationResults;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanLoopActivationResults model) {
            humanLoopActivationReason(model.humanLoopActivationReason);
            humanLoopActivationConditionsEvaluationResults(model.humanLoopActivationConditionsEvaluationResults);
        }

        public final HumanLoopActivationReason.Builder getHumanLoopActivationReason() {
            return humanLoopActivationReason != null ? humanLoopActivationReason.toBuilder() : null;
        }

        @Override
        public final Builder humanLoopActivationReason(HumanLoopActivationReason humanLoopActivationReason) {
            this.humanLoopActivationReason = humanLoopActivationReason;
            return this;
        }

        public final void setHumanLoopActivationReason(HumanLoopActivationReason.BuilderImpl humanLoopActivationReason) {
            this.humanLoopActivationReason = humanLoopActivationReason != null ? humanLoopActivationReason.build() : null;
        }

        public final String getHumanLoopActivationConditionsEvaluationResults() {
            return humanLoopActivationConditionsEvaluationResults;
        }

        @Override
        public final Builder humanLoopActivationConditionsEvaluationResults(String humanLoopActivationConditionsEvaluationResults) {
            this.humanLoopActivationConditionsEvaluationResults = humanLoopActivationConditionsEvaluationResults;
            return this;
        }

        public final void setHumanLoopActivationConditionsEvaluationResults(String humanLoopActivationConditionsEvaluationResults) {
            this.humanLoopActivationConditionsEvaluationResults = humanLoopActivationConditionsEvaluationResults;
        }

        @Override
        public HumanLoopActivationResults build() {
            return new HumanLoopActivationResults(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
