/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakera2iruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing the input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HumanLoopInputContent implements SdkPojo, Serializable,
        ToCopyableBuilder<HumanLoopInputContent.Builder, HumanLoopInputContent> {
    private static final SdkField<String> INPUT_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HumanLoopInputContent::inputContent)).setter(setter(Builder::inputContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputContent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_CONTENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputContent;

    private HumanLoopInputContent(BuilderImpl builder) {
        this.inputContent = builder.inputContent;
    }

    /**
     * <p>
     * Serialized input from the human loop.
     * </p>
     * 
     * @return Serialized input from the human loop.
     */
    public String inputContent() {
        return inputContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputContent());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanLoopInputContent)) {
            return false;
        }
        HumanLoopInputContent other = (HumanLoopInputContent) obj;
        return Objects.equals(inputContent(), other.inputContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HumanLoopInputContent").add("InputContent", inputContent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputContent":
            return Optional.ofNullable(clazz.cast(inputContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HumanLoopInputContent, T> g) {
        return obj -> g.apply((HumanLoopInputContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HumanLoopInputContent> {
        /**
         * <p>
         * Serialized input from the human loop.
         * </p>
         * 
         * @param inputContent
         *        Serialized input from the human loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputContent(String inputContent);
    }

    static final class BuilderImpl implements Builder {
        private String inputContent;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanLoopInputContent model) {
            inputContent(model.inputContent);
        }

        public final String getInputContent() {
            return inputContent;
        }

        @Override
        public final Builder inputContent(String inputContent) {
            this.inputContent = inputContent;
            return this;
        }

        public final void setInputContent(String inputContent) {
            this.inputContent = inputContent;
        }

        @Override
        public HumanLoopInputContent build() {
            return new HumanLoopInputContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
