/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakera2iruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about where the human output will be stored.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HumanLoopOutputContent implements SdkPojo, Serializable,
        ToCopyableBuilder<HumanLoopOutputContent.Builder, HumanLoopOutputContent> {
    private static final SdkField<String> OUTPUT_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HumanLoopOutputContent::outputS3Uri)).setter(setter(Builder::outputS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3Uri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_S3_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String outputS3Uri;

    private HumanLoopOutputContent(BuilderImpl builder) {
        this.outputS3Uri = builder.outputS3Uri;
    }

    /**
     * <p>
     * The location of the Amazon S3 object where Amazon Augmented AI stores your human loop output. The output is
     * stored at the following location: <code>s3://S3OutputPath/HumanLoopName/CreationTime/output.json</code>.
     * </p>
     * 
     * @return The location of the Amazon S3 object where Amazon Augmented AI stores your human loop output. The output
     *         is stored at the following location:
     *         <code>s3://S3OutputPath/HumanLoopName/CreationTime/output.json</code>.
     */
    public String outputS3Uri() {
        return outputS3Uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Uri());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanLoopOutputContent)) {
            return false;
        }
        HumanLoopOutputContent other = (HumanLoopOutputContent) obj;
        return Objects.equals(outputS3Uri(), other.outputS3Uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HumanLoopOutputContent").add("OutputS3Uri", outputS3Uri()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputS3Uri":
            return Optional.ofNullable(clazz.cast(outputS3Uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HumanLoopOutputContent, T> g) {
        return obj -> g.apply((HumanLoopOutputContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HumanLoopOutputContent> {
        /**
         * <p>
         * The location of the Amazon S3 object where Amazon Augmented AI stores your human loop output. The output is
         * stored at the following location: <code>s3://S3OutputPath/HumanLoopName/CreationTime/output.json</code>.
         * </p>
         * 
         * @param outputS3Uri
         *        The location of the Amazon S3 object where Amazon Augmented AI stores your human loop output. The
         *        output is stored at the following location:
         *        <code>s3://S3OutputPath/HumanLoopName/CreationTime/output.json</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Uri(String outputS3Uri);
    }

    static final class BuilderImpl implements Builder {
        private String outputS3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanLoopOutputContent model) {
            outputS3Uri(model.outputS3Uri);
        }

        public final String getOutputS3Uri() {
            return outputS3Uri;
        }

        @Override
        public final Builder outputS3Uri(String outputS3Uri) {
            this.outputS3Uri = outputS3Uri;
            return this;
        }

        public final void setOutputS3Uri(String outputS3Uri) {
            this.outputS3Uri = outputS3Uri;
        }

        @Override
        public HumanLoopOutputContent build() {
            return new HumanLoopOutputContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
