/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchRasterDataCollectionRequest extends SageMakerGeospatialRequest implements
        ToCopyableBuilder<SearchRasterDataCollectionRequest.Builder, SearchRasterDataCollectionRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(SearchRasterDataCollectionRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchRasterDataCollectionRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<RasterDataCollectionQueryWithBandFilterInput> RASTER_DATA_COLLECTION_QUERY_FIELD = SdkField
            .<RasterDataCollectionQueryWithBandFilterInput> builder(MarshallingType.SDK_POJO)
            .memberName("RasterDataCollectionQuery").getter(getter(SearchRasterDataCollectionRequest::rasterDataCollectionQuery))
            .setter(setter(Builder::rasterDataCollectionQuery))
            .constructor(RasterDataCollectionQueryWithBandFilterInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RasterDataCollectionQuery").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NEXT_TOKEN_FIELD,
            RASTER_DATA_COLLECTION_QUERY_FIELD));

    private final String arn;

    private final String nextToken;

    private final RasterDataCollectionQueryWithBandFilterInput rasterDataCollectionQuery;

    private SearchRasterDataCollectionRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.nextToken = builder.nextToken;
        this.rasterDataCollectionQuery = builder.rasterDataCollectionQuery;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the raster data collection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the raster data collection.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * If the previous response was truncated, you receive this token. Use it in your next request to receive the next
     * set of results.
     * </p>
     * 
     * @return If the previous response was truncated, you receive this token. Use it in your next request to receive
     *         the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * RasterDataCollectionQuery consisting of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_AreaOfInterest.html"
     * >AreaOfInterest(AOI)</a>, <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_PropertyFilter.html"
     * >PropertyFilters</a> and <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_TimeRangeFilterInput.html"
     * >TimeRangeFilterInput</a> used in <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_SearchRasterDataCollection.html"
     * >SearchRasterDataCollection</a>.
     * </p>
     * 
     * @return RasterDataCollectionQuery consisting of <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_AreaOfInterest.html"
     *         >AreaOfInterest(AOI)</a>, <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_PropertyFilter.html"
     *         >PropertyFilters</a> and <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_TimeRangeFilterInput.html"
     *         >TimeRangeFilterInput</a> used in <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_SearchRasterDataCollection.html"
     *         >SearchRasterDataCollection</a>.
     */
    public final RasterDataCollectionQueryWithBandFilterInput rasterDataCollectionQuery() {
        return rasterDataCollectionQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(rasterDataCollectionQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRasterDataCollectionRequest)) {
            return false;
        }
        SearchRasterDataCollectionRequest other = (SearchRasterDataCollectionRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(rasterDataCollectionQuery(), other.rasterDataCollectionQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchRasterDataCollectionRequest").add("Arn", arn())
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RasterDataCollectionQuery", rasterDataCollectionQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RasterDataCollectionQuery":
            return Optional.ofNullable(clazz.cast(rasterDataCollectionQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchRasterDataCollectionRequest, T> g) {
        return obj -> g.apply((SearchRasterDataCollectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerGeospatialRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchRasterDataCollectionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the raster data collection.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the raster data collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * If the previous response was truncated, you receive this token. Use it in your next request to receive the
         * next set of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was truncated, you receive this token. Use it in your next request to receive
         *        the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * RasterDataCollectionQuery consisting of <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_AreaOfInterest.html"
         * >AreaOfInterest(AOI)</a>, <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_PropertyFilter.html"
         * >PropertyFilters</a> and <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_TimeRangeFilterInput.html"
         * >TimeRangeFilterInput</a> used in <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_SearchRasterDataCollection.html"
         * >SearchRasterDataCollection</a>.
         * </p>
         * 
         * @param rasterDataCollectionQuery
         *        RasterDataCollectionQuery consisting of <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_AreaOfInterest.html"
         *        >AreaOfInterest(AOI)</a>, <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_PropertyFilter.html"
         *        >PropertyFilters</a> and <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_TimeRangeFilterInput.html"
         *        >TimeRangeFilterInput</a> used in <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_SearchRasterDataCollection.html"
         *        >SearchRasterDataCollection</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rasterDataCollectionQuery(RasterDataCollectionQueryWithBandFilterInput rasterDataCollectionQuery);

        /**
         * <p>
         * RasterDataCollectionQuery consisting of <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_AreaOfInterest.html"
         * >AreaOfInterest(AOI)</a>, <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_PropertyFilter.html"
         * >PropertyFilters</a> and <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_TimeRangeFilterInput.html"
         * >TimeRangeFilterInput</a> used in <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_SearchRasterDataCollection.html"
         * >SearchRasterDataCollection</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RasterDataCollectionQueryWithBandFilterInput.Builder} avoiding the need to create one manually via
         * {@link RasterDataCollectionQueryWithBandFilterInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RasterDataCollectionQueryWithBandFilterInput.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #rasterDataCollectionQuery(RasterDataCollectionQueryWithBandFilterInput)}.
         * 
         * @param rasterDataCollectionQuery
         *        a consumer that will call methods on {@link RasterDataCollectionQueryWithBandFilterInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rasterDataCollectionQuery(RasterDataCollectionQueryWithBandFilterInput)
         */
        default Builder rasterDataCollectionQuery(
                Consumer<RasterDataCollectionQueryWithBandFilterInput.Builder> rasterDataCollectionQuery) {
            return rasterDataCollectionQuery(RasterDataCollectionQueryWithBandFilterInput.builder()
                    .applyMutation(rasterDataCollectionQuery).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerGeospatialRequest.BuilderImpl implements Builder {
        private String arn;

        private String nextToken;

        private RasterDataCollectionQueryWithBandFilterInput rasterDataCollectionQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRasterDataCollectionRequest model) {
            super(model);
            arn(model.arn);
            nextToken(model.nextToken);
            rasterDataCollectionQuery(model.rasterDataCollectionQuery);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final RasterDataCollectionQueryWithBandFilterInput.Builder getRasterDataCollectionQuery() {
            return rasterDataCollectionQuery != null ? rasterDataCollectionQuery.toBuilder() : null;
        }

        public final void setRasterDataCollectionQuery(
                RasterDataCollectionQueryWithBandFilterInput.BuilderImpl rasterDataCollectionQuery) {
            this.rasterDataCollectionQuery = rasterDataCollectionQuery != null ? rasterDataCollectionQuery.build() : null;
        }

        @Override
        public final Builder rasterDataCollectionQuery(RasterDataCollectionQueryWithBandFilterInput rasterDataCollectionQuery) {
            this.rasterDataCollectionQuery = rasterDataCollectionQuery;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchRasterDataCollectionRequest build() {
            return new SearchRasterDataCollectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
