/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartEarthObservationJobResponse extends SageMakerGeospatialResponse implements
        ToCopyableBuilder<StartEarthObservationJobResponse.Builder, StartEarthObservationJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(StartEarthObservationJobResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(StartEarthObservationJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationInSeconds").getter(getter(StartEarthObservationJobResponse::durationInSeconds))
            .setter(setter(Builder::durationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(StartEarthObservationJobResponse::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<InputConfigOutput> INPUT_CONFIG_FIELD = SdkField
            .<InputConfigOutput> builder(MarshallingType.SDK_POJO).memberName("InputConfig")
            .getter(getter(StartEarthObservationJobResponse::inputConfig)).setter(setter(Builder::inputConfig))
            .constructor(InputConfigOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()).build();

    private static final SdkField<JobConfigInput> JOB_CONFIG_FIELD = SdkField.<JobConfigInput> builder(MarshallingType.SDK_POJO)
            .memberName("JobConfig").getter(getter(StartEarthObservationJobResponse::jobConfig))
            .setter(setter(Builder::jobConfig)).constructor(JobConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobConfig").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(StartEarthObservationJobResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(StartEarthObservationJobResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(StartEarthObservationJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(StartEarthObservationJobResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIME_FIELD, DURATION_IN_SECONDS_FIELD, EXECUTION_ROLE_ARN_FIELD, INPUT_CONFIG_FIELD, JOB_CONFIG_FIELD,
            KMS_KEY_ID_FIELD, NAME_FIELD, STATUS_FIELD, TAGS_FIELD));

    private final String arn;

    private final Instant creationTime;

    private final Integer durationInSeconds;

    private final String executionRoleArn;

    private final InputConfigOutput inputConfig;

    private final JobConfigInput jobConfig;

    private final String kmsKeyId;

    private final String name;

    private final String status;

    private final Map<String, String> tags;

    private StartEarthObservationJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.durationInSeconds = builder.durationInSeconds;
        this.executionRoleArn = builder.executionRoleArn;
        this.inputConfig = builder.inputConfig;
        this.jobConfig = builder.jobConfig;
        this.kmsKeyId = builder.kmsKeyId;
        this.name = builder.name;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Earth Observation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Earth Observation job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The duration of the session, in seconds.
     * </p>
     * 
     * @return The duration of the session, in seconds.
     */
    public final Integer durationInSeconds() {
        return durationInSeconds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * Input configuration information for the Earth Observation job.
     * </p>
     * 
     * @return Input configuration information for the Earth Observation job.
     */
    public final InputConfigOutput inputConfig() {
        return inputConfig;
    }

    /**
     * <p>
     * An object containing information about the job configuration.
     * </p>
     * 
     * @return An object containing information about the job configuration.
     */
    public final JobConfigInput jobConfig() {
        return jobConfig;
    }

    /**
     * <p>
     * The Key Management Service key ID for server-side encryption.
     * </p>
     * 
     * @return The Key Management Service key ID for server-side encryption.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The name of the Earth Observation job.
     * </p>
     * 
     * @return The name of the Earth Observation job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the Earth Observation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EarthObservationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Earth Observation job.
     * @see EarthObservationJobStatus
     */
    public final EarthObservationJobStatus status() {
        return EarthObservationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Earth Observation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EarthObservationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Earth Observation job.
     * @see EarthObservationJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Each tag consists of a key and a value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Each tag consists of a key and a value.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartEarthObservationJobResponse)) {
            return false;
        }
        StartEarthObservationJobResponse other = (StartEarthObservationJobResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(durationInSeconds(), other.durationInSeconds())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(inputConfig(), other.inputConfig()) && Objects.equals(jobConfig(), other.jobConfig())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartEarthObservationJobResponse").add("Arn", arn()).add("CreationTime", creationTime())
                .add("DurationInSeconds", durationInSeconds()).add("ExecutionRoleArn", executionRoleArn())
                .add("InputConfig", inputConfig()).add("JobConfig", jobConfig()).add("KmsKeyId", kmsKeyId()).add("Name", name())
                .add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "DurationInSeconds":
            return Optional.ofNullable(clazz.cast(durationInSeconds()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "InputConfig":
            return Optional.ofNullable(clazz.cast(inputConfig()));
        case "JobConfig":
            return Optional.ofNullable(clazz.cast(jobConfig()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartEarthObservationJobResponse, T> g) {
        return obj -> g.apply((StartEarthObservationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerGeospatialResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartEarthObservationJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Earth Observation job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Earth Observation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The duration of the session, in seconds.
         * </p>
         * 
         * @param durationInSeconds
         *        The duration of the session, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Integer durationInSeconds);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * Input configuration information for the Earth Observation job.
         * </p>
         * 
         * @param inputConfig
         *        Input configuration information for the Earth Observation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfig(InputConfigOutput inputConfig);

        /**
         * <p>
         * Input configuration information for the Earth Observation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputConfigOutput.Builder} avoiding the
         * need to create one manually via {@link InputConfigOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputConfigOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #inputConfig(InputConfigOutput)}.
         * 
         * @param inputConfig
         *        a consumer that will call methods on {@link InputConfigOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfig(InputConfigOutput)
         */
        default Builder inputConfig(Consumer<InputConfigOutput.Builder> inputConfig) {
            return inputConfig(InputConfigOutput.builder().applyMutation(inputConfig).build());
        }

        /**
         * <p>
         * An object containing information about the job configuration.
         * </p>
         * 
         * @param jobConfig
         *        An object containing information about the job configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobConfig(JobConfigInput jobConfig);

        /**
         * <p>
         * An object containing information about the job configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobConfigInput.Builder} avoiding the need
         * to create one manually via {@link JobConfigInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobConfigInput.Builder#build()} is called immediately and its
         * result is passed to {@link #jobConfig(JobConfigInput)}.
         * 
         * @param jobConfig
         *        a consumer that will call methods on {@link JobConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobConfig(JobConfigInput)
         */
        default Builder jobConfig(Consumer<JobConfigInput.Builder> jobConfig) {
            return jobConfig(JobConfigInput.builder().applyMutation(jobConfig).build());
        }

        /**
         * <p>
         * The Key Management Service key ID for server-side encryption.
         * </p>
         * 
         * @param kmsKeyId
         *        The Key Management Service key ID for server-side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The name of the Earth Observation job.
         * </p>
         * 
         * @param name
         *        The name of the Earth Observation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the Earth Observation job.
         * </p>
         * 
         * @param status
         *        The status of the Earth Observation job.
         * @see EarthObservationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EarthObservationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Earth Observation job.
         * </p>
         * 
         * @param status
         *        The status of the Earth Observation job.
         * @see EarthObservationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EarthObservationJobStatus
         */
        Builder status(EarthObservationJobStatus status);

        /**
         * <p>
         * Each tag consists of a key and a value.
         * </p>
         * 
         * @param tags
         *        Each tag consists of a key and a value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends SageMakerGeospatialResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant creationTime;

        private Integer durationInSeconds;

        private String executionRoleArn;

        private InputConfigOutput inputConfig;

        private JobConfigInput jobConfig;

        private String kmsKeyId;

        private String name;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartEarthObservationJobResponse model) {
            super(model);
            arn(model.arn);
            creationTime(model.creationTime);
            durationInSeconds(model.durationInSeconds);
            executionRoleArn(model.executionRoleArn);
            inputConfig(model.inputConfig);
            jobConfig(model.jobConfig);
            kmsKeyId(model.kmsKeyId);
            name(model.name);
            status(model.status);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Integer getDurationInSeconds() {
            return durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final InputConfigOutput.Builder getInputConfig() {
            return inputConfig != null ? inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(InputConfigOutput.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(InputConfigOutput inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final JobConfigInput.Builder getJobConfig() {
            return jobConfig != null ? jobConfig.toBuilder() : null;
        }

        public final void setJobConfig(JobConfigInput.BuilderImpl jobConfig) {
            this.jobConfig = jobConfig != null ? jobConfig.build() : null;
        }

        @Override
        public final Builder jobConfig(JobConfigInput jobConfig) {
            this.jobConfig = jobConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EarthObservationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public StartEarthObservationJobResponse build() {
            return new StartEarthObservationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
