/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchSchemaSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchSchemaSummary.Builder, SearchSchemaSummary> {
    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchSchemaSummary::registryName)).setter(setter(Builder::registryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryName").build()).build();

    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchSchemaSummary::schemaArn)).setter(setter(Builder::schemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchSchemaSummary::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()).build();

    private static final SdkField<List<SearchSchemaVersionSummary>> SCHEMA_VERSIONS_FIELD = SdkField
            .<List<SearchSchemaVersionSummary>> builder(MarshallingType.LIST)
            .getter(getter(SearchSchemaSummary::schemaVersions))
            .setter(setter(Builder::schemaVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchSchemaVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchSchemaVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_NAME_FIELD,
            SCHEMA_ARN_FIELD, SCHEMA_NAME_FIELD, SCHEMA_VERSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String registryName;

    private final String schemaArn;

    private final String schemaName;

    private final List<SearchSchemaVersionSummary> schemaVersions;

    private SearchSchemaSummary(BuilderImpl builder) {
        this.registryName = builder.registryName;
        this.schemaArn = builder.schemaArn;
        this.schemaName = builder.schemaName;
        this.schemaVersions = builder.schemaVersions;
    }

    /**
     * <p>
     * The name of the registry.
     * </p>
     * 
     * @return The name of the registry.
     */
    public String registryName() {
        return registryName;
    }

    /**
     * <p>
     * The ARN of the schema.
     * </p>
     * 
     * @return The ARN of the schema.
     */
    public String schemaArn() {
        return schemaArn;
    }

    /**
     * <p>
     * The name of the schema.
     * </p>
     * 
     * @return The name of the schema.
     */
    public String schemaName() {
        return schemaName;
    }

    /**
     * Returns true if the SchemaVersions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSchemaVersions() {
        return schemaVersions != null && !(schemaVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of schema version summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSchemaVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of schema version summaries.
     */
    public List<SearchSchemaVersionSummary> schemaVersions() {
        return schemaVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(registryName());
        hashCode = 31 * hashCode + Objects.hashCode(schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSchemaSummary)) {
            return false;
        }
        SearchSchemaSummary other = (SearchSchemaSummary) obj;
        return Objects.equals(registryName(), other.registryName()) && Objects.equals(schemaArn(), other.schemaArn())
                && Objects.equals(schemaName(), other.schemaName()) && Objects.equals(schemaVersions(), other.schemaVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchSchemaSummary").add("RegistryName", registryName()).add("SchemaArn", schemaArn())
                .add("SchemaName", schemaName()).add("SchemaVersions", schemaVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistryName":
            return Optional.ofNullable(clazz.cast(registryName()));
        case "SchemaArn":
            return Optional.ofNullable(clazz.cast(schemaArn()));
        case "SchemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "SchemaVersions":
            return Optional.ofNullable(clazz.cast(schemaVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchSchemaSummary, T> g) {
        return obj -> g.apply((SearchSchemaSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchSchemaSummary> {
        /**
         * <p>
         * The name of the registry.
         * </p>
         * 
         * @param registryName
         *        The name of the registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryName(String registryName);

        /**
         * <p>
         * The ARN of the schema.
         * </p>
         * 
         * @param schemaArn
         *        The ARN of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArn(String schemaArn);

        /**
         * <p>
         * The name of the schema.
         * </p>
         * 
         * @param schemaName
         *        The name of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * An array of schema version summaries.
         * </p>
         * 
         * @param schemaVersions
         *        An array of schema version summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersions(Collection<SearchSchemaVersionSummary> schemaVersions);

        /**
         * <p>
         * An array of schema version summaries.
         * </p>
         * 
         * @param schemaVersions
         *        An array of schema version summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersions(SearchSchemaVersionSummary... schemaVersions);

        /**
         * <p>
         * An array of schema version summaries.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SearchSchemaVersionSummary>.Builder}
         * avoiding the need to create one manually via {@link List<SearchSchemaVersionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SearchSchemaVersionSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #schemaVersions(List<SearchSchemaVersionSummary>)}.
         * 
         * @param schemaVersions
         *        a consumer that will call methods on {@link List<SearchSchemaVersionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaVersions(List<SearchSchemaVersionSummary>)
         */
        Builder schemaVersions(Consumer<SearchSchemaVersionSummary.Builder>... schemaVersions);
    }

    static final class BuilderImpl implements Builder {
        private String registryName;

        private String schemaArn;

        private String schemaName;

        private List<SearchSchemaVersionSummary> schemaVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSchemaSummary model) {
            registryName(model.registryName);
            schemaArn(model.schemaArn);
            schemaName(model.schemaName);
            schemaVersions(model.schemaVersions);
        }

        public final String getRegistryName() {
            return registryName;
        }

        @Override
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        public final String getSchemaArn() {
            return schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public final Collection<SearchSchemaVersionSummary.Builder> getSchemaVersions() {
            return schemaVersions != null ? schemaVersions.stream().map(SearchSchemaVersionSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schemaVersions(Collection<SearchSchemaVersionSummary> schemaVersions) {
            this.schemaVersions = ___listOfSearchSchemaVersionSummaryCopier.copy(schemaVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaVersions(SearchSchemaVersionSummary... schemaVersions) {
            schemaVersions(Arrays.asList(schemaVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaVersions(Consumer<SearchSchemaVersionSummary.Builder>... schemaVersions) {
            schemaVersions(Stream.of(schemaVersions).map(c -> SearchSchemaVersionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSchemaVersions(Collection<SearchSchemaVersionSummary.BuilderImpl> schemaVersions) {
            this.schemaVersions = ___listOfSearchSchemaVersionSummaryCopier.copyFromBuilder(schemaVersions);
        }

        @Override
        public SearchSchemaSummary build() {
            return new SearchSchemaSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
