/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchSchemasResponse extends SchemasResponse implements
        ToCopyableBuilder<SearchSchemasResponse.Builder, SearchSchemasResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchSchemasResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<SearchSchemaSummary>> SCHEMAS_FIELD = SdkField
            .<List<SearchSchemaSummary>> builder(MarshallingType.LIST)
            .getter(getter(SearchSchemasResponse::schemas))
            .setter(setter(Builder::schemas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schemas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchSchemaSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchSchemaSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SCHEMAS_FIELD));

    private final String nextToken;

    private final List<SearchSchemaSummary> schemas;

    private SearchSchemasResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.schemas = builder.schemas;
    }

    /**
     * <p>
     * The token that specifies the next page of results to return. To request the first page, leave NextToken empty.
     * The token will expire in 24 hours, and cannot be shared with other accounts.
     * </p>
     * 
     * @return The token that specifies the next page of results to return. To request the first page, leave NextToken
     *         empty. The token will expire in 24 hours, and cannot be shared with other accounts.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Schemas property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSchemas() {
        return schemas != null && !(schemas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of SearchSchemaSummary information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSchemas()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of SearchSchemaSummary information.
     */
    public List<SearchSchemaSummary> schemas() {
        return schemas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(schemas());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSchemasResponse)) {
            return false;
        }
        SearchSchemasResponse other = (SearchSchemasResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(schemas(), other.schemas());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchSchemasResponse").add("NextToken", nextToken()).add("Schemas", schemas()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Schemas":
            return Optional.ofNullable(clazz.cast(schemas()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchSchemasResponse, T> g) {
        return obj -> g.apply((SearchSchemasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchemasResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchSchemasResponse> {
        /**
         * <p>
         * The token that specifies the next page of results to return. To request the first page, leave NextToken
         * empty. The token will expire in 24 hours, and cannot be shared with other accounts.
         * </p>
         * 
         * @param nextToken
         *        The token that specifies the next page of results to return. To request the first page, leave
         *        NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of SearchSchemaSummary information.
         * </p>
         * 
         * @param schemas
         *        An array of SearchSchemaSummary information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemas(Collection<SearchSchemaSummary> schemas);

        /**
         * <p>
         * An array of SearchSchemaSummary information.
         * </p>
         * 
         * @param schemas
         *        An array of SearchSchemaSummary information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemas(SearchSchemaSummary... schemas);

        /**
         * <p>
         * An array of SearchSchemaSummary information.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SearchSchemaSummary>.Builder} avoiding the
         * need to create one manually via {@link List<SearchSchemaSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SearchSchemaSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #schemas(List<SearchSchemaSummary>)}.
         * 
         * @param schemas
         *        a consumer that will call methods on {@link List<SearchSchemaSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemas(List<SearchSchemaSummary>)
         */
        Builder schemas(Consumer<SearchSchemaSummary.Builder>... schemas);
    }

    static final class BuilderImpl extends SchemasResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<SearchSchemaSummary> schemas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSchemasResponse model) {
            super(model);
            nextToken(model.nextToken);
            schemas(model.schemas);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<SearchSchemaSummary.Builder> getSchemas() {
            return schemas != null ? schemas.stream().map(SearchSchemaSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schemas(Collection<SearchSchemaSummary> schemas) {
            this.schemas = ___listOfSearchSchemaSummaryCopier.copy(schemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(SearchSchemaSummary... schemas) {
            schemas(Arrays.asList(schemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(Consumer<SearchSchemaSummary.Builder>... schemas) {
            schemas(Stream.of(schemas).map(c -> SearchSchemaSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSchemas(Collection<SearchSchemaSummary.BuilderImpl> schemas) {
            this.schemas = ___listOfSearchSchemaSummaryCopier.copyFromBuilder(schemas);
        }

        @Override
        public SearchSchemasResponse build() {
            return new SearchSchemasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
