/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a constraint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConstraintDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ConstraintDetail.Builder, ConstraintDetail> {
    private static final SdkField<String> CONSTRAINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConstraintDetail::constraintId)).setter(setter(Builder::constraintId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstraintId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConstraintDetail::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConstraintDetail::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConstraintDetail::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTRAINT_ID_FIELD,
            TYPE_FIELD, DESCRIPTION_FIELD, OWNER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String constraintId;

    private final String type;

    private final String description;

    private final String owner;

    private ConstraintDetail(BuilderImpl builder) {
        this.constraintId = builder.constraintId;
        this.type = builder.type;
        this.description = builder.description;
        this.owner = builder.owner;
    }

    /**
     * <p>
     * The identifier of the constraint.
     * </p>
     * 
     * @return The identifier of the constraint.
     */
    public String constraintId() {
        return constraintId;
    }

    /**
     * <p>
     * The type of constraint.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LAUNCH</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOTIFICATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * STACKSET
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TEMPLATE</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of constraint.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LAUNCH</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOTIFICATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STACKSET
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TEMPLATE</code>
     *         </p>
     *         </li>
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The description of the constraint.
     * </p>
     * 
     * @return The description of the constraint.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The owner of the constraint.
     * </p>
     * 
     * @return The owner of the constraint.
     */
    public String owner() {
        return owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(constraintId());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConstraintDetail)) {
            return false;
        }
        ConstraintDetail other = (ConstraintDetail) obj;
        return Objects.equals(constraintId(), other.constraintId()) && Objects.equals(type(), other.type())
                && Objects.equals(description(), other.description()) && Objects.equals(owner(), other.owner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConstraintDetail").add("ConstraintId", constraintId()).add("Type", type())
                .add("Description", description()).add("Owner", owner()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConstraintId":
            return Optional.ofNullable(clazz.cast(constraintId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConstraintDetail, T> g) {
        return obj -> g.apply((ConstraintDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConstraintDetail> {
        /**
         * <p>
         * The identifier of the constraint.
         * </p>
         * 
         * @param constraintId
         *        The identifier of the constraint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraintId(String constraintId);

        /**
         * <p>
         * The type of constraint.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LAUNCH</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOTIFICATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * STACKSET
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TEMPLATE</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of constraint.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LAUNCH</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOTIFICATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STACKSET
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TEMPLATE</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The description of the constraint.
         * </p>
         * 
         * @param description
         *        The description of the constraint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The owner of the constraint.
         * </p>
         * 
         * @param owner
         *        The owner of the constraint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);
    }

    static final class BuilderImpl implements Builder {
        private String constraintId;

        private String type;

        private String description;

        private String owner;

        private BuilderImpl() {
        }

        private BuilderImpl(ConstraintDetail model) {
            constraintId(model.constraintId);
            type(model.type);
            description(model.description);
            owner(model.owner);
        }

        public final String getConstraintId() {
            return constraintId;
        }

        @Override
        public final Builder constraintId(String constraintId) {
            this.constraintId = constraintId;
            return this;
        }

        public final void setConstraintId(String constraintId) {
            this.constraintId = constraintId;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public ConstraintDetail build() {
            return new ConstraintDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
