/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePortfolioShareStatusResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<DescribePortfolioShareStatusResponse.Builder, DescribePortfolioShareStatusResponse> {
    private static final SdkField<String> PORTFOLIO_SHARE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribePortfolioShareStatusResponse::portfolioShareToken))
            .setter(setter(Builder::portfolioShareToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioShareToken").build())
            .build();

    private static final SdkField<String> PORTFOLIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribePortfolioShareStatusResponse::portfolioId)).setter(setter(Builder::portfolioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioId").build()).build();

    private static final SdkField<String> ORGANIZATION_NODE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribePortfolioShareStatusResponse::organizationNodeValue))
            .setter(setter(Builder::organizationNodeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationNodeValue").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribePortfolioShareStatusResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<ShareDetails> SHARE_DETAILS_FIELD = SdkField.<ShareDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribePortfolioShareStatusResponse::shareDetails)).setter(setter(Builder::shareDetails))
            .constructor(ShareDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTFOLIO_SHARE_TOKEN_FIELD,
            PORTFOLIO_ID_FIELD, ORGANIZATION_NODE_VALUE_FIELD, STATUS_FIELD, SHARE_DETAILS_FIELD));

    private final String portfolioShareToken;

    private final String portfolioId;

    private final String organizationNodeValue;

    private final String status;

    private final ShareDetails shareDetails;

    private DescribePortfolioShareStatusResponse(BuilderImpl builder) {
        super(builder);
        this.portfolioShareToken = builder.portfolioShareToken;
        this.portfolioId = builder.portfolioId;
        this.organizationNodeValue = builder.organizationNodeValue;
        this.status = builder.status;
        this.shareDetails = builder.shareDetails;
    }

    /**
     * <p>
     * The token for the portfolio share operation. For example, <code>share-6v24abcdefghi</code>.
     * </p>
     * 
     * @return The token for the portfolio share operation. For example, <code>share-6v24abcdefghi</code>.
     */
    public String portfolioShareToken() {
        return portfolioShareToken;
    }

    /**
     * <p>
     * The portfolio identifier.
     * </p>
     * 
     * @return The portfolio identifier.
     */
    public String portfolioId() {
        return portfolioId;
    }

    /**
     * <p>
     * Organization node identifier. It can be either account id, organizational unit id or organization id.
     * </p>
     * 
     * @return Organization node identifier. It can be either account id, organizational unit id or organization id.
     */
    public String organizationNodeValue() {
        return organizationNodeValue;
    }

    /**
     * <p>
     * Status of the portfolio share operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the portfolio share operation.
     * @see ShareStatus
     */
    public ShareStatus status() {
        return ShareStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the portfolio share operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the portfolio share operation.
     * @see ShareStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Information about the portfolio share operation.
     * </p>
     * 
     * @return Information about the portfolio share operation.
     */
    public ShareDetails shareDetails() {
        return shareDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(portfolioShareToken());
        hashCode = 31 * hashCode + Objects.hashCode(portfolioId());
        hashCode = 31 * hashCode + Objects.hashCode(organizationNodeValue());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shareDetails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePortfolioShareStatusResponse)) {
            return false;
        }
        DescribePortfolioShareStatusResponse other = (DescribePortfolioShareStatusResponse) obj;
        return Objects.equals(portfolioShareToken(), other.portfolioShareToken())
                && Objects.equals(portfolioId(), other.portfolioId())
                && Objects.equals(organizationNodeValue(), other.organizationNodeValue())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(shareDetails(), other.shareDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribePortfolioShareStatusResponse").add("PortfolioShareToken", portfolioShareToken())
                .add("PortfolioId", portfolioId()).add("OrganizationNodeValue", organizationNodeValue())
                .add("Status", statusAsString()).add("ShareDetails", shareDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PortfolioShareToken":
            return Optional.ofNullable(clazz.cast(portfolioShareToken()));
        case "PortfolioId":
            return Optional.ofNullable(clazz.cast(portfolioId()));
        case "OrganizationNodeValue":
            return Optional.ofNullable(clazz.cast(organizationNodeValue()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ShareDetails":
            return Optional.ofNullable(clazz.cast(shareDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePortfolioShareStatusResponse, T> g) {
        return obj -> g.apply((DescribePortfolioShareStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePortfolioShareStatusResponse> {
        /**
         * <p>
         * The token for the portfolio share operation. For example, <code>share-6v24abcdefghi</code>.
         * </p>
         * 
         * @param portfolioShareToken
         *        The token for the portfolio share operation. For example, <code>share-6v24abcdefghi</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioShareToken(String portfolioShareToken);

        /**
         * <p>
         * The portfolio identifier.
         * </p>
         * 
         * @param portfolioId
         *        The portfolio identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioId(String portfolioId);

        /**
         * <p>
         * Organization node identifier. It can be either account id, organizational unit id or organization id.
         * </p>
         * 
         * @param organizationNodeValue
         *        Organization node identifier. It can be either account id, organizational unit id or organization id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationNodeValue(String organizationNodeValue);

        /**
         * <p>
         * Status of the portfolio share operation.
         * </p>
         * 
         * @param status
         *        Status of the portfolio share operation.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the portfolio share operation.
         * </p>
         * 
         * @param status
         *        Status of the portfolio share operation.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder status(ShareStatus status);

        /**
         * <p>
         * Information about the portfolio share operation.
         * </p>
         * 
         * @param shareDetails
         *        Information about the portfolio share operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareDetails(ShareDetails shareDetails);

        /**
         * <p>
         * Information about the portfolio share operation.
         * </p>
         * This is a convenience that creates an instance of the {@link ShareDetails.Builder} avoiding the need to
         * create one manually via {@link ShareDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ShareDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #shareDetails(ShareDetails)}.
         * 
         * @param shareDetails
         *        a consumer that will call methods on {@link ShareDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shareDetails(ShareDetails)
         */
        default Builder shareDetails(Consumer<ShareDetails.Builder> shareDetails) {
            return shareDetails(ShareDetails.builder().applyMutation(shareDetails).build());
        }
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private String portfolioShareToken;

        private String portfolioId;

        private String organizationNodeValue;

        private String status;

        private ShareDetails shareDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePortfolioShareStatusResponse model) {
            super(model);
            portfolioShareToken(model.portfolioShareToken);
            portfolioId(model.portfolioId);
            organizationNodeValue(model.organizationNodeValue);
            status(model.status);
            shareDetails(model.shareDetails);
        }

        public final String getPortfolioShareToken() {
            return portfolioShareToken;
        }

        @Override
        public final Builder portfolioShareToken(String portfolioShareToken) {
            this.portfolioShareToken = portfolioShareToken;
            return this;
        }

        public final void setPortfolioShareToken(String portfolioShareToken) {
            this.portfolioShareToken = portfolioShareToken;
        }

        public final String getPortfolioId() {
            return portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        public final String getOrganizationNodeValue() {
            return organizationNodeValue;
        }

        @Override
        public final Builder organizationNodeValue(String organizationNodeValue) {
            this.organizationNodeValue = organizationNodeValue;
            return this;
        }

        public final void setOrganizationNodeValue(String organizationNodeValue) {
            this.organizationNodeValue = organizationNodeValue;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final ShareDetails.Builder getShareDetails() {
            return shareDetails != null ? shareDetails.toBuilder() : null;
        }

        @Override
        public final Builder shareDetails(ShareDetails shareDetails) {
            this.shareDetails = shareDetails;
            return this;
        }

        public final void setShareDetails(ShareDetails.BuilderImpl shareDetails) {
            this.shareDetails = shareDetails != null ? shareDetails.build() : null;
        }

        @Override
        public DescribePortfolioShareStatusResponse build() {
            return new DescribePortfolioShareStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
