/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProvisioningParametersResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<DescribeProvisioningParametersResponse.Builder, DescribeProvisioningParametersResponse> {
    private static final SdkField<List<ProvisioningArtifactParameter>> PROVISIONING_ARTIFACT_PARAMETERS_FIELD = SdkField
            .<List<ProvisioningArtifactParameter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeProvisioningParametersResponse::provisioningArtifactParameters))
            .setter(setter(Builder::provisioningArtifactParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactParameters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisioningArtifactParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisioningArtifactParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ConstraintSummary>> CONSTRAINT_SUMMARIES_FIELD = SdkField
            .<List<ConstraintSummary>> builder(MarshallingType.LIST)
            .getter(getter(DescribeProvisioningParametersResponse::constraintSummaries))
            .setter(setter(Builder::constraintSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstraintSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConstraintSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConstraintSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UsageInstruction>> USAGE_INSTRUCTIONS_FIELD = SdkField
            .<List<UsageInstruction>> builder(MarshallingType.LIST)
            .getter(getter(DescribeProvisioningParametersResponse::usageInstructions))
            .setter(setter(Builder::usageInstructions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageInstructions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageInstruction> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageInstruction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TagOptionSummary>> TAG_OPTIONS_FIELD = SdkField
            .<List<TagOptionSummary>> builder(MarshallingType.LIST)
            .getter(getter(DescribeProvisioningParametersResponse::tagOptions))
            .setter(setter(Builder::tagOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagOptionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagOptionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProvisioningArtifactPreferences> PROVISIONING_ARTIFACT_PREFERENCES_FIELD = SdkField
            .<ProvisioningArtifactPreferences> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeProvisioningParametersResponse::provisioningArtifactPreferences))
            .setter(setter(Builder::provisioningArtifactPreferences))
            .constructor(ProvisioningArtifactPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactPreferences")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROVISIONING_ARTIFACT_PARAMETERS_FIELD, CONSTRAINT_SUMMARIES_FIELD, USAGE_INSTRUCTIONS_FIELD, TAG_OPTIONS_FIELD,
            PROVISIONING_ARTIFACT_PREFERENCES_FIELD));

    private final List<ProvisioningArtifactParameter> provisioningArtifactParameters;

    private final List<ConstraintSummary> constraintSummaries;

    private final List<UsageInstruction> usageInstructions;

    private final List<TagOptionSummary> tagOptions;

    private final ProvisioningArtifactPreferences provisioningArtifactPreferences;

    private DescribeProvisioningParametersResponse(BuilderImpl builder) {
        super(builder);
        this.provisioningArtifactParameters = builder.provisioningArtifactParameters;
        this.constraintSummaries = builder.constraintSummaries;
        this.usageInstructions = builder.usageInstructions;
        this.tagOptions = builder.tagOptions;
        this.provisioningArtifactPreferences = builder.provisioningArtifactPreferences;
    }

    /**
     * Returns true if the ProvisioningArtifactParameters property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasProvisioningArtifactParameters() {
        return provisioningArtifactParameters != null && !(provisioningArtifactParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the parameters used to provision the product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProvisioningArtifactParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the parameters used to provision the product.
     */
    public List<ProvisioningArtifactParameter> provisioningArtifactParameters() {
        return provisioningArtifactParameters;
    }

    /**
     * Returns true if the ConstraintSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasConstraintSummaries() {
        return constraintSummaries != null && !(constraintSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the constraints used to provision the product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConstraintSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the constraints used to provision the product.
     */
    public List<ConstraintSummary> constraintSummaries() {
        return constraintSummaries;
    }

    /**
     * Returns true if the UsageInstructions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasUsageInstructions() {
        return usageInstructions != null && !(usageInstructions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any additional metadata specifically related to the provisioning of the product. For example, see the
     * <code>Version</code> field of the CloudFormation template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUsageInstructions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any additional metadata specifically related to the provisioning of the product. For example, see the
     *         <code>Version</code> field of the CloudFormation template.
     */
    public List<UsageInstruction> usageInstructions() {
        return usageInstructions;
    }

    /**
     * Returns true if the TagOptions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTagOptions() {
        return tagOptions != null && !(tagOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the TagOptions associated with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the TagOptions associated with the resource.
     */
    public List<TagOptionSummary> tagOptions() {
        return tagOptions;
    }

    /**
     * <p>
     * An object that contains information about preferences, such as regions and accounts, for the provisioning
     * artifact.
     * </p>
     * 
     * @return An object that contains information about preferences, such as regions and accounts, for the provisioning
     *         artifact.
     */
    public ProvisioningArtifactPreferences provisioningArtifactPreferences() {
        return provisioningArtifactPreferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactParameters());
        hashCode = 31 * hashCode + Objects.hashCode(constraintSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(usageInstructions());
        hashCode = 31 * hashCode + Objects.hashCode(tagOptions());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactPreferences());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProvisioningParametersResponse)) {
            return false;
        }
        DescribeProvisioningParametersResponse other = (DescribeProvisioningParametersResponse) obj;
        return Objects.equals(provisioningArtifactParameters(), other.provisioningArtifactParameters())
                && Objects.equals(constraintSummaries(), other.constraintSummaries())
                && Objects.equals(usageInstructions(), other.usageInstructions())
                && Objects.equals(tagOptions(), other.tagOptions())
                && Objects.equals(provisioningArtifactPreferences(), other.provisioningArtifactPreferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeProvisioningParametersResponse")
                .add("ProvisioningArtifactParameters", provisioningArtifactParameters())
                .add("ConstraintSummaries", constraintSummaries()).add("UsageInstructions", usageInstructions())
                .add("TagOptions", tagOptions()).add("ProvisioningArtifactPreferences", provisioningArtifactPreferences())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisioningArtifactParameters":
            return Optional.ofNullable(clazz.cast(provisioningArtifactParameters()));
        case "ConstraintSummaries":
            return Optional.ofNullable(clazz.cast(constraintSummaries()));
        case "UsageInstructions":
            return Optional.ofNullable(clazz.cast(usageInstructions()));
        case "TagOptions":
            return Optional.ofNullable(clazz.cast(tagOptions()));
        case "ProvisioningArtifactPreferences":
            return Optional.ofNullable(clazz.cast(provisioningArtifactPreferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProvisioningParametersResponse, T> g) {
        return obj -> g.apply((DescribeProvisioningParametersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeProvisioningParametersResponse> {
        /**
         * <p>
         * Information about the parameters used to provision the product.
         * </p>
         * 
         * @param provisioningArtifactParameters
         *        Information about the parameters used to provision the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactParameters(Collection<ProvisioningArtifactParameter> provisioningArtifactParameters);

        /**
         * <p>
         * Information about the parameters used to provision the product.
         * </p>
         * 
         * @param provisioningArtifactParameters
         *        Information about the parameters used to provision the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactParameters(ProvisioningArtifactParameter... provisioningArtifactParameters);

        /**
         * <p>
         * Information about the parameters used to provision the product.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProvisioningArtifactParameter>.Builder}
         * avoiding the need to create one manually via {@link List<ProvisioningArtifactParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProvisioningArtifactParameter>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #provisioningArtifactParameters(List<ProvisioningArtifactParameter>)}.
         * 
         * @param provisioningArtifactParameters
         *        a consumer that will call methods on {@link List<ProvisioningArtifactParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningArtifactParameters(List<ProvisioningArtifactParameter>)
         */
        Builder provisioningArtifactParameters(Consumer<ProvisioningArtifactParameter.Builder>... provisioningArtifactParameters);

        /**
         * <p>
         * Information about the constraints used to provision the product.
         * </p>
         * 
         * @param constraintSummaries
         *        Information about the constraints used to provision the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraintSummaries(Collection<ConstraintSummary> constraintSummaries);

        /**
         * <p>
         * Information about the constraints used to provision the product.
         * </p>
         * 
         * @param constraintSummaries
         *        Information about the constraints used to provision the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraintSummaries(ConstraintSummary... constraintSummaries);

        /**
         * <p>
         * Information about the constraints used to provision the product.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConstraintSummary>.Builder} avoiding the
         * need to create one manually via {@link List<ConstraintSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConstraintSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #constraintSummaries(List<ConstraintSummary>)}.
         * 
         * @param constraintSummaries
         *        a consumer that will call methods on {@link List<ConstraintSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constraintSummaries(List<ConstraintSummary>)
         */
        Builder constraintSummaries(Consumer<ConstraintSummary.Builder>... constraintSummaries);

        /**
         * <p>
         * Any additional metadata specifically related to the provisioning of the product. For example, see the
         * <code>Version</code> field of the CloudFormation template.
         * </p>
         * 
         * @param usageInstructions
         *        Any additional metadata specifically related to the provisioning of the product. For example, see the
         *        <code>Version</code> field of the CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageInstructions(Collection<UsageInstruction> usageInstructions);

        /**
         * <p>
         * Any additional metadata specifically related to the provisioning of the product. For example, see the
         * <code>Version</code> field of the CloudFormation template.
         * </p>
         * 
         * @param usageInstructions
         *        Any additional metadata specifically related to the provisioning of the product. For example, see the
         *        <code>Version</code> field of the CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageInstructions(UsageInstruction... usageInstructions);

        /**
         * <p>
         * Any additional metadata specifically related to the provisioning of the product. For example, see the
         * <code>Version</code> field of the CloudFormation template.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UsageInstruction>.Builder} avoiding the
         * need to create one manually via {@link List<UsageInstruction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UsageInstruction>.Builder#build()} is called immediately and
         * its result is passed to {@link #usageInstructions(List<UsageInstruction>)}.
         * 
         * @param usageInstructions
         *        a consumer that will call methods on {@link List<UsageInstruction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageInstructions(List<UsageInstruction>)
         */
        Builder usageInstructions(Consumer<UsageInstruction.Builder>... usageInstructions);

        /**
         * <p>
         * Information about the TagOptions associated with the resource.
         * </p>
         * 
         * @param tagOptions
         *        Information about the TagOptions associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagOptions(Collection<TagOptionSummary> tagOptions);

        /**
         * <p>
         * Information about the TagOptions associated with the resource.
         * </p>
         * 
         * @param tagOptions
         *        Information about the TagOptions associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagOptions(TagOptionSummary... tagOptions);

        /**
         * <p>
         * Information about the TagOptions associated with the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagOptionSummary>.Builder} avoiding the
         * need to create one manually via {@link List<TagOptionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagOptionSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagOptions(List<TagOptionSummary>)}.
         * 
         * @param tagOptions
         *        a consumer that will call methods on {@link List<TagOptionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagOptions(List<TagOptionSummary>)
         */
        Builder tagOptions(Consumer<TagOptionSummary.Builder>... tagOptions);

        /**
         * <p>
         * An object that contains information about preferences, such as regions and accounts, for the provisioning
         * artifact.
         * </p>
         * 
         * @param provisioningArtifactPreferences
         *        An object that contains information about preferences, such as regions and accounts, for the
         *        provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactPreferences(ProvisioningArtifactPreferences provisioningArtifactPreferences);

        /**
         * <p>
         * An object that contains information about preferences, such as regions and accounts, for the provisioning
         * artifact.
         * </p>
         * This is a convenience that creates an instance of the {@link ProvisioningArtifactPreferences.Builder}
         * avoiding the need to create one manually via {@link ProvisioningArtifactPreferences#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisioningArtifactPreferences.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #provisioningArtifactPreferences(ProvisioningArtifactPreferences)}.
         * 
         * @param provisioningArtifactPreferences
         *        a consumer that will call methods on {@link ProvisioningArtifactPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningArtifactPreferences(ProvisioningArtifactPreferences)
         */
        default Builder provisioningArtifactPreferences(
                Consumer<ProvisioningArtifactPreferences.Builder> provisioningArtifactPreferences) {
            return provisioningArtifactPreferences(ProvisioningArtifactPreferences.builder()
                    .applyMutation(provisioningArtifactPreferences).build());
        }
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<ProvisioningArtifactParameter> provisioningArtifactParameters = DefaultSdkAutoConstructList.getInstance();

        private List<ConstraintSummary> constraintSummaries = DefaultSdkAutoConstructList.getInstance();

        private List<UsageInstruction> usageInstructions = DefaultSdkAutoConstructList.getInstance();

        private List<TagOptionSummary> tagOptions = DefaultSdkAutoConstructList.getInstance();

        private ProvisioningArtifactPreferences provisioningArtifactPreferences;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProvisioningParametersResponse model) {
            super(model);
            provisioningArtifactParameters(model.provisioningArtifactParameters);
            constraintSummaries(model.constraintSummaries);
            usageInstructions(model.usageInstructions);
            tagOptions(model.tagOptions);
            provisioningArtifactPreferences(model.provisioningArtifactPreferences);
        }

        public final Collection<ProvisioningArtifactParameter.Builder> getProvisioningArtifactParameters() {
            return provisioningArtifactParameters != null ? provisioningArtifactParameters.stream()
                    .map(ProvisioningArtifactParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningArtifactParameters(
                Collection<ProvisioningArtifactParameter> provisioningArtifactParameters) {
            this.provisioningArtifactParameters = ProvisioningArtifactParametersCopier.copy(provisioningArtifactParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactParameters(ProvisioningArtifactParameter... provisioningArtifactParameters) {
            provisioningArtifactParameters(Arrays.asList(provisioningArtifactParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactParameters(
                Consumer<ProvisioningArtifactParameter.Builder>... provisioningArtifactParameters) {
            provisioningArtifactParameters(Stream.of(provisioningArtifactParameters)
                    .map(c -> ProvisioningArtifactParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningArtifactParameters(
                Collection<ProvisioningArtifactParameter.BuilderImpl> provisioningArtifactParameters) {
            this.provisioningArtifactParameters = ProvisioningArtifactParametersCopier
                    .copyFromBuilder(provisioningArtifactParameters);
        }

        public final Collection<ConstraintSummary.Builder> getConstraintSummaries() {
            return constraintSummaries != null ? constraintSummaries.stream().map(ConstraintSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder constraintSummaries(Collection<ConstraintSummary> constraintSummaries) {
            this.constraintSummaries = ConstraintSummariesCopier.copy(constraintSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder constraintSummaries(ConstraintSummary... constraintSummaries) {
            constraintSummaries(Arrays.asList(constraintSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder constraintSummaries(Consumer<ConstraintSummary.Builder>... constraintSummaries) {
            constraintSummaries(Stream.of(constraintSummaries).map(c -> ConstraintSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConstraintSummaries(Collection<ConstraintSummary.BuilderImpl> constraintSummaries) {
            this.constraintSummaries = ConstraintSummariesCopier.copyFromBuilder(constraintSummaries);
        }

        public final Collection<UsageInstruction.Builder> getUsageInstructions() {
            return usageInstructions != null ? usageInstructions.stream().map(UsageInstruction::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder usageInstructions(Collection<UsageInstruction> usageInstructions) {
            this.usageInstructions = UsageInstructionsCopier.copy(usageInstructions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageInstructions(UsageInstruction... usageInstructions) {
            usageInstructions(Arrays.asList(usageInstructions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageInstructions(Consumer<UsageInstruction.Builder>... usageInstructions) {
            usageInstructions(Stream.of(usageInstructions).map(c -> UsageInstruction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUsageInstructions(Collection<UsageInstruction.BuilderImpl> usageInstructions) {
            this.usageInstructions = UsageInstructionsCopier.copyFromBuilder(usageInstructions);
        }

        public final Collection<TagOptionSummary.Builder> getTagOptions() {
            return tagOptions != null ? tagOptions.stream().map(TagOptionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagOptions(Collection<TagOptionSummary> tagOptions) {
            this.tagOptions = TagOptionSummariesCopier.copy(tagOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptions(TagOptionSummary... tagOptions) {
            tagOptions(Arrays.asList(tagOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptions(Consumer<TagOptionSummary.Builder>... tagOptions) {
            tagOptions(Stream.of(tagOptions).map(c -> TagOptionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagOptions(Collection<TagOptionSummary.BuilderImpl> tagOptions) {
            this.tagOptions = TagOptionSummariesCopier.copyFromBuilder(tagOptions);
        }

        public final ProvisioningArtifactPreferences.Builder getProvisioningArtifactPreferences() {
            return provisioningArtifactPreferences != null ? provisioningArtifactPreferences.toBuilder() : null;
        }

        @Override
        public final Builder provisioningArtifactPreferences(ProvisioningArtifactPreferences provisioningArtifactPreferences) {
            this.provisioningArtifactPreferences = provisioningArtifactPreferences;
            return this;
        }

        public final void setProvisioningArtifactPreferences(
                ProvisioningArtifactPreferences.BuilderImpl provisioningArtifactPreferences) {
            this.provisioningArtifactPreferences = provisioningArtifactPreferences != null ? provisioningArtifactPreferences
                    .build() : null;
        }

        @Override
        public DescribeProvisioningParametersResponse build() {
            return new DescribeProvisioningParametersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
