/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProvisionedProductPlansResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<ListProvisionedProductPlansResponse.Builder, ListProvisionedProductPlansResponse> {
    private static final SdkField<List<ProvisionedProductPlanSummary>> PROVISIONED_PRODUCT_PLANS_FIELD = SdkField
            .<List<ProvisionedProductPlanSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListProvisionedProductPlansResponse::provisionedProductPlans))
            .setter(setter(Builder::provisionedProductPlans))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductPlans").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisionedProductPlanSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisionedProductPlanSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListProvisionedProductPlansResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROVISIONED_PRODUCT_PLANS_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private final List<ProvisionedProductPlanSummary> provisionedProductPlans;

    private final String nextPageToken;

    private ListProvisionedProductPlansResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedProductPlans = builder.provisionedProductPlans;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the ProvisionedProductPlans property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProvisionedProductPlans() {
        return provisionedProductPlans != null && !(provisionedProductPlans instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the plans.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProvisionedProductPlans()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the plans.
     */
    public List<ProvisionedProductPlanSummary> provisionedProductPlans() {
        return provisionedProductPlans;
    }

    /**
     * <p>
     * The page token to use to retrieve the next set of results. If there are no additional results, this value is
     * null.
     * </p>
     * 
     * @return The page token to use to retrieve the next set of results. If there are no additional results, this value
     *         is null.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(provisionedProductPlans());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisionedProductPlansResponse)) {
            return false;
        }
        ListProvisionedProductPlansResponse other = (ListProvisionedProductPlansResponse) obj;
        return Objects.equals(provisionedProductPlans(), other.provisionedProductPlans())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListProvisionedProductPlansResponse").add("ProvisionedProductPlans", provisionedProductPlans())
                .add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisionedProductPlans":
            return Optional.ofNullable(clazz.cast(provisionedProductPlans()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProvisionedProductPlansResponse, T> g) {
        return obj -> g.apply((ListProvisionedProductPlansResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListProvisionedProductPlansResponse> {
        /**
         * <p>
         * Information about the plans.
         * </p>
         * 
         * @param provisionedProductPlans
         *        Information about the plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductPlans(Collection<ProvisionedProductPlanSummary> provisionedProductPlans);

        /**
         * <p>
         * Information about the plans.
         * </p>
         * 
         * @param provisionedProductPlans
         *        Information about the plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductPlans(ProvisionedProductPlanSummary... provisionedProductPlans);

        /**
         * <p>
         * Information about the plans.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProvisionedProductPlanSummary>.Builder}
         * avoiding the need to create one manually via {@link List<ProvisionedProductPlanSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProvisionedProductPlanSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #provisionedProductPlans(List<ProvisionedProductPlanSummary>)}
         * .
         * 
         * @param provisionedProductPlans
         *        a consumer that will call methods on {@link List<ProvisionedProductPlanSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedProductPlans(List<ProvisionedProductPlanSummary>)
         */
        Builder provisionedProductPlans(Consumer<ProvisionedProductPlanSummary.Builder>... provisionedProductPlans);

        /**
         * <p>
         * The page token to use to retrieve the next set of results. If there are no additional results, this value is
         * null.
         * </p>
         * 
         * @param nextPageToken
         *        The page token to use to retrieve the next set of results. If there are no additional results, this
         *        value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<ProvisionedProductPlanSummary> provisionedProductPlans = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisionedProductPlansResponse model) {
            super(model);
            provisionedProductPlans(model.provisionedProductPlans);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<ProvisionedProductPlanSummary.Builder> getProvisionedProductPlans() {
            return provisionedProductPlans != null ? provisionedProductPlans.stream()
                    .map(ProvisionedProductPlanSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisionedProductPlans(Collection<ProvisionedProductPlanSummary> provisionedProductPlans) {
            this.provisionedProductPlans = ProvisionedProductPlansCopier.copy(provisionedProductPlans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedProductPlans(ProvisionedProductPlanSummary... provisionedProductPlans) {
            provisionedProductPlans(Arrays.asList(provisionedProductPlans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedProductPlans(Consumer<ProvisionedProductPlanSummary.Builder>... provisionedProductPlans) {
            provisionedProductPlans(Stream.of(provisionedProductPlans)
                    .map(c -> ProvisionedProductPlanSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisionedProductPlans(Collection<ProvisionedProductPlanSummary.BuilderImpl> provisionedProductPlans) {
            this.provisionedProductPlans = ProvisionedProductPlansCopier.copyFromBuilder(provisionedProductPlans);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListProvisionedProductPlansResponse build() {
            return new ListProvisionedProductPlansResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
