/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The user-defined preferences that will be applied during product provisioning, unless overridden by
 * <code>ProvisioningPreferences</code> or <code>UpdateProvisioningPreferences</code>.
 * </p>
 * <p>
 * For more information on maximum concurrent accounts and failure tolerance, see <a
 * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options"
 * >Stack set operation options</a> in the <i>AWS CloudFormation User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisioningArtifactPreferences implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisioningArtifactPreferences.Builder, ProvisioningArtifactPreferences> {
    private static final SdkField<List<String>> STACK_SET_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ProvisioningArtifactPreferences::stackSetAccounts))
            .setter(setter(Builder::stackSetAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STACK_SET_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ProvisioningArtifactPreferences::stackSetRegions))
            .setter(setter(Builder::stackSetRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_ACCOUNTS_FIELD,
            STACK_SET_REGIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> stackSetAccounts;

    private final List<String> stackSetRegions;

    private ProvisioningArtifactPreferences(BuilderImpl builder) {
        this.stackSetAccounts = builder.stackSetAccounts;
        this.stackSetRegions = builder.stackSetRegions;
    }

    /**
     * Returns true if the StackSetAccounts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasStackSetAccounts() {
        return stackSetAccounts != null && !(stackSetAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more AWS accounts where stack instances are deployed from the stack set. These accounts can be scoped in
     * <code>ProvisioningPreferences$StackSetAccounts</code> and
     * <code>UpdateProvisioningPreferences$StackSetAccounts</code>.
     * </p>
     * <p>
     * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStackSetAccounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more AWS accounts where stack instances are deployed from the stack set. These accounts can be
     *         scoped in <code>ProvisioningPreferences$StackSetAccounts</code> and
     *         <code>UpdateProvisioningPreferences$StackSetAccounts</code>.</p>
     *         <p>
     *         Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     */
    public List<String> stackSetAccounts() {
        return stackSetAccounts;
    }

    /**
     * Returns true if the StackSetRegions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasStackSetRegions() {
        return stackSetRegions != null && !(stackSetRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more AWS Regions where stack instances are deployed from the stack set. These regions can be scoped in
     * <code>ProvisioningPreferences$StackSetRegions</code> and
     * <code>UpdateProvisioningPreferences$StackSetRegions</code>.
     * </p>
     * <p>
     * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStackSetRegions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more AWS Regions where stack instances are deployed from the stack set. These regions can be
     *         scoped in <code>ProvisioningPreferences$StackSetRegions</code> and
     *         <code>UpdateProvisioningPreferences$StackSetRegions</code>.</p>
     *         <p>
     *         Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     */
    public List<String> stackSetRegions() {
        return stackSetRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackSetAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(stackSetRegions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningArtifactPreferences)) {
            return false;
        }
        ProvisioningArtifactPreferences other = (ProvisioningArtifactPreferences) obj;
        return Objects.equals(stackSetAccounts(), other.stackSetAccounts())
                && Objects.equals(stackSetRegions(), other.stackSetRegions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProvisioningArtifactPreferences").add("StackSetAccounts", stackSetAccounts())
                .add("StackSetRegions", stackSetRegions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSetAccounts":
            return Optional.ofNullable(clazz.cast(stackSetAccounts()));
        case "StackSetRegions":
            return Optional.ofNullable(clazz.cast(stackSetRegions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisioningArtifactPreferences, T> g) {
        return obj -> g.apply((ProvisioningArtifactPreferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisioningArtifactPreferences> {
        /**
         * <p>
         * One or more AWS accounts where stack instances are deployed from the stack set. These accounts can be scoped
         * in <code>ProvisioningPreferences$StackSetAccounts</code> and
         * <code>UpdateProvisioningPreferences$StackSetAccounts</code>.
         * </p>
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * </p>
         * 
         * @param stackSetAccounts
         *        One or more AWS accounts where stack instances are deployed from the stack set. These accounts can be
         *        scoped in <code>ProvisioningPreferences$StackSetAccounts</code> and
         *        <code>UpdateProvisioningPreferences$StackSetAccounts</code>.</p>
         *        <p>
         *        Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetAccounts(Collection<String> stackSetAccounts);

        /**
         * <p>
         * One or more AWS accounts where stack instances are deployed from the stack set. These accounts can be scoped
         * in <code>ProvisioningPreferences$StackSetAccounts</code> and
         * <code>UpdateProvisioningPreferences$StackSetAccounts</code>.
         * </p>
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * </p>
         * 
         * @param stackSetAccounts
         *        One or more AWS accounts where stack instances are deployed from the stack set. These accounts can be
         *        scoped in <code>ProvisioningPreferences$StackSetAccounts</code> and
         *        <code>UpdateProvisioningPreferences$StackSetAccounts</code>.</p>
         *        <p>
         *        Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetAccounts(String... stackSetAccounts);

        /**
         * <p>
         * One or more AWS Regions where stack instances are deployed from the stack set. These regions can be scoped in
         * <code>ProvisioningPreferences$StackSetRegions</code> and
         * <code>UpdateProvisioningPreferences$StackSetRegions</code>.
         * </p>
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * </p>
         * 
         * @param stackSetRegions
         *        One or more AWS Regions where stack instances are deployed from the stack set. These regions can be
         *        scoped in <code>ProvisioningPreferences$StackSetRegions</code> and
         *        <code>UpdateProvisioningPreferences$StackSetRegions</code>.</p>
         *        <p>
         *        Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetRegions(Collection<String> stackSetRegions);

        /**
         * <p>
         * One or more AWS Regions where stack instances are deployed from the stack set. These regions can be scoped in
         * <code>ProvisioningPreferences$StackSetRegions</code> and
         * <code>UpdateProvisioningPreferences$StackSetRegions</code>.
         * </p>
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * </p>
         * 
         * @param stackSetRegions
         *        One or more AWS Regions where stack instances are deployed from the stack set. These regions can be
         *        scoped in <code>ProvisioningPreferences$StackSetRegions</code> and
         *        <code>UpdateProvisioningPreferences$StackSetRegions</code>.</p>
         *        <p>
         *        Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetRegions(String... stackSetRegions);
    }

    static final class BuilderImpl implements Builder {
        private List<String> stackSetAccounts = DefaultSdkAutoConstructList.getInstance();

        private List<String> stackSetRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningArtifactPreferences model) {
            stackSetAccounts(model.stackSetAccounts);
            stackSetRegions(model.stackSetRegions);
        }

        public final Collection<String> getStackSetAccounts() {
            return stackSetAccounts;
        }

        @Override
        public final Builder stackSetAccounts(Collection<String> stackSetAccounts) {
            this.stackSetAccounts = StackSetAccountsCopier.copy(stackSetAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackSetAccounts(String... stackSetAccounts) {
            stackSetAccounts(Arrays.asList(stackSetAccounts));
            return this;
        }

        public final void setStackSetAccounts(Collection<String> stackSetAccounts) {
            this.stackSetAccounts = StackSetAccountsCopier.copy(stackSetAccounts);
        }

        public final Collection<String> getStackSetRegions() {
            return stackSetRegions;
        }

        @Override
        public final Builder stackSetRegions(Collection<String> stackSetRegions) {
            this.stackSetRegions = StackSetRegionsCopier.copy(stackSetRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackSetRegions(String... stackSetRegions) {
            stackSetRegions(Arrays.asList(stackSetRegions));
            return this;
        }

        public final void setStackSetRegions(Collection<String> stackSetRegions) {
            this.stackSetRegions = StackSetRegionsCopier.copy(stackSetRegions);
        }

        @Override
        public ProvisioningArtifactPreferences build() {
            return new ProvisioningArtifactPreferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
