/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains summary information about a product view and a provisioning artifact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisioningArtifactView implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisioningArtifactView.Builder, ProvisioningArtifactView> {
    private static final SdkField<ProductViewSummary> PRODUCT_VIEW_SUMMARY_FIELD = SdkField
            .<ProductViewSummary> builder(MarshallingType.SDK_POJO).getter(getter(ProvisioningArtifactView::productViewSummary))
            .setter(setter(Builder::productViewSummary)).constructor(ProductViewSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewSummary").build())
            .build();

    private static final SdkField<ProvisioningArtifact> PROVISIONING_ARTIFACT_FIELD = SdkField
            .<ProvisioningArtifact> builder(MarshallingType.SDK_POJO)
            .getter(getter(ProvisioningArtifactView::provisioningArtifact)).setter(setter(Builder::provisioningArtifact))
            .constructor(ProvisioningArtifact::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifact").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_VIEW_SUMMARY_FIELD,
            PROVISIONING_ARTIFACT_FIELD));

    private static final long serialVersionUID = 1L;

    private final ProductViewSummary productViewSummary;

    private final ProvisioningArtifact provisioningArtifact;

    private ProvisioningArtifactView(BuilderImpl builder) {
        this.productViewSummary = builder.productViewSummary;
        this.provisioningArtifact = builder.provisioningArtifact;
    }

    /**
     * <p>
     * Summary information about a product view.
     * </p>
     * 
     * @return Summary information about a product view.
     */
    public ProductViewSummary productViewSummary() {
        return productViewSummary;
    }

    /**
     * <p>
     * Information about a provisioning artifact. A provisioning artifact is also known as a product version.
     * </p>
     * 
     * @return Information about a provisioning artifact. A provisioning artifact is also known as a product version.
     */
    public ProvisioningArtifact provisioningArtifact() {
        return provisioningArtifact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(productViewSummary());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifact());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningArtifactView)) {
            return false;
        }
        ProvisioningArtifactView other = (ProvisioningArtifactView) obj;
        return Objects.equals(productViewSummary(), other.productViewSummary())
                && Objects.equals(provisioningArtifact(), other.provisioningArtifact());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProvisioningArtifactView").add("ProductViewSummary", productViewSummary())
                .add("ProvisioningArtifact", provisioningArtifact()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductViewSummary":
            return Optional.ofNullable(clazz.cast(productViewSummary()));
        case "ProvisioningArtifact":
            return Optional.ofNullable(clazz.cast(provisioningArtifact()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisioningArtifactView, T> g) {
        return obj -> g.apply((ProvisioningArtifactView) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisioningArtifactView> {
        /**
         * <p>
         * Summary information about a product view.
         * </p>
         * 
         * @param productViewSummary
         *        Summary information about a product view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productViewSummary(ProductViewSummary productViewSummary);

        /**
         * <p>
         * Summary information about a product view.
         * </p>
         * This is a convenience that creates an instance of the {@link ProductViewSummary.Builder} avoiding the need to
         * create one manually via {@link ProductViewSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProductViewSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #productViewSummary(ProductViewSummary)}.
         * 
         * @param productViewSummary
         *        a consumer that will call methods on {@link ProductViewSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productViewSummary(ProductViewSummary)
         */
        default Builder productViewSummary(Consumer<ProductViewSummary.Builder> productViewSummary) {
            return productViewSummary(ProductViewSummary.builder().applyMutation(productViewSummary).build());
        }

        /**
         * <p>
         * Information about a provisioning artifact. A provisioning artifact is also known as a product version.
         * </p>
         * 
         * @param provisioningArtifact
         *        Information about a provisioning artifact. A provisioning artifact is also known as a product version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifact(ProvisioningArtifact provisioningArtifact);

        /**
         * <p>
         * Information about a provisioning artifact. A provisioning artifact is also known as a product version.
         * </p>
         * This is a convenience that creates an instance of the {@link ProvisioningArtifact.Builder} avoiding the need
         * to create one manually via {@link ProvisioningArtifact#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisioningArtifact.Builder#build()} is called immediately and
         * its result is passed to {@link #provisioningArtifact(ProvisioningArtifact)}.
         * 
         * @param provisioningArtifact
         *        a consumer that will call methods on {@link ProvisioningArtifact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningArtifact(ProvisioningArtifact)
         */
        default Builder provisioningArtifact(Consumer<ProvisioningArtifact.Builder> provisioningArtifact) {
            return provisioningArtifact(ProvisioningArtifact.builder().applyMutation(provisioningArtifact).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProductViewSummary productViewSummary;

        private ProvisioningArtifact provisioningArtifact;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningArtifactView model) {
            productViewSummary(model.productViewSummary);
            provisioningArtifact(model.provisioningArtifact);
        }

        public final ProductViewSummary.Builder getProductViewSummary() {
            return productViewSummary != null ? productViewSummary.toBuilder() : null;
        }

        @Override
        public final Builder productViewSummary(ProductViewSummary productViewSummary) {
            this.productViewSummary = productViewSummary;
            return this;
        }

        public final void setProductViewSummary(ProductViewSummary.BuilderImpl productViewSummary) {
            this.productViewSummary = productViewSummary != null ? productViewSummary.build() : null;
        }

        public final ProvisioningArtifact.Builder getProvisioningArtifact() {
            return provisioningArtifact != null ? provisioningArtifact.toBuilder() : null;
        }

        @Override
        public final Builder provisioningArtifact(ProvisioningArtifact provisioningArtifact) {
            this.provisioningArtifact = provisioningArtifact;
            return this;
        }

        public final void setProvisioningArtifact(ProvisioningArtifact.BuilderImpl provisioningArtifact) {
            this.provisioningArtifact = provisioningArtifact != null ? provisioningArtifact.build() : null;
        }

        @Override
        public ProvisioningArtifactView build() {
            return new ProvisioningArtifactView(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
