/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing detailed information about the self-service action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceActionDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceActionDetail.Builder, ServiceActionDetail> {
    private static final SdkField<ServiceActionSummary> SERVICE_ACTION_SUMMARY_FIELD = SdkField
            .<ServiceActionSummary> builder(MarshallingType.SDK_POJO).getter(getter(ServiceActionDetail::serviceActionSummary))
            .setter(setter(Builder::serviceActionSummary)).constructor(ServiceActionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionSummary").build())
            .build();

    private static final SdkField<Map<String, String>> DEFINITION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ServiceActionDetail::definitionAsStrings))
            .setter(setter(Builder::definitionWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACTION_SUMMARY_FIELD,
            DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ServiceActionSummary serviceActionSummary;

    private final Map<String, String> definition;

    private ServiceActionDetail(BuilderImpl builder) {
        this.serviceActionSummary = builder.serviceActionSummary;
        this.definition = builder.definition;
    }

    /**
     * <p>
     * Summary information about the self-service action.
     * </p>
     * 
     * @return Summary information about the self-service action.
     */
    public ServiceActionSummary serviceActionSummary() {
        return serviceActionSummary;
    }

    /**
     * <p>
     * A map that defines the self-service action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDefinition()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map that defines the self-service action.
     */
    public Map<ServiceActionDefinitionKey, String> definition() {
        return ServiceActionDefinitionMapCopier.copyStringToEnum(definition);
    }

    /**
     * Returns true if the Definition property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDefinition() {
        return definition != null && !(definition instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that defines the self-service action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDefinition()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map that defines the self-service action.
     */
    public Map<String, String> definitionAsStrings() {
        return definition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceActionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(definitionAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceActionDetail)) {
            return false;
        }
        ServiceActionDetail other = (ServiceActionDetail) obj;
        return Objects.equals(serviceActionSummary(), other.serviceActionSummary())
                && Objects.equals(definitionAsStrings(), other.definitionAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServiceActionDetail").add("ServiceActionSummary", serviceActionSummary())
                .add("Definition", definitionAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceActionSummary":
            return Optional.ofNullable(clazz.cast(serviceActionSummary()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definitionAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceActionDetail, T> g) {
        return obj -> g.apply((ServiceActionDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceActionDetail> {
        /**
         * <p>
         * Summary information about the self-service action.
         * </p>
         * 
         * @param serviceActionSummary
         *        Summary information about the self-service action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceActionSummary(ServiceActionSummary serviceActionSummary);

        /**
         * <p>
         * Summary information about the self-service action.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceActionSummary.Builder} avoiding the need
         * to create one manually via {@link ServiceActionSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceActionSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceActionSummary(ServiceActionSummary)}.
         * 
         * @param serviceActionSummary
         *        a consumer that will call methods on {@link ServiceActionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceActionSummary(ServiceActionSummary)
         */
        default Builder serviceActionSummary(Consumer<ServiceActionSummary.Builder> serviceActionSummary) {
            return serviceActionSummary(ServiceActionSummary.builder().applyMutation(serviceActionSummary).build());
        }

        /**
         * <p>
         * A map that defines the self-service action.
         * </p>
         * 
         * @param definition
         *        A map that defines the self-service action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitionWithStrings(Map<String, String> definition);

        /**
         * <p>
         * A map that defines the self-service action.
         * </p>
         * 
         * @param definition
         *        A map that defines the self-service action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(Map<ServiceActionDefinitionKey, String> definition);
    }

    static final class BuilderImpl implements Builder {
        private ServiceActionSummary serviceActionSummary;

        private Map<String, String> definition = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceActionDetail model) {
            serviceActionSummary(model.serviceActionSummary);
            definitionWithStrings(model.definition);
        }

        public final ServiceActionSummary.Builder getServiceActionSummary() {
            return serviceActionSummary != null ? serviceActionSummary.toBuilder() : null;
        }

        @Override
        public final Builder serviceActionSummary(ServiceActionSummary serviceActionSummary) {
            this.serviceActionSummary = serviceActionSummary;
            return this;
        }

        public final void setServiceActionSummary(ServiceActionSummary.BuilderImpl serviceActionSummary) {
            this.serviceActionSummary = serviceActionSummary != null ? serviceActionSummary.build() : null;
        }

        public final Map<String, String> getDefinitionAsStrings() {
            return definition;
        }

        @Override
        public final Builder definitionWithStrings(Map<String, String> definition) {
            this.definition = ServiceActionDefinitionMapCopier.copy(definition);
            return this;
        }

        @Override
        public final Builder definition(Map<ServiceActionDefinitionKey, String> definition) {
            this.definition = ServiceActionDefinitionMapCopier.copyEnumToString(definition);
            return this;
        }

        public final void setDefinitionWithStrings(Map<String, String> definition) {
            this.definition = ServiceActionDefinitionMapCopier.copy(definition);
        }

        @Override
        public ServiceActionDetail build() {
            return new ServiceActionDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
