/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about the self-service action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceActionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceActionSummary.Builder, ServiceActionSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceActionSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceActionSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceActionSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DEFINITION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceActionSummary::definitionTypeAsString)).setter(setter(Builder::definitionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefinitionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, DEFINITION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String description;

    private final String definitionType;

    private ServiceActionSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.definitionType = builder.definitionType;
    }

    /**
     * <p>
     * The self-service action identifier.
     * </p>
     * 
     * @return The self-service action identifier.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The self-service action name.
     * </p>
     * 
     * @return The self-service action name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The self-service action description.
     * </p>
     * 
     * @return The self-service action description.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The self-service action definition type. For example, <code>SSM_AUTOMATION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #definitionType}
     * will return {@link ServiceActionDefinitionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #definitionTypeAsString}.
     * </p>
     * 
     * @return The self-service action definition type. For example, <code>SSM_AUTOMATION</code>.
     * @see ServiceActionDefinitionType
     */
    public ServiceActionDefinitionType definitionType() {
        return ServiceActionDefinitionType.fromValue(definitionType);
    }

    /**
     * <p>
     * The self-service action definition type. For example, <code>SSM_AUTOMATION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #definitionType}
     * will return {@link ServiceActionDefinitionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #definitionTypeAsString}.
     * </p>
     * 
     * @return The self-service action definition type. For example, <code>SSM_AUTOMATION</code>.
     * @see ServiceActionDefinitionType
     */
    public String definitionTypeAsString() {
        return definitionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(definitionTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceActionSummary)) {
            return false;
        }
        ServiceActionSummary other = (ServiceActionSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(definitionTypeAsString(), other.definitionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServiceActionSummary").add("Id", id()).add("Name", name()).add("Description", description())
                .add("DefinitionType", definitionTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DefinitionType":
            return Optional.ofNullable(clazz.cast(definitionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceActionSummary, T> g) {
        return obj -> g.apply((ServiceActionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceActionSummary> {
        /**
         * <p>
         * The self-service action identifier.
         * </p>
         * 
         * @param id
         *        The self-service action identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The self-service action name.
         * </p>
         * 
         * @param name
         *        The self-service action name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The self-service action description.
         * </p>
         * 
         * @param description
         *        The self-service action description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The self-service action definition type. For example, <code>SSM_AUTOMATION</code>.
         * </p>
         * 
         * @param definitionType
         *        The self-service action definition type. For example, <code>SSM_AUTOMATION</code>.
         * @see ServiceActionDefinitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceActionDefinitionType
         */
        Builder definitionType(String definitionType);

        /**
         * <p>
         * The self-service action definition type. For example, <code>SSM_AUTOMATION</code>.
         * </p>
         * 
         * @param definitionType
         *        The self-service action definition type. For example, <code>SSM_AUTOMATION</code>.
         * @see ServiceActionDefinitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceActionDefinitionType
         */
        Builder definitionType(ServiceActionDefinitionType definitionType);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String definitionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceActionSummary model) {
            id(model.id);
            name(model.name);
            description(model.description);
            definitionType(model.definitionType);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDefinitionTypeAsString() {
            return definitionType;
        }

        @Override
        public final Builder definitionType(String definitionType) {
            this.definitionType = definitionType;
            return this;
        }

        @Override
        public final Builder definitionType(ServiceActionDefinitionType definitionType) {
            this.definitionType(definitionType == null ? null : definitionType.toString());
            return this;
        }

        public final void setDefinitionType(String definitionType) {
            this.definitionType = definitionType;
        }

        @Override
        public ServiceActionSummary build() {
            return new ServiceActionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
