/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProductRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<UpdateProductRequest.Builder, UpdateProductRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProductRequest::acceptLanguage)).setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProductRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProductRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProductRequest::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProductRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DISTRIBUTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProductRequest::distributor)).setter(setter(Builder::distributor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distributor").build()).build();

    private static final SdkField<String> SUPPORT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProductRequest::supportDescription)).setter(setter(Builder::supportDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportDescription").build())
            .build();

    private static final SdkField<String> SUPPORT_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProductRequest::supportEmail)).setter(setter(Builder::supportEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportEmail").build()).build();

    private static final SdkField<String> SUPPORT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProductRequest::supportUrl)).setter(setter(Builder::supportUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportUrl").build()).build();

    private static final SdkField<List<Tag>> ADD_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(UpdateProductRequest::addTags))
            .setter(setter(Builder::addTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REMOVE_TAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateProductRequest::removeTags))
            .setter(setter(Builder::removeTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            ID_FIELD, NAME_FIELD, OWNER_FIELD, DESCRIPTION_FIELD, DISTRIBUTOR_FIELD, SUPPORT_DESCRIPTION_FIELD,
            SUPPORT_EMAIL_FIELD, SUPPORT_URL_FIELD, ADD_TAGS_FIELD, REMOVE_TAGS_FIELD));

    private final String acceptLanguage;

    private final String id;

    private final String name;

    private final String owner;

    private final String description;

    private final String distributor;

    private final String supportDescription;

    private final String supportEmail;

    private final String supportUrl;

    private final List<Tag> addTags;

    private final List<String> removeTags;

    private UpdateProductRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.id = builder.id;
        this.name = builder.name;
        this.owner = builder.owner;
        this.description = builder.description;
        this.distributor = builder.distributor;
        this.supportDescription = builder.supportDescription;
        this.supportEmail = builder.supportEmail;
        this.supportUrl = builder.supportUrl;
        this.addTags = builder.addTags;
        this.removeTags = builder.removeTags;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code> - English (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code> - English (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The product identifier.
     * </p>
     * 
     * @return The product identifier.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The updated product name.
     * </p>
     * 
     * @return The updated product name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The updated owner of the product.
     * </p>
     * 
     * @return The updated owner of the product.
     */
    public String owner() {
        return owner;
    }

    /**
     * <p>
     * The updated description of the product.
     * </p>
     * 
     * @return The updated description of the product.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The updated distributor of the product.
     * </p>
     * 
     * @return The updated distributor of the product.
     */
    public String distributor() {
        return distributor;
    }

    /**
     * <p>
     * The updated support description for the product.
     * </p>
     * 
     * @return The updated support description for the product.
     */
    public String supportDescription() {
        return supportDescription;
    }

    /**
     * <p>
     * The updated support email for the product.
     * </p>
     * 
     * @return The updated support email for the product.
     */
    public String supportEmail() {
        return supportEmail;
    }

    /**
     * <p>
     * The updated support URL for the product.
     * </p>
     * 
     * @return The updated support URL for the product.
     */
    public String supportUrl() {
        return supportUrl;
    }

    /**
     * Returns true if the AddTags property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAddTags() {
        return addTags != null && !(addTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to add to the product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAddTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to add to the product.
     */
    public List<Tag> addTags() {
        return addTags;
    }

    /**
     * Returns true if the RemoveTags property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRemoveTags() {
        return removeTags != null && !(removeTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to remove from the product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRemoveTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to remove from the product.
     */
    public List<String> removeTags() {
        return removeTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(distributor());
        hashCode = 31 * hashCode + Objects.hashCode(supportDescription());
        hashCode = 31 * hashCode + Objects.hashCode(supportEmail());
        hashCode = 31 * hashCode + Objects.hashCode(supportUrl());
        hashCode = 31 * hashCode + Objects.hashCode(addTags());
        hashCode = 31 * hashCode + Objects.hashCode(removeTags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProductRequest)) {
            return false;
        }
        UpdateProductRequest other = (UpdateProductRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(owner(), other.owner())
                && Objects.equals(description(), other.description()) && Objects.equals(distributor(), other.distributor())
                && Objects.equals(supportDescription(), other.supportDescription())
                && Objects.equals(supportEmail(), other.supportEmail()) && Objects.equals(supportUrl(), other.supportUrl())
                && Objects.equals(addTags(), other.addTags()) && Objects.equals(removeTags(), other.removeTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateProductRequest").add("AcceptLanguage", acceptLanguage()).add("Id", id())
                .add("Name", name()).add("Owner", owner()).add("Description", description()).add("Distributor", distributor())
                .add("SupportDescription", supportDescription()).add("SupportEmail", supportEmail())
                .add("SupportUrl", supportUrl()).add("AddTags", addTags()).add("RemoveTags", removeTags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Distributor":
            return Optional.ofNullable(clazz.cast(distributor()));
        case "SupportDescription":
            return Optional.ofNullable(clazz.cast(supportDescription()));
        case "SupportEmail":
            return Optional.ofNullable(clazz.cast(supportEmail()));
        case "SupportUrl":
            return Optional.ofNullable(clazz.cast(supportUrl()));
        case "AddTags":
            return Optional.ofNullable(clazz.cast(addTags()));
        case "RemoveTags":
            return Optional.ofNullable(clazz.cast(removeTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProductRequest, T> g) {
        return obj -> g.apply((UpdateProductRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProductRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code> - English (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code> - English (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The product identifier.
         * </p>
         * 
         * @param id
         *        The product identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The updated product name.
         * </p>
         * 
         * @param name
         *        The updated product name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The updated owner of the product.
         * </p>
         * 
         * @param owner
         *        The updated owner of the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The updated description of the product.
         * </p>
         * 
         * @param description
         *        The updated description of the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The updated distributor of the product.
         * </p>
         * 
         * @param distributor
         *        The updated distributor of the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributor(String distributor);

        /**
         * <p>
         * The updated support description for the product.
         * </p>
         * 
         * @param supportDescription
         *        The updated support description for the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportDescription(String supportDescription);

        /**
         * <p>
         * The updated support email for the product.
         * </p>
         * 
         * @param supportEmail
         *        The updated support email for the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportEmail(String supportEmail);

        /**
         * <p>
         * The updated support URL for the product.
         * </p>
         * 
         * @param supportUrl
         *        The updated support URL for the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportUrl(String supportUrl);

        /**
         * <p>
         * The tags to add to the product.
         * </p>
         * 
         * @param addTags
         *        The tags to add to the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addTags(Collection<Tag> addTags);

        /**
         * <p>
         * The tags to add to the product.
         * </p>
         * 
         * @param addTags
         *        The tags to add to the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addTags(Tag... addTags);

        /**
         * <p>
         * The tags to add to the product.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #addTags(List<Tag>)}.
         * 
         * @param addTags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addTags(List<Tag>)
         */
        Builder addTags(Consumer<Tag.Builder>... addTags);

        /**
         * <p>
         * The tags to remove from the product.
         * </p>
         * 
         * @param removeTags
         *        The tags to remove from the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeTags(Collection<String> removeTags);

        /**
         * <p>
         * The tags to remove from the product.
         * </p>
         * 
         * @param removeTags
         *        The tags to remove from the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeTags(String... removeTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String id;

        private String name;

        private String owner;

        private String description;

        private String distributor;

        private String supportDescription;

        private String supportEmail;

        private String supportUrl;

        private List<Tag> addTags = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProductRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            id(model.id);
            name(model.name);
            owner(model.owner);
            description(model.description);
            distributor(model.distributor);
            supportDescription(model.supportDescription);
            supportEmail(model.supportEmail);
            supportUrl(model.supportUrl);
            addTags(model.addTags);
            removeTags(model.removeTags);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDistributor() {
            return distributor;
        }

        @Override
        public final Builder distributor(String distributor) {
            this.distributor = distributor;
            return this;
        }

        public final void setDistributor(String distributor) {
            this.distributor = distributor;
        }

        public final String getSupportDescription() {
            return supportDescription;
        }

        @Override
        public final Builder supportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
            return this;
        }

        public final void setSupportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
        }

        public final String getSupportEmail() {
            return supportEmail;
        }

        @Override
        public final Builder supportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
            return this;
        }

        public final void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        public final String getSupportUrl() {
            return supportUrl;
        }

        @Override
        public final Builder supportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
            return this;
        }

        public final void setSupportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
        }

        public final Collection<Tag.Builder> getAddTags() {
            return addTags != null ? addTags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addTags(Collection<Tag> addTags) {
            this.addTags = AddTagsCopier.copy(addTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Tag... addTags) {
            addTags(Arrays.asList(addTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Consumer<Tag.Builder>... addTags) {
            addTags(Stream.of(addTags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAddTags(Collection<Tag.BuilderImpl> addTags) {
            this.addTags = AddTagsCopier.copyFromBuilder(addTags);
        }

        public final Collection<String> getRemoveTags() {
            return removeTags;
        }

        @Override
        public final Builder removeTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeTags(String... removeTags) {
            removeTags(Arrays.asList(removeTags));
            return this;
        }

        public final void setRemoveTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProductRequest build() {
            return new UpdateProductRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
