/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The user-defined preferences that will be applied when updating a provisioned product. Not all preferences are
 * applicable to all provisioned product types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProvisioningPreferences implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateProvisioningPreferences.Builder, UpdateProvisioningPreferences> {
    private static final SdkField<List<String>> STACK_SET_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateProvisioningPreferences::stackSetAccounts))
            .setter(setter(Builder::stackSetAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STACK_SET_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateProvisioningPreferences::stackSetRegions))
            .setter(setter(Builder::stackSetRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> STACK_SET_FAILURE_TOLERANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateProvisioningPreferences::stackSetFailureToleranceCount))
            .setter(setter(Builder::stackSetFailureToleranceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetFailureToleranceCount")
                    .build()).build();

    private static final SdkField<Integer> STACK_SET_FAILURE_TOLERANCE_PERCENTAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateProvisioningPreferences::stackSetFailureTolerancePercentage))
            .setter(setter(Builder::stackSetFailureTolerancePercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetFailureTolerancePercentage")
                    .build()).build();

    private static final SdkField<Integer> STACK_SET_MAX_CONCURRENCY_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateProvisioningPreferences::stackSetMaxConcurrencyCount))
            .setter(setter(Builder::stackSetMaxConcurrencyCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetMaxConcurrencyCount")
                    .build()).build();

    private static final SdkField<Integer> STACK_SET_MAX_CONCURRENCY_PERCENTAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateProvisioningPreferences::stackSetMaxConcurrencyPercentage))
            .setter(setter(Builder::stackSetMaxConcurrencyPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetMaxConcurrencyPercentage")
                    .build()).build();

    private static final SdkField<String> STACK_SET_OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProvisioningPreferences::stackSetOperationTypeAsString))
            .setter(setter(Builder::stackSetOperationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetOperationType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_ACCOUNTS_FIELD,
            STACK_SET_REGIONS_FIELD, STACK_SET_FAILURE_TOLERANCE_COUNT_FIELD, STACK_SET_FAILURE_TOLERANCE_PERCENTAGE_FIELD,
            STACK_SET_MAX_CONCURRENCY_COUNT_FIELD, STACK_SET_MAX_CONCURRENCY_PERCENTAGE_FIELD, STACK_SET_OPERATION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> stackSetAccounts;

    private final List<String> stackSetRegions;

    private final Integer stackSetFailureToleranceCount;

    private final Integer stackSetFailureTolerancePercentage;

    private final Integer stackSetMaxConcurrencyCount;

    private final Integer stackSetMaxConcurrencyPercentage;

    private final String stackSetOperationType;

    private UpdateProvisioningPreferences(BuilderImpl builder) {
        this.stackSetAccounts = builder.stackSetAccounts;
        this.stackSetRegions = builder.stackSetRegions;
        this.stackSetFailureToleranceCount = builder.stackSetFailureToleranceCount;
        this.stackSetFailureTolerancePercentage = builder.stackSetFailureTolerancePercentage;
        this.stackSetMaxConcurrencyCount = builder.stackSetMaxConcurrencyCount;
        this.stackSetMaxConcurrencyPercentage = builder.stackSetMaxConcurrencyPercentage;
        this.stackSetOperationType = builder.stackSetOperationType;
    }

    /**
     * Returns true if the StackSetAccounts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasStackSetAccounts() {
        return stackSetAccounts != null && !(stackSetAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more AWS accounts that will have access to the provisioned product.
     * </p>
     * <p>
     * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     * </p>
     * <p>
     * The AWS accounts specified should be within the list of accounts in the <code>STACKSET</code> constraint. To get
     * the list of accounts in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code>
     * operation.
     * </p>
     * <p>
     * If no values are specified, the default value is all accounts from the <code>STACKSET</code> constraint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStackSetAccounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more AWS accounts that will have access to the provisioned product.</p>
     *         <p>
     *         Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     *         </p>
     *         <p>
     *         The AWS accounts specified should be within the list of accounts in the <code>STACKSET</code> constraint.
     *         To get the list of accounts in the <code>STACKSET</code> constraint, use the
     *         <code>DescribeProvisioningParameters</code> operation.
     *         </p>
     *         <p>
     *         If no values are specified, the default value is all accounts from the <code>STACKSET</code> constraint.
     */
    public List<String> stackSetAccounts() {
        return stackSetAccounts;
    }

    /**
     * Returns true if the StackSetRegions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasStackSetRegions() {
        return stackSetRegions != null && !(stackSetRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more AWS Regions where the provisioned product will be available.
     * </p>
     * <p>
     * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     * </p>
     * <p>
     * The specified regions should be within the list of regions from the <code>STACKSET</code> constraint. To get the
     * list of regions in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code>
     * operation.
     * </p>
     * <p>
     * If no values are specified, the default value is all regions from the <code>STACKSET</code> constraint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStackSetRegions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more AWS Regions where the provisioned product will be available.</p>
     *         <p>
     *         Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     *         </p>
     *         <p>
     *         The specified regions should be within the list of regions from the <code>STACKSET</code> constraint. To
     *         get the list of regions in the <code>STACKSET</code> constraint, use the
     *         <code>DescribeProvisioningParameters</code> operation.
     *         </p>
     *         <p>
     *         If no values are specified, the default value is all regions from the <code>STACKSET</code> constraint.
     */
    public List<String> stackSetRegions() {
        return stackSetRegions;
    }

    /**
     * <p>
     * The number of accounts, per region, for which this operation can fail before AWS Service Catalog stops the
     * operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the
     * operation in any subsequent regions.
     * </p>
     * <p>
     * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     * </p>
     * <p>
     * Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or
     * <code>StackSetFailureTolerancePercentage</code>, but not both.
     * </p>
     * <p>
     * The default value is <code>0</code> if no value is specified.
     * </p>
     * 
     * @return The number of accounts, per region, for which this operation can fail before AWS Service Catalog stops
     *         the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't
     *         attempt the operation in any subsequent regions.</p>
     *         <p>
     *         Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     *         </p>
     *         <p>
     *         Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or
     *         <code>StackSetFailureTolerancePercentage</code>, but not both.
     *         </p>
     *         <p>
     *         The default value is <code>0</code> if no value is specified.
     */
    public Integer stackSetFailureToleranceCount() {
        return stackSetFailureToleranceCount;
    }

    /**
     * <p>
     * The percentage of accounts, per region, for which this stack operation can fail before AWS Service Catalog stops
     * the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the
     * operation in any subsequent regions.
     * </p>
     * <p>
     * When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the
     * next whole number.
     * </p>
     * <p>
     * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     * </p>
     * <p>
     * Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or
     * <code>StackSetFailureTolerancePercentage</code>, but not both.
     * </p>
     * 
     * @return The percentage of accounts, per region, for which this stack operation can fail before AWS Service
     *         Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog
     *         doesn't attempt the operation in any subsequent regions.</p>
     *         <p>
     *         When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds
     *         down to the next whole number.
     *         </p>
     *         <p>
     *         Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     *         </p>
     *         <p>
     *         Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or
     *         <code>StackSetFailureTolerancePercentage</code>, but not both.
     */
    public Integer stackSetFailureTolerancePercentage() {
        return stackSetFailureTolerancePercentage;
    }

    /**
     * <p>
     * The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of
     * <code>StackSetFailureToleranceCount</code>. <code>StackSetMaxConcurrentCount</code> is at most one more than the
     * <code>StackSetFailureToleranceCount</code>.
     * </p>
     * <p>
     * Note that this setting lets you specify the maximum for operations. For large deployments, under certain
     * circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
     * </p>
     * <p>
     * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     * </p>
     * <p>
     * Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or
     * <code>StackSetMaxConcurrentPercentage</code>, but not both.
     * </p>
     * 
     * @return The maximum number of accounts in which to perform this operation at one time. This is dependent on the
     *         value of <code>StackSetFailureToleranceCount</code>. <code>StackSetMaxConcurrentCount</code> is at most
     *         one more than the <code>StackSetFailureToleranceCount</code>.</p>
     *         <p>
     *         Note that this setting lets you specify the maximum for operations. For large deployments, under certain
     *         circumstances the actual number of accounts acted upon concurrently may be lower due to service
     *         throttling.
     *         </p>
     *         <p>
     *         Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     *         </p>
     *         <p>
     *         Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or
     *         <code>StackSetMaxConcurrentPercentage</code>, but not both.
     */
    public Integer stackSetMaxConcurrencyCount() {
        return stackSetMaxConcurrencyCount;
    }

    /**
     * <p>
     * The maximum percentage of accounts in which to perform this operation at one time.
     * </p>
     * <p>
     * When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the
     * next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS
     * Service Catalog sets the number as <code>1</code> instead.
     * </p>
     * <p>
     * Note that this setting lets you specify the maximum for operations. For large deployments, under certain
     * circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
     * </p>
     * <p>
     * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     * </p>
     * <p>
     * Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or
     * <code>StackSetMaxConcurrentPercentage</code>, but not both.
     * </p>
     * 
     * @return The maximum percentage of accounts in which to perform this operation at one time.</p>
     *         <p>
     *         When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds
     *         down to the next whole number. This is true except in cases where rounding down would result is zero. In
     *         this case, AWS Service Catalog sets the number as <code>1</code> instead.
     *         </p>
     *         <p>
     *         Note that this setting lets you specify the maximum for operations. For large deployments, under certain
     *         circumstances the actual number of accounts acted upon concurrently may be lower due to service
     *         throttling.
     *         </p>
     *         <p>
     *         Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     *         </p>
     *         <p>
     *         Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or
     *         <code>StackSetMaxConcurrentPercentage</code>, but not both.
     */
    public Integer stackSetMaxConcurrencyPercentage() {
        return stackSetMaxConcurrencyPercentage;
    }

    /**
     * <p>
     * Determines what action AWS Service Catalog performs to a stack set or a stack instance represented by the
     * provisioned product. The default value is <code>UPDATE</code> if nothing is specified.
     * </p>
     * <p>
     * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     * </p>
     * <dl>
     * <dt>CREATE</dt>
     * <dd>
     * <p>
     * Creates a new stack instance in the stack set represented by the provisioned product. In this case, only new
     * stack instances are created based on accounts and regions; if new ProductId or ProvisioningArtifactID are passed,
     * they will be ignored.
     * </p>
     * </dd>
     * <dt>UPDATE</dt>
     * <dd>
     * <p>
     * Updates the stack set represented by the provisioned product and also its stack instances.
     * </p>
     * </dd>
     * <dt>DELETE</dt>
     * <dd>
     * <p>
     * Deletes a stack instance in the stack set represented by the provisioned product.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #stackSetOperationType} will return {@link StackSetOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #stackSetOperationTypeAsString}.
     * </p>
     * 
     * @return Determines what action AWS Service Catalog performs to a stack set or a stack instance represented by the
     *         provisioned product. The default value is <code>UPDATE</code> if nothing is specified.</p>
     *         <p>
     *         Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     *         </p>
     *         <dl>
     *         <dt>CREATE</dt>
     *         <dd>
     *         <p>
     *         Creates a new stack instance in the stack set represented by the provisioned product. In this case, only
     *         new stack instances are created based on accounts and regions; if new ProductId or ProvisioningArtifactID
     *         are passed, they will be ignored.
     *         </p>
     *         </dd>
     *         <dt>UPDATE</dt>
     *         <dd>
     *         <p>
     *         Updates the stack set represented by the provisioned product and also its stack instances.
     *         </p>
     *         </dd>
     *         <dt>DELETE</dt>
     *         <dd>
     *         <p>
     *         Deletes a stack instance in the stack set represented by the provisioned product.
     *         </p>
     *         </dd>
     * @see StackSetOperationType
     */
    public StackSetOperationType stackSetOperationType() {
        return StackSetOperationType.fromValue(stackSetOperationType);
    }

    /**
     * <p>
     * Determines what action AWS Service Catalog performs to a stack set or a stack instance represented by the
     * provisioned product. The default value is <code>UPDATE</code> if nothing is specified.
     * </p>
     * <p>
     * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     * </p>
     * <dl>
     * <dt>CREATE</dt>
     * <dd>
     * <p>
     * Creates a new stack instance in the stack set represented by the provisioned product. In this case, only new
     * stack instances are created based on accounts and regions; if new ProductId or ProvisioningArtifactID are passed,
     * they will be ignored.
     * </p>
     * </dd>
     * <dt>UPDATE</dt>
     * <dd>
     * <p>
     * Updates the stack set represented by the provisioned product and also its stack instances.
     * </p>
     * </dd>
     * <dt>DELETE</dt>
     * <dd>
     * <p>
     * Deletes a stack instance in the stack set represented by the provisioned product.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #stackSetOperationType} will return {@link StackSetOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #stackSetOperationTypeAsString}.
     * </p>
     * 
     * @return Determines what action AWS Service Catalog performs to a stack set or a stack instance represented by the
     *         provisioned product. The default value is <code>UPDATE</code> if nothing is specified.</p>
     *         <p>
     *         Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     *         </p>
     *         <dl>
     *         <dt>CREATE</dt>
     *         <dd>
     *         <p>
     *         Creates a new stack instance in the stack set represented by the provisioned product. In this case, only
     *         new stack instances are created based on accounts and regions; if new ProductId or ProvisioningArtifactID
     *         are passed, they will be ignored.
     *         </p>
     *         </dd>
     *         <dt>UPDATE</dt>
     *         <dd>
     *         <p>
     *         Updates the stack set represented by the provisioned product and also its stack instances.
     *         </p>
     *         </dd>
     *         <dt>DELETE</dt>
     *         <dd>
     *         <p>
     *         Deletes a stack instance in the stack set represented by the provisioned product.
     *         </p>
     *         </dd>
     * @see StackSetOperationType
     */
    public String stackSetOperationTypeAsString() {
        return stackSetOperationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackSetAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(stackSetRegions());
        hashCode = 31 * hashCode + Objects.hashCode(stackSetFailureToleranceCount());
        hashCode = 31 * hashCode + Objects.hashCode(stackSetFailureTolerancePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(stackSetMaxConcurrencyCount());
        hashCode = 31 * hashCode + Objects.hashCode(stackSetMaxConcurrencyPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(stackSetOperationTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProvisioningPreferences)) {
            return false;
        }
        UpdateProvisioningPreferences other = (UpdateProvisioningPreferences) obj;
        return Objects.equals(stackSetAccounts(), other.stackSetAccounts())
                && Objects.equals(stackSetRegions(), other.stackSetRegions())
                && Objects.equals(stackSetFailureToleranceCount(), other.stackSetFailureToleranceCount())
                && Objects.equals(stackSetFailureTolerancePercentage(), other.stackSetFailureTolerancePercentage())
                && Objects.equals(stackSetMaxConcurrencyCount(), other.stackSetMaxConcurrencyCount())
                && Objects.equals(stackSetMaxConcurrencyPercentage(), other.stackSetMaxConcurrencyPercentage())
                && Objects.equals(stackSetOperationTypeAsString(), other.stackSetOperationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateProvisioningPreferences").add("StackSetAccounts", stackSetAccounts())
                .add("StackSetRegions", stackSetRegions()).add("StackSetFailureToleranceCount", stackSetFailureToleranceCount())
                .add("StackSetFailureTolerancePercentage", stackSetFailureTolerancePercentage())
                .add("StackSetMaxConcurrencyCount", stackSetMaxConcurrencyCount())
                .add("StackSetMaxConcurrencyPercentage", stackSetMaxConcurrencyPercentage())
                .add("StackSetOperationType", stackSetOperationTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSetAccounts":
            return Optional.ofNullable(clazz.cast(stackSetAccounts()));
        case "StackSetRegions":
            return Optional.ofNullable(clazz.cast(stackSetRegions()));
        case "StackSetFailureToleranceCount":
            return Optional.ofNullable(clazz.cast(stackSetFailureToleranceCount()));
        case "StackSetFailureTolerancePercentage":
            return Optional.ofNullable(clazz.cast(stackSetFailureTolerancePercentage()));
        case "StackSetMaxConcurrencyCount":
            return Optional.ofNullable(clazz.cast(stackSetMaxConcurrencyCount()));
        case "StackSetMaxConcurrencyPercentage":
            return Optional.ofNullable(clazz.cast(stackSetMaxConcurrencyPercentage()));
        case "StackSetOperationType":
            return Optional.ofNullable(clazz.cast(stackSetOperationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProvisioningPreferences, T> g) {
        return obj -> g.apply((UpdateProvisioningPreferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateProvisioningPreferences> {
        /**
         * <p>
         * One or more AWS accounts that will have access to the provisioned product.
         * </p>
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * </p>
         * <p>
         * The AWS accounts specified should be within the list of accounts in the <code>STACKSET</code> constraint. To
         * get the list of accounts in the <code>STACKSET</code> constraint, use the
         * <code>DescribeProvisioningParameters</code> operation.
         * </p>
         * <p>
         * If no values are specified, the default value is all accounts from the <code>STACKSET</code> constraint.
         * </p>
         * 
         * @param stackSetAccounts
         *        One or more AWS accounts that will have access to the provisioned product.</p>
         *        <p>
         *        Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         *        </p>
         *        <p>
         *        The AWS accounts specified should be within the list of accounts in the <code>STACKSET</code>
         *        constraint. To get the list of accounts in the <code>STACKSET</code> constraint, use the
         *        <code>DescribeProvisioningParameters</code> operation.
         *        </p>
         *        <p>
         *        If no values are specified, the default value is all accounts from the <code>STACKSET</code>
         *        constraint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetAccounts(Collection<String> stackSetAccounts);

        /**
         * <p>
         * One or more AWS accounts that will have access to the provisioned product.
         * </p>
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * </p>
         * <p>
         * The AWS accounts specified should be within the list of accounts in the <code>STACKSET</code> constraint. To
         * get the list of accounts in the <code>STACKSET</code> constraint, use the
         * <code>DescribeProvisioningParameters</code> operation.
         * </p>
         * <p>
         * If no values are specified, the default value is all accounts from the <code>STACKSET</code> constraint.
         * </p>
         * 
         * @param stackSetAccounts
         *        One or more AWS accounts that will have access to the provisioned product.</p>
         *        <p>
         *        Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         *        </p>
         *        <p>
         *        The AWS accounts specified should be within the list of accounts in the <code>STACKSET</code>
         *        constraint. To get the list of accounts in the <code>STACKSET</code> constraint, use the
         *        <code>DescribeProvisioningParameters</code> operation.
         *        </p>
         *        <p>
         *        If no values are specified, the default value is all accounts from the <code>STACKSET</code>
         *        constraint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetAccounts(String... stackSetAccounts);

        /**
         * <p>
         * One or more AWS Regions where the provisioned product will be available.
         * </p>
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * </p>
         * <p>
         * The specified regions should be within the list of regions from the <code>STACKSET</code> constraint. To get
         * the list of regions in the <code>STACKSET</code> constraint, use the
         * <code>DescribeProvisioningParameters</code> operation.
         * </p>
         * <p>
         * If no values are specified, the default value is all regions from the <code>STACKSET</code> constraint.
         * </p>
         * 
         * @param stackSetRegions
         *        One or more AWS Regions where the provisioned product will be available.</p>
         *        <p>
         *        Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         *        </p>
         *        <p>
         *        The specified regions should be within the list of regions from the <code>STACKSET</code> constraint.
         *        To get the list of regions in the <code>STACKSET</code> constraint, use the
         *        <code>DescribeProvisioningParameters</code> operation.
         *        </p>
         *        <p>
         *        If no values are specified, the default value is all regions from the <code>STACKSET</code>
         *        constraint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetRegions(Collection<String> stackSetRegions);

        /**
         * <p>
         * One or more AWS Regions where the provisioned product will be available.
         * </p>
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * </p>
         * <p>
         * The specified regions should be within the list of regions from the <code>STACKSET</code> constraint. To get
         * the list of regions in the <code>STACKSET</code> constraint, use the
         * <code>DescribeProvisioningParameters</code> operation.
         * </p>
         * <p>
         * If no values are specified, the default value is all regions from the <code>STACKSET</code> constraint.
         * </p>
         * 
         * @param stackSetRegions
         *        One or more AWS Regions where the provisioned product will be available.</p>
         *        <p>
         *        Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         *        </p>
         *        <p>
         *        The specified regions should be within the list of regions from the <code>STACKSET</code> constraint.
         *        To get the list of regions in the <code>STACKSET</code> constraint, use the
         *        <code>DescribeProvisioningParameters</code> operation.
         *        </p>
         *        <p>
         *        If no values are specified, the default value is all regions from the <code>STACKSET</code>
         *        constraint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetRegions(String... stackSetRegions);

        /**
         * <p>
         * The number of accounts, per region, for which this operation can fail before AWS Service Catalog stops the
         * operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the
         * operation in any subsequent regions.
         * </p>
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * </p>
         * <p>
         * Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or
         * <code>StackSetFailureTolerancePercentage</code>, but not both.
         * </p>
         * <p>
         * The default value is <code>0</code> if no value is specified.
         * </p>
         * 
         * @param stackSetFailureToleranceCount
         *        The number of accounts, per region, for which this operation can fail before AWS Service Catalog stops
         *        the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't
         *        attempt the operation in any subsequent regions.</p>
         *        <p>
         *        Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         *        </p>
         *        <p>
         *        Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or
         *        <code>StackSetFailureTolerancePercentage</code>, but not both.
         *        </p>
         *        <p>
         *        The default value is <code>0</code> if no value is specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetFailureToleranceCount(Integer stackSetFailureToleranceCount);

        /**
         * <p>
         * The percentage of accounts, per region, for which this stack operation can fail before AWS Service Catalog
         * stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't
         * attempt the operation in any subsequent regions.
         * </p>
         * <p>
         * When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to
         * the next whole number.
         * </p>
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * </p>
         * <p>
         * Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or
         * <code>StackSetFailureTolerancePercentage</code>, but not both.
         * </p>
         * 
         * @param stackSetFailureTolerancePercentage
         *        The percentage of accounts, per region, for which this stack operation can fail before AWS Service
         *        Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service
         *        Catalog doesn't attempt the operation in any subsequent regions.</p>
         *        <p>
         *        When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds
         *        down to the next whole number.
         *        </p>
         *        <p>
         *        Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         *        </p>
         *        <p>
         *        Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or
         *        <code>StackSetFailureTolerancePercentage</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetFailureTolerancePercentage(Integer stackSetFailureTolerancePercentage);

        /**
         * <p>
         * The maximum number of accounts in which to perform this operation at one time. This is dependent on the value
         * of <code>StackSetFailureToleranceCount</code>. <code>StackSetMaxConcurrentCount</code> is at most one more
         * than the <code>StackSetFailureToleranceCount</code>.
         * </p>
         * <p>
         * Note that this setting lets you specify the maximum for operations. For large deployments, under certain
         * circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
         * </p>
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * </p>
         * <p>
         * Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or
         * <code>StackSetMaxConcurrentPercentage</code>, but not both.
         * </p>
         * 
         * @param stackSetMaxConcurrencyCount
         *        The maximum number of accounts in which to perform this operation at one time. This is dependent on
         *        the value of <code>StackSetFailureToleranceCount</code>. <code>StackSetMaxConcurrentCount</code> is at
         *        most one more than the <code>StackSetFailureToleranceCount</code>.</p>
         *        <p>
         *        Note that this setting lets you specify the maximum for operations. For large deployments, under
         *        certain circumstances the actual number of accounts acted upon concurrently may be lower due to
         *        service throttling.
         *        </p>
         *        <p>
         *        Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         *        </p>
         *        <p>
         *        Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or
         *        <code>StackSetMaxConcurrentPercentage</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetMaxConcurrencyCount(Integer stackSetMaxConcurrencyCount);

        /**
         * <p>
         * The maximum percentage of accounts in which to perform this operation at one time.
         * </p>
         * <p>
         * When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to
         * the next whole number. This is true except in cases where rounding down would result is zero. In this case,
         * AWS Service Catalog sets the number as <code>1</code> instead.
         * </p>
         * <p>
         * Note that this setting lets you specify the maximum for operations. For large deployments, under certain
         * circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
         * </p>
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * </p>
         * <p>
         * Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or
         * <code>StackSetMaxConcurrentPercentage</code>, but not both.
         * </p>
         * 
         * @param stackSetMaxConcurrencyPercentage
         *        The maximum percentage of accounts in which to perform this operation at one time.</p>
         *        <p>
         *        When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds
         *        down to the next whole number. This is true except in cases where rounding down would result is zero.
         *        In this case, AWS Service Catalog sets the number as <code>1</code> instead.
         *        </p>
         *        <p>
         *        Note that this setting lets you specify the maximum for operations. For large deployments, under
         *        certain circumstances the actual number of accounts acted upon concurrently may be lower due to
         *        service throttling.
         *        </p>
         *        <p>
         *        Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         *        </p>
         *        <p>
         *        Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or
         *        <code>StackSetMaxConcurrentPercentage</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetMaxConcurrencyPercentage(Integer stackSetMaxConcurrencyPercentage);

        /**
         * <p>
         * Determines what action AWS Service Catalog performs to a stack set or a stack instance represented by the
         * provisioned product. The default value is <code>UPDATE</code> if nothing is specified.
         * </p>
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * </p>
         * <dl>
         * <dt>CREATE</dt>
         * <dd>
         * <p>
         * Creates a new stack instance in the stack set represented by the provisioned product. In this case, only new
         * stack instances are created based on accounts and regions; if new ProductId or ProvisioningArtifactID are
         * passed, they will be ignored.
         * </p>
         * </dd>
         * <dt>UPDATE</dt>
         * <dd>
         * <p>
         * Updates the stack set represented by the provisioned product and also its stack instances.
         * </p>
         * </dd>
         * <dt>DELETE</dt>
         * <dd>
         * <p>
         * Deletes a stack instance in the stack set represented by the provisioned product.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param stackSetOperationType
         *        Determines what action AWS Service Catalog performs to a stack set or a stack instance represented by
         *        the provisioned product. The default value is <code>UPDATE</code> if nothing is specified.</p>
         *        <p>
         *        Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         *        </p>
         *        <dl>
         *        <dt>CREATE</dt>
         *        <dd>
         *        <p>
         *        Creates a new stack instance in the stack set represented by the provisioned product. In this case,
         *        only new stack instances are created based on accounts and regions; if new ProductId or
         *        ProvisioningArtifactID are passed, they will be ignored.
         *        </p>
         *        </dd>
         *        <dt>UPDATE</dt>
         *        <dd>
         *        <p>
         *        Updates the stack set represented by the provisioned product and also its stack instances.
         *        </p>
         *        </dd>
         *        <dt>DELETE</dt>
         *        <dd>
         *        <p>
         *        Deletes a stack instance in the stack set represented by the provisioned product.
         *        </p>
         *        </dd>
         * @see StackSetOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackSetOperationType
         */
        Builder stackSetOperationType(String stackSetOperationType);

        /**
         * <p>
         * Determines what action AWS Service Catalog performs to a stack set or a stack instance represented by the
         * provisioned product. The default value is <code>UPDATE</code> if nothing is specified.
         * </p>
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * </p>
         * <dl>
         * <dt>CREATE</dt>
         * <dd>
         * <p>
         * Creates a new stack instance in the stack set represented by the provisioned product. In this case, only new
         * stack instances are created based on accounts and regions; if new ProductId or ProvisioningArtifactID are
         * passed, they will be ignored.
         * </p>
         * </dd>
         * <dt>UPDATE</dt>
         * <dd>
         * <p>
         * Updates the stack set represented by the provisioned product and also its stack instances.
         * </p>
         * </dd>
         * <dt>DELETE</dt>
         * <dd>
         * <p>
         * Deletes a stack instance in the stack set represented by the provisioned product.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param stackSetOperationType
         *        Determines what action AWS Service Catalog performs to a stack set or a stack instance represented by
         *        the provisioned product. The default value is <code>UPDATE</code> if nothing is specified.</p>
         *        <p>
         *        Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         *        </p>
         *        <dl>
         *        <dt>CREATE</dt>
         *        <dd>
         *        <p>
         *        Creates a new stack instance in the stack set represented by the provisioned product. In this case,
         *        only new stack instances are created based on accounts and regions; if new ProductId or
         *        ProvisioningArtifactID are passed, they will be ignored.
         *        </p>
         *        </dd>
         *        <dt>UPDATE</dt>
         *        <dd>
         *        <p>
         *        Updates the stack set represented by the provisioned product and also its stack instances.
         *        </p>
         *        </dd>
         *        <dt>DELETE</dt>
         *        <dd>
         *        <p>
         *        Deletes a stack instance in the stack set represented by the provisioned product.
         *        </p>
         *        </dd>
         * @see StackSetOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackSetOperationType
         */
        Builder stackSetOperationType(StackSetOperationType stackSetOperationType);
    }

    static final class BuilderImpl implements Builder {
        private List<String> stackSetAccounts = DefaultSdkAutoConstructList.getInstance();

        private List<String> stackSetRegions = DefaultSdkAutoConstructList.getInstance();

        private Integer stackSetFailureToleranceCount;

        private Integer stackSetFailureTolerancePercentage;

        private Integer stackSetMaxConcurrencyCount;

        private Integer stackSetMaxConcurrencyPercentage;

        private String stackSetOperationType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProvisioningPreferences model) {
            stackSetAccounts(model.stackSetAccounts);
            stackSetRegions(model.stackSetRegions);
            stackSetFailureToleranceCount(model.stackSetFailureToleranceCount);
            stackSetFailureTolerancePercentage(model.stackSetFailureTolerancePercentage);
            stackSetMaxConcurrencyCount(model.stackSetMaxConcurrencyCount);
            stackSetMaxConcurrencyPercentage(model.stackSetMaxConcurrencyPercentage);
            stackSetOperationType(model.stackSetOperationType);
        }

        public final Collection<String> getStackSetAccounts() {
            return stackSetAccounts;
        }

        @Override
        public final Builder stackSetAccounts(Collection<String> stackSetAccounts) {
            this.stackSetAccounts = StackSetAccountsCopier.copy(stackSetAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackSetAccounts(String... stackSetAccounts) {
            stackSetAccounts(Arrays.asList(stackSetAccounts));
            return this;
        }

        public final void setStackSetAccounts(Collection<String> stackSetAccounts) {
            this.stackSetAccounts = StackSetAccountsCopier.copy(stackSetAccounts);
        }

        public final Collection<String> getStackSetRegions() {
            return stackSetRegions;
        }

        @Override
        public final Builder stackSetRegions(Collection<String> stackSetRegions) {
            this.stackSetRegions = StackSetRegionsCopier.copy(stackSetRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackSetRegions(String... stackSetRegions) {
            stackSetRegions(Arrays.asList(stackSetRegions));
            return this;
        }

        public final void setStackSetRegions(Collection<String> stackSetRegions) {
            this.stackSetRegions = StackSetRegionsCopier.copy(stackSetRegions);
        }

        public final Integer getStackSetFailureToleranceCount() {
            return stackSetFailureToleranceCount;
        }

        @Override
        public final Builder stackSetFailureToleranceCount(Integer stackSetFailureToleranceCount) {
            this.stackSetFailureToleranceCount = stackSetFailureToleranceCount;
            return this;
        }

        public final void setStackSetFailureToleranceCount(Integer stackSetFailureToleranceCount) {
            this.stackSetFailureToleranceCount = stackSetFailureToleranceCount;
        }

        public final Integer getStackSetFailureTolerancePercentage() {
            return stackSetFailureTolerancePercentage;
        }

        @Override
        public final Builder stackSetFailureTolerancePercentage(Integer stackSetFailureTolerancePercentage) {
            this.stackSetFailureTolerancePercentage = stackSetFailureTolerancePercentage;
            return this;
        }

        public final void setStackSetFailureTolerancePercentage(Integer stackSetFailureTolerancePercentage) {
            this.stackSetFailureTolerancePercentage = stackSetFailureTolerancePercentage;
        }

        public final Integer getStackSetMaxConcurrencyCount() {
            return stackSetMaxConcurrencyCount;
        }

        @Override
        public final Builder stackSetMaxConcurrencyCount(Integer stackSetMaxConcurrencyCount) {
            this.stackSetMaxConcurrencyCount = stackSetMaxConcurrencyCount;
            return this;
        }

        public final void setStackSetMaxConcurrencyCount(Integer stackSetMaxConcurrencyCount) {
            this.stackSetMaxConcurrencyCount = stackSetMaxConcurrencyCount;
        }

        public final Integer getStackSetMaxConcurrencyPercentage() {
            return stackSetMaxConcurrencyPercentage;
        }

        @Override
        public final Builder stackSetMaxConcurrencyPercentage(Integer stackSetMaxConcurrencyPercentage) {
            this.stackSetMaxConcurrencyPercentage = stackSetMaxConcurrencyPercentage;
            return this;
        }

        public final void setStackSetMaxConcurrencyPercentage(Integer stackSetMaxConcurrencyPercentage) {
            this.stackSetMaxConcurrencyPercentage = stackSetMaxConcurrencyPercentage;
        }

        public final String getStackSetOperationTypeAsString() {
            return stackSetOperationType;
        }

        @Override
        public final Builder stackSetOperationType(String stackSetOperationType) {
            this.stackSetOperationType = stackSetOperationType;
            return this;
        }

        @Override
        public final Builder stackSetOperationType(StackSetOperationType stackSetOperationType) {
            this.stackSetOperationType(stackSetOperationType == null ? null : stackSetOperationType.toString());
            return this;
        }

        public final void setStackSetOperationType(String stackSetOperationType) {
            this.stackSetOperationType = stackSetOperationType;
        }

        @Override
        public UpdateProvisioningPreferences build() {
            return new UpdateProvisioningPreferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
