/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicediscovery.model.RecordType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DnsRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DnsRecord> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DnsRecord.getter(DnsRecord::typeAsString)).setter(DnsRecord.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Long> TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DnsRecord.getter(DnsRecord::ttl)).setter(DnsRecord.setter(Builder::ttl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TTL").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TTL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Long ttl;

    private DnsRecord(BuilderImpl builder) {
        this.type = builder.type;
        this.ttl = builder.ttl;
    }

    public RecordType type() {
        return RecordType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Long ttl() {
        return this.ttl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ttl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsRecord)) {
            return false;
        }
        DnsRecord other = (DnsRecord)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.ttl(), other.ttl());
    }

    public String toString() {
        return ToString.builder((String)"DnsRecord").add("Type", (Object)this.typeAsString()).add("TTL", (Object)this.ttl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "TTL": {
                return Optional.ofNullable(clazz.cast(this.ttl()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DnsRecord, T> g) {
        return obj -> g.apply((DnsRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Long ttl;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsRecord model) {
            this.type(model.type);
            this.ttl(model.ttl);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RecordType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Long getTtl() {
            return this.ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTtl(Long ttl) {
            this.ttl = ttl;
        }

        public DnsRecord build() {
            return new DnsRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DnsRecord> {
        public Builder type(String var1);

        public Builder type(RecordType var1);

        public Builder ttl(Long var1);
    }
}

