/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceSummariesListCopier;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceSummary;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNamespacesResponse
extends ServiceDiscoveryResponse
implements ToCopyableBuilder<Builder, ListNamespacesResponse> {
    private static final SdkField<List<NamespaceSummary>> NAMESPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListNamespacesResponse.getter(ListNamespacesResponse::namespaces)).setter(ListNamespacesResponse.setter(Builder::namespaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NamespaceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListNamespacesResponse.getter(ListNamespacesResponse::nextToken)).setter(ListNamespacesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACES_FIELD, NEXT_TOKEN_FIELD));
    private final List<NamespaceSummary> namespaces;
    private final String nextToken;

    private ListNamespacesResponse(BuilderImpl builder) {
        super(builder);
        this.namespaces = builder.namespaces;
        this.nextToken = builder.nextToken;
    }

    public boolean hasNamespaces() {
        return this.namespaces != null && !(this.namespaces instanceof SdkAutoConstructList);
    }

    public List<NamespaceSummary> namespaces() {
        return this.namespaces;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNamespacesResponse)) {
            return false;
        }
        ListNamespacesResponse other = (ListNamespacesResponse)((Object)obj);
        return Objects.equals(this.namespaces(), other.namespaces()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListNamespacesResponse").add("Namespaces", this.namespaces()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Namespaces": {
                return Optional.ofNullable(clazz.cast(this.namespaces()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNamespacesResponse, T> g) {
        return obj -> g.apply((ListNamespacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceDiscoveryResponse.BuilderImpl
    implements Builder {
        private List<NamespaceSummary> namespaces = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNamespacesResponse model) {
            super(model);
            this.namespaces(model.namespaces);
            this.nextToken(model.nextToken);
        }

        public final Collection<NamespaceSummary.Builder> getNamespaces() {
            return this.namespaces != null ? (Collection)this.namespaces.stream().map(NamespaceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder namespaces(Collection<NamespaceSummary> namespaces) {
            this.namespaces = NamespaceSummariesListCopier.copy(namespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(NamespaceSummary ... namespaces) {
            this.namespaces(Arrays.asList(namespaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(Consumer<NamespaceSummary.Builder> ... namespaces) {
            this.namespaces(Stream.of(namespaces).map(c -> (NamespaceSummary)((NamespaceSummary.Builder)NamespaceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNamespaces(Collection<NamespaceSummary.BuilderImpl> namespaces) {
            this.namespaces = NamespaceSummariesListCopier.copyFromBuilder(namespaces);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListNamespacesResponse build() {
            return new ListNamespacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceDiscoveryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNamespacesResponse> {
        public Builder namespaces(Collection<NamespaceSummary> var1);

        public Builder namespaces(NamespaceSummary ... var1);

        public Builder namespaces(Consumer<NamespaceSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

