/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateTemplateRequest extends SmsRequest implements
        ToCopyableBuilder<GenerateTemplateRequest.Builder, GenerateTemplateRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(GenerateTemplateRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> TEMPLATE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateFormat").getter(getter(GenerateTemplateRequest::templateFormatAsString))
            .setter(setter(Builder::templateFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            TEMPLATE_FORMAT_FIELD));

    private final String appId;

    private final String templateFormat;

    private GenerateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.templateFormat = builder.templateFormat;
    }

    /**
     * <p>
     * The ID of the application associated with the CloudFormation template.
     * </p>
     * 
     * @return The ID of the application associated with the CloudFormation template.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The format for generating the CloudFormation template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateFormat}
     * will return {@link OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateFormatAsString}.
     * </p>
     * 
     * @return The format for generating the CloudFormation template.
     * @see OutputFormat
     */
    public final OutputFormat templateFormat() {
        return OutputFormat.fromValue(templateFormat);
    }

    /**
     * <p>
     * The format for generating the CloudFormation template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateFormat}
     * will return {@link OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateFormatAsString}.
     * </p>
     * 
     * @return The format for generating the CloudFormation template.
     * @see OutputFormat
     */
    public final String templateFormatAsString() {
        return templateFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(templateFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateTemplateRequest)) {
            return false;
        }
        GenerateTemplateRequest other = (GenerateTemplateRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(templateFormatAsString(), other.templateFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateTemplateRequest").add("AppId", appId()).add("TemplateFormat", templateFormatAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "templateFormat":
            return Optional.ofNullable(clazz.cast(templateFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerateTemplateRequest, T> g) {
        return obj -> g.apply((GenerateTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GenerateTemplateRequest> {
        /**
         * <p>
         * The ID of the application associated with the CloudFormation template.
         * </p>
         * 
         * @param appId
         *        The ID of the application associated with the CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The format for generating the CloudFormation template.
         * </p>
         * 
         * @param templateFormat
         *        The format for generating the CloudFormation template.
         * @see OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputFormat
         */
        Builder templateFormat(String templateFormat);

        /**
         * <p>
         * The format for generating the CloudFormation template.
         * </p>
         * 
         * @param templateFormat
         *        The format for generating the CloudFormation template.
         * @see OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputFormat
         */
        Builder templateFormat(OutputFormat templateFormat);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SmsRequest.BuilderImpl implements Builder {
        private String appId;

        private String templateFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateTemplateRequest model) {
            super(model);
            appId(model.appId);
            templateFormat(model.templateFormat);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getTemplateFormat() {
            return templateFormat;
        }

        public final void setTemplateFormat(String templateFormat) {
            this.templateFormat = templateFormat;
        }

        @Override
        public final Builder templateFormat(String templateFormat) {
            this.templateFormat = templateFormat;
            return this;
        }

        @Override
        public final Builder templateFormat(OutputFormat templateFormat) {
            this.templateFormat(templateFormat == null ? null : templateFormat.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateTemplateRequest build() {
            return new GenerateTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
