/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Replication configuration for a server group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerGroupReplicationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerGroupReplicationConfiguration.Builder, ServerGroupReplicationConfiguration> {
    private static final SdkField<String> SERVER_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serverGroupId").getter(getter(ServerGroupReplicationConfiguration::serverGroupId))
            .setter(setter(Builder::serverGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroupId").build()).build();

    private static final SdkField<List<ServerReplicationConfiguration>> SERVER_REPLICATION_CONFIGURATIONS_FIELD = SdkField
            .<List<ServerReplicationConfiguration>> builder(MarshallingType.LIST)
            .memberName("serverReplicationConfigurations")
            .getter(getter(ServerGroupReplicationConfiguration::serverReplicationConfigurations))
            .setter(setter(Builder::serverReplicationConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverReplicationConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerReplicationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerReplicationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_GROUP_ID_FIELD,
            SERVER_REPLICATION_CONFIGURATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serverGroupId;

    private final List<ServerReplicationConfiguration> serverReplicationConfigurations;

    private ServerGroupReplicationConfiguration(BuilderImpl builder) {
        this.serverGroupId = builder.serverGroupId;
        this.serverReplicationConfigurations = builder.serverReplicationConfigurations;
    }

    /**
     * <p>
     * The ID of the server group with which this replication configuration is associated.
     * </p>
     * 
     * @return The ID of the server group with which this replication configuration is associated.
     */
    public final String serverGroupId() {
        return serverGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServerReplicationConfigurations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasServerReplicationConfigurations() {
        return serverReplicationConfigurations != null && !(serverReplicationConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The replication configuration for servers in the server group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServerReplicationConfigurations}
     * method.
     * </p>
     * 
     * @return The replication configuration for servers in the server group.
     */
    public final List<ServerReplicationConfiguration> serverReplicationConfigurations() {
        return serverReplicationConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverGroupId());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasServerReplicationConfigurations() ? serverReplicationConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerGroupReplicationConfiguration)) {
            return false;
        }
        ServerGroupReplicationConfiguration other = (ServerGroupReplicationConfiguration) obj;
        return Objects.equals(serverGroupId(), other.serverGroupId())
                && hasServerReplicationConfigurations() == other.hasServerReplicationConfigurations()
                && Objects.equals(serverReplicationConfigurations(), other.serverReplicationConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ServerGroupReplicationConfiguration")
                .add("ServerGroupId", serverGroupId())
                .add("ServerReplicationConfigurations",
                        hasServerReplicationConfigurations() ? serverReplicationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serverGroupId":
            return Optional.ofNullable(clazz.cast(serverGroupId()));
        case "serverReplicationConfigurations":
            return Optional.ofNullable(clazz.cast(serverReplicationConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerGroupReplicationConfiguration, T> g) {
        return obj -> g.apply((ServerGroupReplicationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerGroupReplicationConfiguration> {
        /**
         * <p>
         * The ID of the server group with which this replication configuration is associated.
         * </p>
         * 
         * @param serverGroupId
         *        The ID of the server group with which this replication configuration is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroupId(String serverGroupId);

        /**
         * <p>
         * The replication configuration for servers in the server group.
         * </p>
         * 
         * @param serverReplicationConfigurations
         *        The replication configuration for servers in the server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverReplicationConfigurations(Collection<ServerReplicationConfiguration> serverReplicationConfigurations);

        /**
         * <p>
         * The replication configuration for servers in the server group.
         * </p>
         * 
         * @param serverReplicationConfigurations
         *        The replication configuration for servers in the server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverReplicationConfigurations(ServerReplicationConfiguration... serverReplicationConfigurations);

        /**
         * <p>
         * The replication configuration for servers in the server group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sms.model.ServerReplicationConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sms.model.ServerReplicationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sms.model.ServerReplicationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #serverReplicationConfigurations(List<ServerReplicationConfiguration>)}.
         * 
         * @param serverReplicationConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sms.model.ServerReplicationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverReplicationConfigurations(java.util.Collection<ServerReplicationConfiguration>)
         */
        Builder serverReplicationConfigurations(
                Consumer<ServerReplicationConfiguration.Builder>... serverReplicationConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String serverGroupId;

        private List<ServerReplicationConfiguration> serverReplicationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServerGroupReplicationConfiguration model) {
            serverGroupId(model.serverGroupId);
            serverReplicationConfigurations(model.serverReplicationConfigurations);
        }

        public final String getServerGroupId() {
            return serverGroupId;
        }

        public final void setServerGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
        }

        @Override
        public final Builder serverGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
            return this;
        }

        public final List<ServerReplicationConfiguration.Builder> getServerReplicationConfigurations() {
            List<ServerReplicationConfiguration.Builder> result = ServerReplicationConfigurationsCopier
                    .copyToBuilder(this.serverReplicationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerReplicationConfigurations(
                Collection<ServerReplicationConfiguration.BuilderImpl> serverReplicationConfigurations) {
            this.serverReplicationConfigurations = ServerReplicationConfigurationsCopier
                    .copyFromBuilder(serverReplicationConfigurations);
        }

        @Override
        public final Builder serverReplicationConfigurations(
                Collection<ServerReplicationConfiguration> serverReplicationConfigurations) {
            this.serverReplicationConfigurations = ServerReplicationConfigurationsCopier.copy(serverReplicationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverReplicationConfigurations(ServerReplicationConfiguration... serverReplicationConfigurations) {
            serverReplicationConfigurations(Arrays.asList(serverReplicationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverReplicationConfigurations(
                Consumer<ServerReplicationConfiguration.Builder>... serverReplicationConfigurations) {
            serverReplicationConfigurations(Stream.of(serverReplicationConfigurations)
                    .map(c -> ServerReplicationConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ServerGroupReplicationConfiguration build() {
            return new ServerGroupReplicationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
