/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSmsSandboxPhoneNumberRequest extends SnsRequest implements
        ToCopyableBuilder<CreateSmsSandboxPhoneNumberRequest.Builder, CreateSmsSandboxPhoneNumberRequest> {
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(CreateSmsSandboxPhoneNumberRequest::phoneNumber))
            .setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(CreateSmsSandboxPhoneNumberRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_FIELD,
            LANGUAGE_CODE_FIELD));

    private final String phoneNumber;

    private final String languageCode;

    private CreateSmsSandboxPhoneNumberRequest(BuilderImpl builder) {
        super(builder);
        this.phoneNumber = builder.phoneNumber;
        this.languageCode = builder.languageCode;
    }

    /**
     * <p>
     * The destination phone number to verify. On verification, Amazon SNS adds this phone number to the list of
     * verified phone numbers that you can send SMS messages to.
     * </p>
     * 
     * @return The destination phone number to verify. On verification, Amazon SNS adds this phone number to the list of
     *         verified phone numbers that you can send SMS messages to.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * The language to use for sending the OTP. The default value is <code>en-US</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCodeString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language to use for sending the OTP. The default value is <code>en-US</code>.
     * @see LanguageCodeString
     */
    public final LanguageCodeString languageCode() {
        return LanguageCodeString.fromValue(languageCode);
    }

    /**
     * <p>
     * The language to use for sending the OTP. The default value is <code>en-US</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCodeString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language to use for sending the OTP. The default value is <code>en-US</code>.
     * @see LanguageCodeString
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSmsSandboxPhoneNumberRequest)) {
            return false;
        }
        CreateSmsSandboxPhoneNumberRequest other = (CreateSmsSandboxPhoneNumberRequest) obj;
        return Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSmsSandboxPhoneNumberRequest").add("PhoneNumber", phoneNumber())
                .add("LanguageCode", languageCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSmsSandboxPhoneNumberRequest, T> g) {
        return obj -> g.apply((CreateSmsSandboxPhoneNumberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSmsSandboxPhoneNumberRequest> {
        /**
         * <p>
         * The destination phone number to verify. On verification, Amazon SNS adds this phone number to the list of
         * verified phone numbers that you can send SMS messages to.
         * </p>
         * 
         * @param phoneNumber
         *        The destination phone number to verify. On verification, Amazon SNS adds this phone number to the list
         *        of verified phone numbers that you can send SMS messages to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The language to use for sending the OTP. The default value is <code>en-US</code>.
         * </p>
         * 
         * @param languageCode
         *        The language to use for sending the OTP. The default value is <code>en-US</code>.
         * @see LanguageCodeString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCodeString
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language to use for sending the OTP. The default value is <code>en-US</code>.
         * </p>
         * 
         * @param languageCode
         *        The language to use for sending the OTP. The default value is <code>en-US</code>.
         * @see LanguageCodeString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCodeString
         */
        Builder languageCode(LanguageCodeString languageCode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnsRequest.BuilderImpl implements Builder {
        private String phoneNumber;

        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSmsSandboxPhoneNumberRequest model) {
            super(model);
            phoneNumber(model.phoneNumber);
            languageCode(model.languageCode);
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        @Transient
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        @Transient
        public final Builder languageCode(LanguageCodeString languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSmsSandboxPhoneNumberRequest build() {
            return new CreateSmsSandboxPhoneNumberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
