/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest;
import software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse;

public class ListPhoneNumbersOptedOutIterable
implements SdkIterable<ListPhoneNumbersOptedOutResponse> {
    private final SnsClient client;
    private final ListPhoneNumbersOptedOutRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPhoneNumbersOptedOutIterable(SnsClient client, ListPhoneNumbersOptedOutRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPhoneNumbersOptedOutResponseFetcher();
    }

    public Iterator<ListPhoneNumbersOptedOutResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> phoneNumbers() {
        Function<ListPhoneNumbersOptedOutResponse, Iterator> getIterator = response -> {
            if (response != null && response.phoneNumbers() != null) {
                return response.phoneNumbers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPhoneNumbersOptedOutResponseFetcher
    implements SyncPageFetcher<ListPhoneNumbersOptedOutResponse> {
        private ListPhoneNumbersOptedOutResponseFetcher() {
        }

        public boolean hasNextPage(ListPhoneNumbersOptedOutResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPhoneNumbersOptedOutResponse nextPage(ListPhoneNumbersOptedOutResponse previousPage) {
            if (previousPage == null) {
                return ListPhoneNumbersOptedOutIterable.this.client.listPhoneNumbersOptedOut(ListPhoneNumbersOptedOutIterable.this.firstRequest);
            }
            return ListPhoneNumbersOptedOutIterable.this.client.listPhoneNumbersOptedOut((ListPhoneNumbersOptedOutRequest)((Object)ListPhoneNumbersOptedOutIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

