/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of phone numbers and their metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhoneNumberInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<PhoneNumberInformation.Builder, PhoneNumberInformation> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(PhoneNumberInformation::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(PhoneNumberInformation::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(PhoneNumberInformation::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ISO2_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Iso2CountryCode").getter(getter(PhoneNumberInformation::iso2CountryCode))
            .setter(setter(Builder::iso2CountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iso2CountryCode").build()).build();

    private static final SdkField<String> ROUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteType").getter(getter(PhoneNumberInformation::routeTypeAsString)).setter(setter(Builder::routeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteType").build()).build();

    private static final SdkField<List<String>> NUMBER_CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NumberCapabilities")
            .getter(getter(PhoneNumberInformation::numberCapabilitiesAsStrings))
            .setter(setter(Builder::numberCapabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberCapabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            PHONE_NUMBER_FIELD, STATUS_FIELD, ISO2_COUNTRY_CODE_FIELD, ROUTE_TYPE_FIELD, NUMBER_CAPABILITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String phoneNumber;

    private final String status;

    private final String iso2CountryCode;

    private final String routeType;

    private final List<String> numberCapabilities;

    private PhoneNumberInformation(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.phoneNumber = builder.phoneNumber;
        this.status = builder.status;
        this.iso2CountryCode = builder.iso2CountryCode;
        this.routeType = builder.routeType;
        this.numberCapabilities = builder.numberCapabilities;
    }

    /**
     * <p>
     * The date and time when the phone number was created.
     * </p>
     * 
     * @return The date and time when the phone number was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The phone number.
     * </p>
     * 
     * @return The phone number.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * The status of the phone number.
     * </p>
     * 
     * @return The status of the phone number.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The two-character code for the country or region, in ISO 3166-1 alpha-2 format.
     * </p>
     * 
     * @return The two-character code for the country or region, in ISO 3166-1 alpha-2 format.
     */
    public final String iso2CountryCode() {
        return iso2CountryCode;
    }

    /**
     * <p>
     * The list of supported routes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routeType} will
     * return {@link RouteType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #routeTypeAsString}.
     * </p>
     * 
     * @return The list of supported routes.
     * @see RouteType
     */
    public final RouteType routeType() {
        return RouteType.fromValue(routeType);
    }

    /**
     * <p>
     * The list of supported routes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routeType} will
     * return {@link RouteType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #routeTypeAsString}.
     * </p>
     * 
     * @return The list of supported routes.
     * @see RouteType
     */
    public final String routeTypeAsString() {
        return routeType;
    }

    /**
     * <p>
     * The capabilities of each phone number.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNumberCapabilities} method.
     * </p>
     * 
     * @return The capabilities of each phone number.
     */
    public final List<NumberCapability> numberCapabilities() {
        return NumberCapabilityListCopier.copyStringToEnum(numberCapabilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the NumberCapabilities property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNumberCapabilities() {
        return numberCapabilities != null && !(numberCapabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capabilities of each phone number.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNumberCapabilities} method.
     * </p>
     * 
     * @return The capabilities of each phone number.
     */
    public final List<String> numberCapabilitiesAsStrings() {
        return numberCapabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(iso2CountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(routeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasNumberCapabilities() ? numberCapabilitiesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumberInformation)) {
            return false;
        }
        PhoneNumberInformation other = (PhoneNumberInformation) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(status(), other.status()) && Objects.equals(iso2CountryCode(), other.iso2CountryCode())
                && Objects.equals(routeTypeAsString(), other.routeTypeAsString())
                && hasNumberCapabilities() == other.hasNumberCapabilities()
                && Objects.equals(numberCapabilitiesAsStrings(), other.numberCapabilitiesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PhoneNumberInformation").add("CreatedAt", createdAt())
                .add("PhoneNumber", phoneNumber() == null ? null : "*** Sensitive Data Redacted ***").add("Status", status())
                .add("Iso2CountryCode", iso2CountryCode()).add("RouteType", routeTypeAsString())
                .add("NumberCapabilities", hasNumberCapabilities() ? numberCapabilitiesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Iso2CountryCode":
            return Optional.ofNullable(clazz.cast(iso2CountryCode()));
        case "RouteType":
            return Optional.ofNullable(clazz.cast(routeTypeAsString()));
        case "NumberCapabilities":
            return Optional.ofNullable(clazz.cast(numberCapabilitiesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("PhoneNumber", PHONE_NUMBER_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Iso2CountryCode", ISO2_COUNTRY_CODE_FIELD);
        map.put("RouteType", ROUTE_TYPE_FIELD);
        map.put("NumberCapabilities", NUMBER_CAPABILITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhoneNumberInformation, T> g) {
        return obj -> g.apply((PhoneNumberInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PhoneNumberInformation> {
        /**
         * <p>
         * The date and time when the phone number was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the phone number was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The phone number.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The status of the phone number.
         * </p>
         * 
         * @param status
         *        The status of the phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The two-character code for the country or region, in ISO 3166-1 alpha-2 format.
         * </p>
         * 
         * @param iso2CountryCode
         *        The two-character code for the country or region, in ISO 3166-1 alpha-2 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iso2CountryCode(String iso2CountryCode);

        /**
         * <p>
         * The list of supported routes.
         * </p>
         * 
         * @param routeType
         *        The list of supported routes.
         * @see RouteType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteType
         */
        Builder routeType(String routeType);

        /**
         * <p>
         * The list of supported routes.
         * </p>
         * 
         * @param routeType
         *        The list of supported routes.
         * @see RouteType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteType
         */
        Builder routeType(RouteType routeType);

        /**
         * <p>
         * The capabilities of each phone number.
         * </p>
         * 
         * @param numberCapabilities
         *        The capabilities of each phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberCapabilitiesWithStrings(Collection<String> numberCapabilities);

        /**
         * <p>
         * The capabilities of each phone number.
         * </p>
         * 
         * @param numberCapabilities
         *        The capabilities of each phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberCapabilitiesWithStrings(String... numberCapabilities);

        /**
         * <p>
         * The capabilities of each phone number.
         * </p>
         * 
         * @param numberCapabilities
         *        The capabilities of each phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberCapabilities(Collection<NumberCapability> numberCapabilities);

        /**
         * <p>
         * The capabilities of each phone number.
         * </p>
         * 
         * @param numberCapabilities
         *        The capabilities of each phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberCapabilities(NumberCapability... numberCapabilities);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String phoneNumber;

        private String status;

        private String iso2CountryCode;

        private String routeType;

        private List<String> numberCapabilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PhoneNumberInformation model) {
            createdAt(model.createdAt);
            phoneNumber(model.phoneNumber);
            status(model.status);
            iso2CountryCode(model.iso2CountryCode);
            routeType(model.routeType);
            numberCapabilitiesWithStrings(model.numberCapabilities);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getIso2CountryCode() {
            return iso2CountryCode;
        }

        public final void setIso2CountryCode(String iso2CountryCode) {
            this.iso2CountryCode = iso2CountryCode;
        }

        @Override
        public final Builder iso2CountryCode(String iso2CountryCode) {
            this.iso2CountryCode = iso2CountryCode;
            return this;
        }

        public final String getRouteType() {
            return routeType;
        }

        public final void setRouteType(String routeType) {
            this.routeType = routeType;
        }

        @Override
        public final Builder routeType(String routeType) {
            this.routeType = routeType;
            return this;
        }

        @Override
        public final Builder routeType(RouteType routeType) {
            this.routeType(routeType == null ? null : routeType.toString());
            return this;
        }

        public final Collection<String> getNumberCapabilities() {
            if (numberCapabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return numberCapabilities;
        }

        public final void setNumberCapabilities(Collection<String> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copy(numberCapabilities);
        }

        @Override
        public final Builder numberCapabilitiesWithStrings(Collection<String> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copy(numberCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberCapabilitiesWithStrings(String... numberCapabilities) {
            numberCapabilitiesWithStrings(Arrays.asList(numberCapabilities));
            return this;
        }

        @Override
        public final Builder numberCapabilities(Collection<NumberCapability> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copyEnumToString(numberCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberCapabilities(NumberCapability... numberCapabilities) {
            numberCapabilities(Arrays.asList(numberCapabilities));
            return this;
        }

        @Override
        public PhoneNumberInformation build() {
            return new PhoneNumberInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
