/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.InventorySchemaDeleteOption;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteInventoryRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, DeleteInventoryRequest> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(DeleteInventoryRequest.getter(DeleteInventoryRequest::typeName)).setter(DeleteInventoryRequest.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> SCHEMA_DELETE_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaDeleteOption").getter(DeleteInventoryRequest.getter(DeleteInventoryRequest::schemaDeleteOptionAsString)).setter(DeleteInventoryRequest.setter(Builder::schemaDeleteOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaDeleteOption").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DeleteInventoryRequest.getter(DeleteInventoryRequest::dryRun)).setter(DeleteInventoryRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(DeleteInventoryRequest.getter(DeleteInventoryRequest::clientToken)).setter(DeleteInventoryRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD, SCHEMA_DELETE_OPTION_FIELD, DRY_RUN_FIELD, CLIENT_TOKEN_FIELD));
    private final String typeName;
    private final String schemaDeleteOption;
    private final Boolean dryRun;
    private final String clientToken;

    private DeleteInventoryRequest(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.schemaDeleteOption = builder.schemaDeleteOption;
        this.dryRun = builder.dryRun;
        this.clientToken = builder.clientToken;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final InventorySchemaDeleteOption schemaDeleteOption() {
        return InventorySchemaDeleteOption.fromValue(this.schemaDeleteOption);
    }

    public final String schemaDeleteOptionAsString() {
        return this.schemaDeleteOption;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaDeleteOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInventoryRequest)) {
            return false;
        }
        DeleteInventoryRequest other = (DeleteInventoryRequest)((Object)obj);
        return Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.schemaDeleteOptionAsString(), other.schemaDeleteOptionAsString()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteInventoryRequest").add("TypeName", (Object)this.typeName()).add("SchemaDeleteOption", (Object)this.schemaDeleteOptionAsString()).add("DryRun", (Object)this.dryRun()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "SchemaDeleteOption": {
                return Optional.ofNullable(clazz.cast(this.schemaDeleteOptionAsString()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteInventoryRequest, T> g) {
        return obj -> g.apply((DeleteInventoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String typeName;
        private String schemaDeleteOption;
        private Boolean dryRun;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInventoryRequest model) {
            super(model);
            this.typeName(model.typeName);
            this.schemaDeleteOption(model.schemaDeleteOption);
            this.dryRun(model.dryRun);
            this.clientToken(model.clientToken);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        @Transient
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getSchemaDeleteOption() {
            return this.schemaDeleteOption;
        }

        public final void setSchemaDeleteOption(String schemaDeleteOption) {
            this.schemaDeleteOption = schemaDeleteOption;
        }

        @Override
        @Transient
        public final Builder schemaDeleteOption(String schemaDeleteOption) {
            this.schemaDeleteOption = schemaDeleteOption;
            return this;
        }

        @Override
        @Transient
        public final Builder schemaDeleteOption(InventorySchemaDeleteOption schemaDeleteOption) {
            this.schemaDeleteOption(schemaDeleteOption == null ? null : schemaDeleteOption.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        @Transient
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteInventoryRequest build() {
            return new DeleteInventoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteInventoryRequest> {
        public Builder typeName(String var1);

        public Builder schemaDeleteOption(String var1);

        public Builder schemaDeleteOption(InventorySchemaDeleteOption var1);

        public Builder dryRun(Boolean var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

