/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The OpsData summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpsEntityItem implements SdkPojo, Serializable, ToCopyableBuilder<OpsEntityItem.Builder, OpsEntityItem> {
    private static final SdkField<String> CAPTURE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CaptureTime").getter(getter(OpsEntityItem::captureTime)).setter(setter(Builder::captureTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptureTime").build()).build();

    private static final SdkField<List<Map<String, String>>> CONTENT_FIELD = SdkField
            .<List<Map<String, String>>> builder(MarshallingType.LIST)
            .memberName("Content")
            .getter(getter(OpsEntityItem::content))
            .setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPTURE_TIME_FIELD,
            CONTENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String captureTime;

    private final List<Map<String, String>> content;

    private OpsEntityItem(BuilderImpl builder) {
        this.captureTime = builder.captureTime;
        this.content = builder.content;
    }

    /**
     * <p>
     * The time the OpsData was captured.
     * </p>
     * 
     * @return The time the OpsData was captured.
     */
    public final String captureTime() {
        return captureTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Content property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContent() {
        return content != null && !(content instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of an OpsData summary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContent} method.
     * </p>
     * 
     * @return The details of an OpsData summary.
     */
    public final List<Map<String, String>> content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(captureTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasContent() ? content() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpsEntityItem)) {
            return false;
        }
        OpsEntityItem other = (OpsEntityItem) obj;
        return Objects.equals(captureTime(), other.captureTime()) && hasContent() == other.hasContent()
                && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpsEntityItem").add("CaptureTime", captureTime())
                .add("Content", hasContent() ? content() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CaptureTime":
            return Optional.ofNullable(clazz.cast(captureTime()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpsEntityItem, T> g) {
        return obj -> g.apply((OpsEntityItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpsEntityItem> {
        /**
         * <p>
         * The time the OpsData was captured.
         * </p>
         * 
         * @param captureTime
         *        The time the OpsData was captured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captureTime(String captureTime);

        /**
         * <p>
         * The details of an OpsData summary.
         * </p>
         * 
         * @param content
         *        The details of an OpsData summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(Collection<? extends Map<String, String>> content);

        /**
         * <p>
         * The details of an OpsData summary.
         * </p>
         * 
         * @param content
         *        The details of an OpsData summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(Map<String, String>... content);
    }

    static final class BuilderImpl implements Builder {
        private String captureTime;

        private List<Map<String, String>> content = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpsEntityItem model) {
            captureTime(model.captureTime);
            content(model.content);
        }

        public final String getCaptureTime() {
            return captureTime;
        }

        public final void setCaptureTime(String captureTime) {
            this.captureTime = captureTime;
        }

        @Override
        public final Builder captureTime(String captureTime) {
            this.captureTime = captureTime;
            return this;
        }

        public final Collection<? extends Map<String, String>> getContent() {
            if (content instanceof SdkAutoConstructList) {
                return null;
            }
            return content;
        }

        public final void setContent(Collection<? extends Map<String, String>> content) {
            this.content = OpsEntityItemEntryListCopier.copy(content);
        }

        @Override
        public final Builder content(Collection<? extends Map<String, String>> content) {
            this.content = OpsEntityItemEntryListCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Map<String, String>... content) {
            content(Arrays.asList(content));
            return this;
        }

        @Override
        public OpsEntityItem build() {
            return new OpsEntityItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
