/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The combination of Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Automation
 * execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetLocation implements SdkPojo, Serializable, ToCopyableBuilder<TargetLocation.Builder, TargetLocation> {
    private static final SdkField<List<String>> ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Accounts")
            .getter(getter(TargetLocation::accounts))
            .setter(setter(Builder::accounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Regions")
            .getter(getter(TargetLocation::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TARGET_LOCATION_MAX_CONCURRENCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetLocationMaxConcurrency")
            .getter(getter(TargetLocation::targetLocationMaxConcurrency))
            .setter(setter(Builder::targetLocationMaxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocationMaxConcurrency")
                    .build()).build();

    private static final SdkField<String> TARGET_LOCATION_MAX_ERRORS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetLocationMaxErrors").getter(getter(TargetLocation::targetLocationMaxErrors))
            .setter(setter(Builder::targetLocationMaxErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocationMaxErrors").build())
            .build();

    private static final SdkField<String> EXECUTION_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleName").getter(getter(TargetLocation::executionRoleName))
            .setter(setter(Builder::executionRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleName").build()).build();

    private static final SdkField<AlarmConfiguration> TARGET_LOCATION_ALARM_CONFIGURATION_FIELD = SdkField
            .<AlarmConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("TargetLocationAlarmConfiguration")
            .getter(getter(TargetLocation::targetLocationAlarmConfiguration))
            .setter(setter(Builder::targetLocationAlarmConfiguration))
            .constructor(AlarmConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocationAlarmConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_FIELD, REGIONS_FIELD,
            TARGET_LOCATION_MAX_CONCURRENCY_FIELD, TARGET_LOCATION_MAX_ERRORS_FIELD, EXECUTION_ROLE_NAME_FIELD,
            TARGET_LOCATION_ALARM_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> accounts;

    private final List<String> regions;

    private final String targetLocationMaxConcurrency;

    private final String targetLocationMaxErrors;

    private final String executionRoleName;

    private final AlarmConfiguration targetLocationAlarmConfiguration;

    private TargetLocation(BuilderImpl builder) {
        this.accounts = builder.accounts;
        this.regions = builder.regions;
        this.targetLocationMaxConcurrency = builder.targetLocationMaxConcurrency;
        this.targetLocationMaxErrors = builder.targetLocationMaxErrors;
        this.executionRoleName = builder.executionRoleName;
        this.targetLocationAlarmConfiguration = builder.targetLocationAlarmConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Accounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccounts() {
        return accounts != null && !(accounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services accounts targeted by the current Automation execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccounts} method.
     * </p>
     * 
     * @return The Amazon Web Services accounts targeted by the current Automation execution.
     */
    public final List<String> accounts() {
        return accounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services Regions targeted by the current Automation execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return The Amazon Web Services Regions targeted by the current Automation execution.
     */
    public final List<String> regions() {
        return regions;
    }

    /**
     * <p>
     * The maximum number of Amazon Web Services Regions and Amazon Web Services accounts allowed to run the Automation
     * concurrently.
     * </p>
     * 
     * @return The maximum number of Amazon Web Services Regions and Amazon Web Services accounts allowed to run the
     *         Automation concurrently.
     */
    public final String targetLocationMaxConcurrency() {
        return targetLocationMaxConcurrency;
    }

    /**
     * <p>
     * The maximum number of errors allowed before the system stops queueing additional Automation executions for the
     * currently running Automation.
     * </p>
     * 
     * @return The maximum number of errors allowed before the system stops queueing additional Automation executions
     *         for the currently running Automation.
     */
    public final String targetLocationMaxErrors() {
        return targetLocationMaxErrors;
    }

    /**
     * <p>
     * The Automation execution role used by the currently running Automation. If not specified, the default value is
     * <code>AWS-SystemsManager-AutomationExecutionRole</code>.
     * </p>
     * 
     * @return The Automation execution role used by the currently running Automation. If not specified, the default
     *         value is <code>AWS-SystemsManager-AutomationExecutionRole</code>.
     */
    public final String executionRoleName() {
        return executionRoleName;
    }

    /**
     * Returns the value of the TargetLocationAlarmConfiguration property for this object.
     * 
     * @return The value of the TargetLocationAlarmConfiguration property for this object.
     */
    public final AlarmConfiguration targetLocationAlarmConfiguration() {
        return targetLocationAlarmConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccounts() ? accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetLocationMaxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(targetLocationMaxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(targetLocationAlarmConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetLocation)) {
            return false;
        }
        TargetLocation other = (TargetLocation) obj;
        return hasAccounts() == other.hasAccounts() && Objects.equals(accounts(), other.accounts())
                && hasRegions() == other.hasRegions() && Objects.equals(regions(), other.regions())
                && Objects.equals(targetLocationMaxConcurrency(), other.targetLocationMaxConcurrency())
                && Objects.equals(targetLocationMaxErrors(), other.targetLocationMaxErrors())
                && Objects.equals(executionRoleName(), other.executionRoleName())
                && Objects.equals(targetLocationAlarmConfiguration(), other.targetLocationAlarmConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetLocation").add("Accounts", hasAccounts() ? accounts() : null)
                .add("Regions", hasRegions() ? regions() : null)
                .add("TargetLocationMaxConcurrency", targetLocationMaxConcurrency())
                .add("TargetLocationMaxErrors", targetLocationMaxErrors()).add("ExecutionRoleName", executionRoleName())
                .add("TargetLocationAlarmConfiguration", targetLocationAlarmConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Accounts":
            return Optional.ofNullable(clazz.cast(accounts()));
        case "Regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "TargetLocationMaxConcurrency":
            return Optional.ofNullable(clazz.cast(targetLocationMaxConcurrency()));
        case "TargetLocationMaxErrors":
            return Optional.ofNullable(clazz.cast(targetLocationMaxErrors()));
        case "ExecutionRoleName":
            return Optional.ofNullable(clazz.cast(executionRoleName()));
        case "TargetLocationAlarmConfiguration":
            return Optional.ofNullable(clazz.cast(targetLocationAlarmConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetLocation, T> g) {
        return obj -> g.apply((TargetLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetLocation> {
        /**
         * <p>
         * The Amazon Web Services accounts targeted by the current Automation execution.
         * </p>
         * 
         * @param accounts
         *        The Amazon Web Services accounts targeted by the current Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(Collection<String> accounts);

        /**
         * <p>
         * The Amazon Web Services accounts targeted by the current Automation execution.
         * </p>
         * 
         * @param accounts
         *        The Amazon Web Services accounts targeted by the current Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(String... accounts);

        /**
         * <p>
         * The Amazon Web Services Regions targeted by the current Automation execution.
         * </p>
         * 
         * @param regions
         *        The Amazon Web Services Regions targeted by the current Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * The Amazon Web Services Regions targeted by the current Automation execution.
         * </p>
         * 
         * @param regions
         *        The Amazon Web Services Regions targeted by the current Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * The maximum number of Amazon Web Services Regions and Amazon Web Services accounts allowed to run the
         * Automation concurrently.
         * </p>
         * 
         * @param targetLocationMaxConcurrency
         *        The maximum number of Amazon Web Services Regions and Amazon Web Services accounts allowed to run the
         *        Automation concurrently.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocationMaxConcurrency(String targetLocationMaxConcurrency);

        /**
         * <p>
         * The maximum number of errors allowed before the system stops queueing additional Automation executions for
         * the currently running Automation.
         * </p>
         * 
         * @param targetLocationMaxErrors
         *        The maximum number of errors allowed before the system stops queueing additional Automation executions
         *        for the currently running Automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocationMaxErrors(String targetLocationMaxErrors);

        /**
         * <p>
         * The Automation execution role used by the currently running Automation. If not specified, the default value
         * is <code>AWS-SystemsManager-AutomationExecutionRole</code>.
         * </p>
         * 
         * @param executionRoleName
         *        The Automation execution role used by the currently running Automation. If not specified, the default
         *        value is <code>AWS-SystemsManager-AutomationExecutionRole</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleName(String executionRoleName);

        /**
         * Sets the value of the TargetLocationAlarmConfiguration property for this object.
         *
         * @param targetLocationAlarmConfiguration
         *        The new value for the TargetLocationAlarmConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocationAlarmConfiguration(AlarmConfiguration targetLocationAlarmConfiguration);

        /**
         * Sets the value of the TargetLocationAlarmConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AlarmConfiguration.Builder} avoiding the
         * need to create one manually via {@link AlarmConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlarmConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #targetLocationAlarmConfiguration(AlarmConfiguration)}.
         * 
         * @param targetLocationAlarmConfiguration
         *        a consumer that will call methods on {@link AlarmConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetLocationAlarmConfiguration(AlarmConfiguration)
         */
        default Builder targetLocationAlarmConfiguration(Consumer<AlarmConfiguration.Builder> targetLocationAlarmConfiguration) {
            return targetLocationAlarmConfiguration(AlarmConfiguration.builder().applyMutation(targetLocationAlarmConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> accounts = DefaultSdkAutoConstructList.getInstance();

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private String targetLocationMaxConcurrency;

        private String targetLocationMaxErrors;

        private String executionRoleName;

        private AlarmConfiguration targetLocationAlarmConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetLocation model) {
            accounts(model.accounts);
            regions(model.regions);
            targetLocationMaxConcurrency(model.targetLocationMaxConcurrency);
            targetLocationMaxErrors(model.targetLocationMaxErrors);
            executionRoleName(model.executionRoleName);
            targetLocationAlarmConfiguration(model.targetLocationAlarmConfiguration);
        }

        public final Collection<String> getAccounts() {
            if (accounts instanceof SdkAutoConstructList) {
                return null;
            }
            return accounts;
        }

        public final void setAccounts(Collection<String> accounts) {
            this.accounts = AccountsCopier.copy(accounts);
        }

        @Override
        public final Builder accounts(Collection<String> accounts) {
            this.accounts = AccountsCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(String... accounts) {
            accounts(Arrays.asList(accounts));
            return this;
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final String getTargetLocationMaxConcurrency() {
            return targetLocationMaxConcurrency;
        }

        public final void setTargetLocationMaxConcurrency(String targetLocationMaxConcurrency) {
            this.targetLocationMaxConcurrency = targetLocationMaxConcurrency;
        }

        @Override
        public final Builder targetLocationMaxConcurrency(String targetLocationMaxConcurrency) {
            this.targetLocationMaxConcurrency = targetLocationMaxConcurrency;
            return this;
        }

        public final String getTargetLocationMaxErrors() {
            return targetLocationMaxErrors;
        }

        public final void setTargetLocationMaxErrors(String targetLocationMaxErrors) {
            this.targetLocationMaxErrors = targetLocationMaxErrors;
        }

        @Override
        public final Builder targetLocationMaxErrors(String targetLocationMaxErrors) {
            this.targetLocationMaxErrors = targetLocationMaxErrors;
            return this;
        }

        public final String getExecutionRoleName() {
            return executionRoleName;
        }

        public final void setExecutionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
        }

        @Override
        public final Builder executionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
            return this;
        }

        public final AlarmConfiguration.Builder getTargetLocationAlarmConfiguration() {
            return targetLocationAlarmConfiguration != null ? targetLocationAlarmConfiguration.toBuilder() : null;
        }

        public final void setTargetLocationAlarmConfiguration(AlarmConfiguration.BuilderImpl targetLocationAlarmConfiguration) {
            this.targetLocationAlarmConfiguration = targetLocationAlarmConfiguration != null ? targetLocationAlarmConfiguration
                    .build() : null;
        }

        @Override
        public final Builder targetLocationAlarmConfiguration(AlarmConfiguration targetLocationAlarmConfiguration) {
            this.targetLocationAlarmConfiguration = targetLocationAlarmConfiguration;
            return this;
        }

        @Override
        public TargetLocation build() {
            return new TargetLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
