/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest;
import software.amazon.awssdk.services.ssm.model.GetOpsSummaryResponse;
import software.amazon.awssdk.services.ssm.model.OpsEntity;

public class GetOpsSummaryPublisher
implements SdkPublisher<GetOpsSummaryResponse> {
    private final SsmAsyncClient client;
    private final GetOpsSummaryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetOpsSummaryPublisher(SsmAsyncClient client, GetOpsSummaryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetOpsSummaryPublisher(SsmAsyncClient client, GetOpsSummaryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetOpsSummaryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetOpsSummaryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OpsEntity> entities() {
        Function<GetOpsSummaryResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetOpsSummaryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetOpsSummaryResponseFetcher
    implements AsyncPageFetcher<GetOpsSummaryResponse> {
        private GetOpsSummaryResponseFetcher() {
        }

        public boolean hasNextPage(GetOpsSummaryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetOpsSummaryResponse> nextPage(GetOpsSummaryResponse previousPage) {
            if (previousPage == null) {
                return GetOpsSummaryPublisher.this.client.getOpsSummary(GetOpsSummaryPublisher.this.firstRequest);
            }
            return GetOpsSummaryPublisher.this.client.getOpsSummary((GetOpsSummaryRequest)((Object)GetOpsSummaryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

